/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;

public class CXFAuthenticator
extends Authenticator {
    static Authenticator wrapped;
    static boolean setup;

    public CXFAuthenticator() {
        try {
            for (Field f2 : Authenticator.class.getDeclaredFields()) {
                if (!f2.getType().equals(Authenticator.class)) continue;
                f2.setAccessible(true);
                wrapped = (Authenticator)f2.get(null);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static synchronized void addAuthenticator() {
        if (!setup) {
            try {
                Authenticator.setDefault(new CXFAuthenticator());
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            setup = true;
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        Exchange exchange;
        Conduit conduit;
        Object m;
        PasswordAuthentication auth = null;
        if (wrapped != null) {
            try {
                for (Field f2 : Authenticator.class.getDeclaredFields()) {
                    if (Modifier.isStatic(f2.getModifiers())) continue;
                    f2.setAccessible(true);
                    f2.set(wrapped, f2.get(this));
                }
                m = Authenticator.class.getDeclaredMethod("getPasswordAuthentication", new Class[0]);
                ((Method)m).setAccessible(true);
                auth = (PasswordAuthentication)((Method)m).invoke((Object)wrapped, new Object[0]);
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        if (auth != null) {
            return auth;
        }
        m = PhaseInterceptorChain.getCurrentMessage();
        if (m != null && (conduit = (exchange = m.getExchange()).getConduit((Message)m)) instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && httpConduit.getProxyAuthorization() != null) {
                String un = httpConduit.getProxyAuthorization().getUserName();
                String pwd = httpConduit.getProxyAuthorization().getPassword();
                if (un != null && pwd != null) {
                    auth = new PasswordAuthentication(un, pwd.toCharArray());
                }
            } else if (this.getRequestorType() == Authenticator.RequestorType.SERVER && httpConduit.getAuthorization() != null) {
                String un = httpConduit.getAuthorization().getUserName();
                String pwd = httpConduit.getAuthorization().getPassword();
                if (un != null && pwd != null) {
                    auth = new PasswordAuthentication(un, pwd.toCharArray());
                }
            }
        }
        return auth;
    }
}

