/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;

final class ChunkedUtil {
    private ChunkedUtil() {
    }

    public static InputStream getPartialResponse(HttpURLConnection connection, int responseCode) throws IOException {
        InputStream in2 = null;
        if (responseCode == 202 || responseCode == 200) {
            if (connection.getContentLength() > 0) {
                in2 = connection.getInputStream();
            } else if (ChunkedUtil.hasChunkedResponse(connection) || ChunkedUtil.hasEofTerminatedResponse(connection)) {
                in2 = ChunkedUtil.getNonEmptyContent(connection);
            }
        }
        return in2;
    }

    private static boolean hasChunkedResponse(HttpURLConnection connection) {
        return "chunked".equalsIgnoreCase(connection.getHeaderField("Transfer-Encoding"));
    }

    private static boolean hasEofTerminatedResponse(HttpURLConnection connection) {
        return "close".equalsIgnoreCase(connection.getHeaderField("Connection"));
    }

    private static InputStream getNonEmptyContent(HttpURLConnection connection) {
        PushbackInputStream in2 = null;
        try {
            PushbackInputStream pin = new PushbackInputStream(connection.getInputStream());
            int c2 = pin.read();
            if (c2 != -1) {
                pin.unread((byte)c2);
                in2 = pin;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return in2;
    }
}

