/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractObservable;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationRegistryImpl
implements DestinationRegistry {
    private ConcurrentMap<String, AbstractHTTPDestination> destinations = new ConcurrentHashMap<String, AbstractHTTPDestination>();
    private Map<String, AbstractHTTPDestination> decodedDestinations = new ConcurrentHashMap<String, AbstractHTTPDestination>();

    @Override
    public void addDestination(AbstractHTTPDestination destination) {
        String path2 = DestinationRegistryImpl.getTrimmedPath(destination.getEndpointInfo().getAddress());
        this.destinations.putIfAbsent(path2, destination);
        try {
            this.decodedDestinations.put(URLDecoder.decode(path2, "ISO-8859-1"), destination);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("Unsupported Encoding", e2);
        }
    }

    @Override
    public void removeDestination(String path2) {
        this.destinations.remove(path2);
        try {
            this.decodedDestinations.remove(URLDecoder.decode(path2, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException("Unsupported Encoding", e2);
        }
    }

    @Override
    public AbstractHTTPDestination getDestinationForPath(String path2) {
        return this.getDestinationForPath(path2, false);
    }

    @Override
    public AbstractHTTPDestination getDestinationForPath(String path2, boolean tryDecoding) {
        String m = DestinationRegistryImpl.getTrimmedPath(path2);
        AbstractHTTPDestination s2 = (AbstractHTTPDestination)this.destinations.get(m);
        if (s2 == null) {
            s2 = this.decodedDestinations.get(m);
        }
        return s2;
    }

    @Override
    public AbstractHTTPDestination checkRestfulRequest(String address) {
        int len2 = -1;
        AbstractObservable ret = null;
        for (String path2 : this.getDestinationsPaths()) {
            if (!address.startsWith(path2) || path2.length() <= len2) continue;
            ret = this.getDestinationForPath(path2);
            len2 = path2.length();
        }
        if (ret != null && ret.getMessageObserver() == null) {
            return null;
        }
        return ret;
    }

    @Override
    public Collection<AbstractHTTPDestination> getDestinations() {
        return Collections.unmodifiableCollection(this.destinations.values());
    }

    @Override
    public AbstractDestination[] getSortedDestinations() {
        LinkedList<AbstractHTTPDestination> dest2 = new LinkedList<AbstractHTTPDestination>(this.getDestinations());
        Collections.sort(dest2, new Comparator<AbstractHTTPDestination>(){

            @Override
            public int compare(AbstractHTTPDestination o1, AbstractHTTPDestination o2) {
                if (o1.getEndpointInfo().getInterface() == null) {
                    return -1;
                }
                if (o2.getEndpointInfo().getInterface() == null) {
                    return 1;
                }
                return o1.getEndpointInfo().getInterface().getName().getLocalPart().compareTo(o2.getEndpointInfo().getInterface().getName().getLocalPart());
            }
        });
        return dest2.toArray(new AbstractDestination[0]);
    }

    @Override
    public Set<String> getDestinationsPaths() {
        return Collections.unmodifiableSet(this.destinations.keySet());
    }

    public static String getTrimmedPath(String path2) {
        if (path2 == null) {
            return "/";
        }
        String lh = "http://localhost/";
        String lhs = "https://localhost/";
        if (path2.startsWith("http://localhost/")) {
            path2 = path2.substring("http://localhost/".length());
        } else if (path2.startsWith("https://localhost/")) {
            path2 = path2.substring("https://localhost/".length());
        }
        if (!path2.contains("://") && !path2.startsWith("/")) {
            path2 = "/" + path2;
        }
        return path2;
    }
}

