/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;

final class TrustDecisionUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(TrustDecisionUtil.class);

    private TrustDecisionUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void makeTrustDecision(MessageTrustDecider trustDecider, Message message, HttpURLConnection connection, String conduitName) throws IOException {
        MessageTrustDecider decider2 = message.get(MessageTrustDecider.class);
        if (trustDecider != null || decider2 != null) {
            try {
                connection.connect();
                HttpsURLConnectionInfo info2 = new HttpsURLConnectionInfo(connection);
                if (trustDecider != null) {
                    trustDecider.establishTrust(conduitName, info2, message);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Trust Decider " + trustDecider.getLogicalName() + " considers Conduit " + conduitName + " trusted.");
                    }
                }
                if (decider2 == null) return;
                decider2.establishTrust(conduitName, info2, message);
                if (!LOG.isLoggable(Level.FINE)) return;
                LOG.log(Level.FINE, "Trust Decider " + decider2.getLogicalName() + " considers Conduit " + conduitName + " trusted.");
                return;
            }
            catch (UntrustedURLConnectionIOException untrustedEx) {
                connection.disconnect();
                if (!LOG.isLoggable(Level.FINE)) throw untrustedEx;
                LOG.log(Level.FINE, "Trust Decider " + trustDecider.getLogicalName() + " considers Conduit " + conduitName + " untrusted.", untrustedEx);
                throw untrustedEx;
            }
        } else {
            if (!LOG.isLoggable(Level.FINE)) return;
            LOG.log(Level.FINE, "No Trust Decider for Conduit '" + conduitName + "'. An afirmative Trust Decision is assumed.");
        }
    }
}

