/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.auth;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpAuthHeader {
    public static final String AUTH_TYPE_BASIC = "Basic";
    public static final String AUTH_TYPE_DIGEST = "Digest";
    public static final String AUTH_TYPE_NEGOTIATE = "Negotiate";
    private String fullHeader;
    private String authType;
    private String fullContent;
    private Map<String, String> params;

    public HttpAuthHeader(String fullHeader) {
        this.fullHeader = fullHeader == null ? "" : fullHeader;
        int spacePos = this.fullHeader.indexOf(32);
        if (spacePos == -1) {
            this.authType = this.fullHeader;
            this.fullContent = "";
        } else {
            this.authType = this.fullHeader.substring(0, spacePos);
            this.fullContent = this.fullHeader.substring(spacePos + 1);
        }
        this.params = this.parseHeader();
    }

    public HttpAuthHeader(String authType, Map<String, String> params2) {
        this.authType = authType;
        this.params = params2;
        this.fullContent = this.paramsToString();
        this.fullHeader = authType + " " + this.fullContent;
    }

    private String paramsToString() {
        StringBuilder builder = new StringBuilder();
        boolean first2 = true;
        for (String key : this.params.keySet()) {
            String param2 = this.params.get(key);
            if (param2 == null) continue;
            if (!first2) {
                builder.append(", ");
            }
            builder.append(key + "=\"" + param2 + "\"");
            first2 = false;
        }
        return builder.toString();
    }

    private Map<String, String> parseHeader() {
        HashMap<String, String> map3 = new HashMap<String, String>();
        try {
            StreamTokenizer tok = new StreamTokenizer(new StringReader(this.fullContent));
            tok.quoteChar(34);
            tok.quoteChar(39);
            tok.whitespaceChars(61, 61);
            tok.whitespaceChars(44, 44);
            while (tok.nextToken() != -1) {
                String key = tok.sval;
                if (tok.nextToken() == -1) {
                    map3.put(key, null);
                    return map3;
                }
                String value2 = tok.sval;
                map3.put(key, value2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map3;
    }

    public String getRealm() {
        Map<String, String> map3 = this.parseHeader();
        return map3.get("realm");
    }

    public boolean authTypeIsDigest() {
        return AUTH_TYPE_DIGEST.equals(this.authType);
    }

    public boolean authTypeIsBasic() {
        return AUTH_TYPE_BASIC.equals(this.authType);
    }

    public boolean authTypeIsNegotiate() {
        return AUTH_TYPE_DIGEST.equals(this.authType);
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getFullContent() {
        return this.fullContent;
    }

    public String getFullHeader() {
        return this.fullHeader;
    }

    public Map<String, String> getParams() {
        return this.params;
    }
}

