/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.auth;

import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoAuthSupplier
implements HttpAuthSupplier {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static final Logger LOG = LogUtils.getL7dLogger(SpnegoAuthSupplier.class);
    private LoginContext lc;

    public boolean requiresRequestCaching() {
        return false;
    }

    public String getAuthorization(AuthorizationPolicy authPolicy, URL currentURL, Message message, String fullHeader) {
        if (!"Negotiate".equals(authPolicy.getAuthorizationType())) {
            return null;
        }
        try {
            String spn = "HTTP/" + currentURL.getHost();
            LOG.fine("Adding authorization service ticket for service principal name: " + spn);
            byte[] token2 = this.getToken(authPolicy, spn);
            return "Negotiate " + Base64Utility.encode(token2);
        }
        catch (LoginException e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
        catch (GSSException e3) {
            throw new RuntimeException(e3.getMessage(), e3);
        }
    }

    private byte[] getToken(AuthorizationPolicy authPolicy, GSSContext context) throws GSSException, LoginException {
        byte[] token2 = new byte[]{};
        if (authPolicy.getUserName() == null || authPolicy.getUserName().trim().length() == 0) {
            return context.initSecContext(token2, 0, token2.length);
        }
        if (this.lc == null) {
            this.lc = new LoginContext(authPolicy.getAuthorization(), SpnegoAuthSupplier.getUsernamePasswordHandler(authPolicy.getUserName(), authPolicy.getPassword()));
            this.lc.login();
        }
        try {
            return Subject.doAs(this.lc.getSubject(), new CreateServiceTicketAction(context, token2));
        }
        catch (PrivilegedActionException e2) {
            if (e2.getCause() instanceof GSSException) {
                throw (GSSException)e2.getCause();
            }
            LOG.log(Level.SEVERE, "initSecContext", e2);
            return null;
        }
    }

    private byte[] getToken(AuthorizationPolicy proxyAuthPolicy, String spn) throws GSSException, LoginException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName(spn, null);
        Oid oid = new Oid(KERBEROS_OID);
        GSSContext context = manager.createContext(serverName.canonicalize(oid), oid, null, 0);
        context.requestMutualAuth(true);
        context.requestCredDeleg(true);
        return this.getToken(proxyAuthPolicy, context);
    }

    public static CallbackHandler getUsernamePasswordHandler(final String username, final String password) {
        CallbackHandler handler = new CallbackHandler(){

            public void handle(Callback[] callback) {
                for (int i = 0; i < callback.length; ++i) {
                    if (callback[i] instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback[i];
                        nameCallback.setName(username);
                        continue;
                    }
                    if (!(callback[i] instanceof PasswordCallback)) continue;
                    PasswordCallback passCallback = (PasswordCallback)callback[i];
                    passCallback.setPassword(password.toCharArray());
                }
            }
        };
        return handler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreateServiceTicketAction
    implements PrivilegedExceptionAction<byte[]> {
        private final GSSContext context;
        private final byte[] token;

        private CreateServiceTicketAction(GSSContext context, byte[] token2) {
            this.context = context;
            this.token = token2;
        }

        @Override
        public byte[] run() throws GSSException {
            return this.context.initSecContext(this.token, 0, this.token.length);
        }
    }
}

