/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.spring;

import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.configuration.jsse.spring.TLSClientParametersConfig;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HttpConduitBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String HTTP_NS = "http://cxf.apache.org/transports/http/configuration";

    public void doParse(Element element2, ParserContext ctx, BeanDefinitionBuilder bean) {
        bean.setAbstract(true);
        this.mapElementToJaxbProperty(element2, bean, new QName(HTTP_NS, "client"), "client", HTTPClientPolicy.class);
        this.mapElementToJaxbProperty(element2, bean, new QName(HTTP_NS, "proxyAuthorization"), "proxyAuthorization", ProxyAuthorizationPolicy.class);
        this.mapElementToJaxbProperty(element2, bean, new QName(HTTP_NS, "authorization"), "authorization", AuthorizationPolicy.class);
        this.mapSpecificElements(element2, bean);
    }

    private void mapSpecificElements(Element parent2, BeanDefinitionBuilder bean) {
        Node n = parent2.getFirstChild();
        while (n != null) {
            if (1 != n.getNodeType() || !HTTP_NS.equals(n.getNamespaceURI())) {
                n = n.getNextSibling();
                continue;
            }
            String elementName = n.getLocalName();
            if ("trustDecider".equals(elementName)) {
                this.mapBeanOrClassElement((Element)n, bean, MessageTrustDecider.class);
            } else if ("authSupplier".equals(elementName)) {
                this.mapBeanOrClassElement((Element)n, bean, HttpAuthSupplier.class);
            } else if ("basicAuthSupplier".equals(elementName)) {
                this.mapBeanOrClassElement((Element)n, bean, HttpAuthSupplier.class);
            } else if ("tlsClientParameters".equals(elementName)) {
                this.mapTLSClientParameters((Element)n, bean);
            }
            n = n.getNextSibling();
        }
    }

    public void mapTLSClientParameters(Element n, BeanDefinitionBuilder bean) {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlWriter = StaxUtils.createXMLStreamWriter(writer);
        try {
            StaxUtils.copy(n, xmlWriter);
            xmlWriter.flush();
        }
        catch (XMLStreamException e2) {
            throw new RuntimeException(e2);
        }
        BeanDefinitionBuilder jaxbbean = BeanDefinitionBuilder.rootBeanDefinition(TLSClientParametersConfig.class);
        jaxbbean.getRawBeanDefinition().setFactoryMethodName("createTLSClientParameters");
        jaxbbean.addConstructorArg(writer.toString());
        bean.addPropertyValue("tlsClientParameters", jaxbbean.getBeanDefinition());
    }

    protected void mapBeanOrClassElement(Element element2, BeanDefinitionBuilder bean, Class elementClass) {
        String beanref;
        String elementName = element2.getLocalName();
        String classProperty = element2.getAttribute("class");
        if (classProperty != null && !classProperty.equals("")) {
            try {
                Object obj = ClassLoaderUtils.loadClass(classProperty, this.getClass()).newInstance();
                if (!elementClass.isInstance(obj)) {
                    throw new IllegalArgumentException("Element '" + elementName + "' must be of type " + elementClass.getName() + ".");
                }
                bean.addPropertyValue(elementName, obj);
            }
            catch (IllegalAccessException ex2) {
                throw new IllegalArgumentException("Element '" + elementName + "' could not load " + classProperty + " - " + ex2);
            }
            catch (ClassNotFoundException ex3) {
                throw new IllegalArgumentException("Element '" + elementName + "' could not load " + classProperty + " - " + ex3);
            }
            catch (InstantiationException ex4) {
                throw new IllegalArgumentException("Element '" + elementName + "' could not load " + classProperty + " - " + ex4);
            }
        }
        if ((beanref = element2.getAttribute("bean")) != null && !beanref.equals("")) {
            if (classProperty != null && !classProperty.equals("")) {
                throw new IllegalArgumentException("Element '" + elementName + "' cannot have both " + "\"bean\" and \"class\" attributes.");
            }
            bean.addPropertyReference(elementName, beanref);
        } else if (classProperty == null || classProperty.equals("")) {
            throw new IllegalArgumentException("Element '" + elementName + "' requires at least one of the " + "\"bean\" or \"class\" attributes.");
        }
    }

    protected Class getBeanClass(Element arg0) {
        return HTTPConduit.class;
    }
}

