/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.logging.LogUtils;

class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(SSLSocketFactoryWrapper.class);
    private SSLSocketFactory sslSocketFactory;
    private String[] ciphers;
    private String protocol;

    public SSLSocketFactoryWrapper(SSLSocketFactory sslSocketFactoryParam, String[] ciphersParam, String protocolParam) {
        this.sslSocketFactory = sslSocketFactoryParam;
        this.ciphers = ciphersParam;
        this.protocol = protocolParam;
    }

    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    public Socket createSocket() throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(), new Object[]{"unconnected", "unconnected"});
    }

    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(s2, host, port, autoClose), new Object[]{host, port});
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(host, port), new Object[]{host, port});
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(host, port, localHost, localPort), new Object[]{host, port});
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(host, port), new Object[]{host, port});
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableCipherSuites(this.sslSocketFactory.createSocket(address, port, localAddress, localPort), new Object[]{address, port});
    }

    private Socket enableCipherSuites(Socket s2, Object[] logParams) {
        String[] p;
        SSLSocket socket = (SSLSocket)s2;
        if (socket != null && this.ciphers != null) {
            socket.setEnabledCipherSuites(this.ciphers);
        }
        if (socket != null && this.protocol != null && (p = this.findProtocols(this.protocol, socket.getSupportedProtocols())) != null) {
            socket.setEnabledProtocols(p);
        }
        if (socket == null) {
            LogUtils.log(LOG, Level.SEVERE, "PROBLEM_CREATING_OUTBOUND_REQUEST_SOCKET", logParams);
        }
        return socket;
    }

    private String[] findProtocols(String p, String[] options) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s2 : options) {
            if (s2.equals(p)) {
                return new String[]{p};
            }
            if (!s2.startsWith(p)) continue;
            list2.add(s2);
        }
        if (list2.isEmpty()) {
            return null;
        }
        return list2.toArray(new String[list2.size()]);
    }

    protected void addLogHandler(Handler handler) {
        LOG.addHandler(handler);
    }
}

