/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSLUtils {
    static final String PKCS12_TYPE = "PKCS12";
    private static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    private static final String DEFAULT_TRUST_STORE_TYPE = "JKS";
    private static final String DEFAULT_SECURE_SOCKET_PROTOCOL = "TLSv1";
    private static final String CERTIFICATE_FACTORY_TYPE = "X.509";
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "javax.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final boolean DEFAULT_REQUIRE_CLIENT_AUTHENTICATION = false;
    private static final boolean DEFAULT_WANT_CLIENT_AUTHENTICATION = true;
    private static final List<String> DEFAULT_CIPHERSUITE_FILTERS_INCLUDE = Arrays.asList(".*");
    private static final List<String> DEFAULT_CIPHERSUITE_FILTERS_EXCLUDE = Arrays.asList(".*_NULL_.*", ".*_anon_.*");

    private SSLUtils() {
    }

    public static KeyManager[] getKeyStoreManagers(String keyStoreLocation, String keyStoreType, String keyStorePassword, String keyPassword, String keyStoreMgrFactoryAlgorithm, String secureSocketProtocol, Logger log2) throws Exception {
        if (keyStorePassword != null && keyPassword != null && !keyStorePassword.equals(keyPassword)) {
            LogUtils.log(log2, Level.WARNING, "KEY_PASSWORD_NOT_SAME_KEYSTORE_PASSWORD");
        }
        KeyManager[] keystoreManagers = null;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyStoreMgrFactoryAlgorithm);
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        if (keyStoreType.equalsIgnoreCase("PKCS12")) {
            FileInputStream fis = new FileInputStream(keyStoreLocation);
            DataInputStream dis = new DataInputStream(fis);
            byte[] bytes2 = new byte[dis.available()];
            dis.readFully(bytes2);
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes2);
            if (keyStorePassword != null) {
                keystoreManagers = SSLUtils.loadKeyStore(kmf, ks, bin, keyStoreLocation, keyStorePassword, log2);
            }
        } else {
            byte[] sslCert = SSLUtils.loadClientCredential(keyStoreLocation);
            if (sslCert != null && sslCert.length > 0 && keyStorePassword != null) {
                ByteArrayInputStream bin = new ByteArrayInputStream(sslCert);
                keystoreManagers = SSLUtils.loadKeyStore(kmf, ks, bin, keyStoreLocation, keyStorePassword, log2);
            }
        }
        if (keyStorePassword == null && keyStoreLocation != null) {
            LogUtils.log(log2, Level.WARNING, "FAILED_TO_LOAD_KEYSTORE_NULL_PASSWORD", keyStoreLocation);
        }
        return keystoreManagers;
    }

    public static KeyManager[] loadKeyStore(KeyManagerFactory kmf, KeyStore ks, ByteArrayInputStream bin, String keyStoreLocation, String keyStorePassword, Logger log2) {
        KeyManager[] keystoreManagers = null;
        try {
            ks.load(bin, keyStorePassword.toCharArray());
            kmf.init(ks, keyStorePassword.toCharArray());
            keystoreManagers = kmf.getKeyManagers();
            LogUtils.log(log2, Level.FINE, "LOADED_KEYSTORE", keyStoreLocation);
        }
        catch (Exception e2) {
            LogUtils.log(log2, Level.WARNING, "FAILED_TO_LOAD_KEYSTORE", new Object[]{keyStoreLocation, e2.getMessage()});
        }
        return keystoreManagers;
    }

    public static TrustManager[] getTrustStoreManagers(boolean pkcs12, String trustStoreType, String trustStoreLocation, String trustStoreMgrFactoryAlgorithm, Logger log2) throws Exception {
        TrustManager[] trustStoreManagers = null;
        KeyStore trustedCertStore = KeyStore.getInstance(trustStoreType);
        if (pkcs12) {
            trustStoreManagers = new TrustManager[1];
            trustedCertStore.load(null, "".toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_FACTORY_TYPE);
            byte[] caCert = SSLUtils.loadCACert(trustStoreLocation);
            try {
                if (caCert != null) {
                    ByteArrayInputStream cabin = new ByteArrayInputStream(caCert);
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(cabin);
                    trustedCertStore.setCertificateEntry(((Object)cert.getIssuerDN()).toString(), cert);
                    cabin.close();
                }
            }
            catch (Exception e2) {
                LogUtils.log(log2, Level.WARNING, "FAILED_TO_LOAD_TRUST_STORE", new Object[]{trustStoreLocation, e2.getMessage()});
            }
        } else {
            trustedCertStore.load(new FileInputStream(trustStoreLocation), null);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustStoreMgrFactoryAlgorithm);
        tmf.init(trustedCertStore);
        LogUtils.log(log2, Level.FINE, "LOADED_TRUST_STORE", trustStoreLocation);
        trustStoreManagers = tmf.getTrustManagers();
        return trustStoreManagers;
    }

    protected static byte[] loadClientCredential(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream in2 = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in2.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in2.read(buf);
        }
        in2.close();
        return out.toByteArray();
    }

    protected static byte[] loadCACert(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream in2 = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in2.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in2.read(buf);
        }
        in2.close();
        return out.toByteArray();
    }

    public static String getKeystore(String keyStoreLocation, Logger log2) {
        String logMsg = null;
        if (keyStoreLocation != null) {
            logMsg = "KEY_STORE_SET";
        } else {
            keyStoreLocation = System.getProperty("javax.net.ssl.keyStore");
            if (keyStoreLocation != null) {
                logMsg = "KEY_STORE_SYSTEM_PROPERTY_SET";
            } else {
                keyStoreLocation = System.getProperty("user.home") + "/.keystore";
                logMsg = "KEY_STORE_NOT_SET";
            }
        }
        LogUtils.log(log2, Level.FINE, logMsg, keyStoreLocation);
        return keyStoreLocation;
    }

    public static String getKeystoreType(String keyStoreType, Logger log2) {
        String logMsg = null;
        if (keyStoreType != null) {
            logMsg = "KEY_STORE_TYPE_SET";
        } else {
            keyStoreType = "PKCS12";
            logMsg = "KEY_STORE_TYPE_NOT_SET";
        }
        LogUtils.log(log2, Level.FINE, logMsg, keyStoreType);
        return keyStoreType;
    }

    public static String getKeystorePassword(String keyStorePassword, Logger log2) {
        String logMsg = null;
        logMsg = keyStorePassword != null ? "KEY_STORE_PASSWORD_SET" : ((keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword")) != null ? "KEY_STORE_PASSWORD_SYSTEM_PROPERTY_SET" : "KEY_STORE_PASSWORD_NOT_SET");
        LogUtils.log(log2, Level.FINE, logMsg);
        return keyStorePassword;
    }

    public static String getKeyPassword(String keyPassword, Logger log2) {
        String logMsg = null;
        logMsg = keyPassword != null ? "KEY_PASSWORD_SET" : ((keyPassword = System.getProperty("javax.net.ssl.keyStorePassword")) != null ? "KEY_PASSWORD_SYSTEM_PROPERTY_SET" : "KEY_PASSWORD_NOT_SET");
        LogUtils.log(log2, Level.FINE, logMsg);
        return keyPassword;
    }

    public static String getKeystoreAlgorithm(String keyStoreMgrFactoryAlgorithm, Logger log2) {
        String logMsg = null;
        if (keyStoreMgrFactoryAlgorithm != null) {
            logMsg = "KEY_STORE_ALGORITHM_SET";
        } else {
            keyStoreMgrFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            logMsg = "KEY_STORE_ALGORITHM_NOT_SET";
        }
        LogUtils.log(log2, Level.FINE, logMsg, keyStoreMgrFactoryAlgorithm);
        return keyStoreMgrFactoryAlgorithm;
    }

    public static String getTrustStoreAlgorithm(String trustStoreMgrFactoryAlgorithm, Logger log2) {
        String logMsg = null;
        if (trustStoreMgrFactoryAlgorithm != null) {
            logMsg = "TRUST_STORE_ALGORITHM_SET";
        } else {
            trustStoreMgrFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            logMsg = "TRUST_STORE_ALGORITHM_NOT_SET";
        }
        LogUtils.log(log2, Level.FINE, logMsg, trustStoreMgrFactoryAlgorithm);
        return trustStoreMgrFactoryAlgorithm;
    }

    public static SSLContext getSSLContext(String protocol, KeyManager[] keyStoreManagers, TrustManager[] trustStoreManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(keyStoreManagers, trustStoreManagers, null);
        return ctx;
    }

    public static String[] getSupportedCipherSuites(SSLContext context) {
        return context.getSocketFactory().getSupportedCipherSuites();
    }

    public static String[] getServerSupportedCipherSuites(SSLContext context) {
        return context.getServerSocketFactory().getSupportedCipherSuites();
    }

    public static String[] getCiphersuites(List<String> cipherSuitesList, String[] supportedCipherSuites, FiltersType filters, Logger log2, boolean exclude2) {
        String[] cipherSuites = null;
        if (cipherSuitesList != null && !cipherSuitesList.isEmpty()) {
            cipherSuites = SSLUtils.getCiphersFromList(cipherSuitesList, log2, exclude2);
        } else {
            LogUtils.log(log2, Level.FINE, "CIPHERSUITES_NOT_SET");
            if (filters == null) {
                LogUtils.log(log2, Level.FINE, "CIPHERSUITE_FILTERS_NOT_SET");
            }
            ArrayList<String> filteredCipherSuites = new ArrayList<String>();
            ArrayList<String> excludedCipherSuites = new ArrayList<String>();
            List<Pattern> includes2 = filters != null ? SSLUtils.compileRegexPatterns(filters.getInclude(), true, log2) : SSLUtils.compileRegexPatterns(DEFAULT_CIPHERSUITE_FILTERS_INCLUDE, true, log2);
            List<Pattern> excludes = filters != null ? SSLUtils.compileRegexPatterns(filters.getExclude(), false, log2) : SSLUtils.compileRegexPatterns(DEFAULT_CIPHERSUITE_FILTERS_EXCLUDE, true, log2);
            for (int i = 0; i < supportedCipherSuites.length; ++i) {
                if (SSLUtils.matchesOneOf(supportedCipherSuites[i], includes2) && !SSLUtils.matchesOneOf(supportedCipherSuites[i], excludes)) {
                    LogUtils.log(log2, Level.FINE, "CIPHERSUITE_INCLUDED", supportedCipherSuites[i]);
                    filteredCipherSuites.add(supportedCipherSuites[i]);
                    continue;
                }
                LogUtils.log(log2, Level.FINE, "CIPHERSUITE_EXCLUDED", supportedCipherSuites[i]);
                excludedCipherSuites.add(supportedCipherSuites[i]);
            }
            LogUtils.log(log2, Level.FINE, "CIPHERSUITES_FILTERED", filteredCipherSuites);
            LogUtils.log(log2, Level.FINE, "CIPHERSUITES_EXCLUDED", excludedCipherSuites);
            cipherSuites = exclude2 ? SSLUtils.getCiphersFromList(excludedCipherSuites, log2, exclude2) : SSLUtils.getCiphersFromList(filteredCipherSuites, log2, exclude2);
        }
        return cipherSuites;
    }

    private static List<Pattern> compileRegexPatterns(List<String> regexes, boolean include2, Logger log2) {
        ArrayList<Pattern> patterns2 = new ArrayList<Pattern>();
        if (regexes != null) {
            String msg = include2 ? "CIPHERSUITE_INCLUDE_FILTER" : "CIPHERSUITE_EXCLUDE_FILTER";
            for (String s2 : regexes) {
                LogUtils.log(log2, Level.FINE, msg, s2);
                patterns2.add(Pattern.compile(s2));
            }
        }
        return patterns2;
    }

    private static boolean matchesOneOf(String s2, List<Pattern> patterns2) {
        boolean matches2 = false;
        if (patterns2 != null) {
            for (Pattern pattern : patterns2) {
                Matcher matcher2 = pattern.matcher(s2);
                if (!matcher2.matches()) continue;
                matches2 = true;
                break;
            }
        }
        return matches2;
    }

    private static String[] getCiphersFromList(List<String> cipherSuitesList, Logger log2, boolean exclude2) {
        int numCipherSuites = cipherSuitesList.size();
        String[] cipherSuites = cipherSuitesList.toArray(new String[numCipherSuites]);
        if (log2.isLoggable(Level.FINE)) {
            StringBuilder ciphsStr = new StringBuilder();
            for (String s2 : cipherSuites) {
                if (ciphsStr.length() != 0) {
                    ciphsStr.append(", ");
                }
                ciphsStr.append(s2);
            }
            LogUtils.log(log2, Level.FINE, exclude2 ? "CIPHERSUITES_EXCLUDED" : "CIPHERSUITES_SET", ciphsStr.toString());
        }
        return cipherSuites;
    }

    public static String getTrustStore(String trustStoreLocation, Logger log2) {
        String logMsg = null;
        if (trustStoreLocation != null) {
            logMsg = "TRUST_STORE_SET";
        } else {
            trustStoreLocation = System.getProperty("javax.net.ssl.trustStore");
            if (trustStoreLocation != null) {
                logMsg = "TRUST_STORE_SYSTEM_PROPERTY_SET";
            } else {
                trustStoreLocation = System.getProperty("java.home") + "/lib/security/cacerts";
                logMsg = "TRUST_STORE_NOT_SET";
            }
        }
        LogUtils.log(log2, Level.FINE, logMsg, trustStoreLocation);
        return trustStoreLocation;
    }

    public static String getTrustStoreType(String trustStoreType, Logger log2) {
        String logMsg = null;
        if (trustStoreType != null) {
            logMsg = "TRUST_STORE_TYPE_SET";
        } else {
            trustStoreType = DEFAULT_TRUST_STORE_TYPE;
            logMsg = "TRUST_STORE_TYPE_NOT_SET";
        }
        LogUtils.log(log2, Level.FINE, logMsg, trustStoreType);
        return trustStoreType;
    }

    public static String getSecureSocketProtocol(String secureSocketProtocol, Logger log2) {
        if (secureSocketProtocol != null) {
            LogUtils.log(log2, Level.FINE, "SECURE_SOCKET_PROTOCOL_SET", secureSocketProtocol);
        } else {
            LogUtils.log(log2, Level.FINE, "SECURE_SOCKET_PROTOCOL_NOT_SET");
            secureSocketProtocol = DEFAULT_SECURE_SOCKET_PROTOCOL;
        }
        return secureSocketProtocol;
    }

    public static boolean getRequireClientAuthentication(boolean isSetRequireClientAuthentication, Boolean isRequireClientAuthentication, Logger log2) {
        boolean requireClientAuthentication = false;
        if (isSetRequireClientAuthentication) {
            requireClientAuthentication = isRequireClientAuthentication;
            LogUtils.log(log2, Level.FINE, "REQUIRE_CLIENT_AUTHENTICATION_SET", requireClientAuthentication);
        } else {
            LogUtils.log(log2, Level.WARNING, "REQUIRE_CLIENT_AUTHENTICATION_NOT_SET");
        }
        return requireClientAuthentication;
    }

    public static boolean getWantClientAuthentication(boolean isSetWantClientAuthentication, Boolean isWantClientAuthentication, Logger log2) {
        boolean wantClientAuthentication = true;
        if (isSetWantClientAuthentication) {
            wantClientAuthentication = isWantClientAuthentication;
            LogUtils.log(log2, Level.FINE, "WANT_CLIENT_AUTHENTICATION_SET", wantClientAuthentication);
        } else {
            LogUtils.log(log2, Level.WARNING, "WANT_CLIENT_AUTHENTICATION_NOT_SET");
        }
        return wantClientAuthentication;
    }

    public static void propogateSecureSession(HttpServletRequest request, Message message) {
        String cipherSuite = (String)request.getAttribute(SSL_CIPHER_SUITE_ATTRIBUTE);
        if (cipherSuite != null) {
            Certificate[] certs = (Certificate[])request.getAttribute(SSL_PEER_CERT_CHAIN_ATTRIBUTE);
            message.put(TLSSessionInfo.class, new TLSSessionInfo(cipherSuite, null, certs));
        }
    }

    public static void logUnSupportedPolicies(Object policy, boolean client, String[] unsupported, Logger log2) {
        for (int i = 0; i < unsupported.length; ++i) {
            try {
                Method method = policy.getClass().getMethod("isSet" + unsupported[i], new Class[0]);
                boolean isSet = (Boolean)method.invoke(policy, (Object[])null);
                SSLUtils.logUnSupportedPolicy(isSet, client, unsupported[i], log2);
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    private static void logUnSupportedPolicy(boolean isSet, boolean client, String policy, Logger log2) {
        if (isSet) {
            LogUtils.log(log2, Level.WARNING, client ? "UNSUPPORTED_SSL_CLIENT_POLICY_DATA" : "UNSUPPORTED_SSL_SERVER_POLICY_DATA", policy);
        }
    }

    public static boolean testAllDataHasSetupMethod(Object policy, String[] unsupported, String[] derivative) {
        Method[] sslPolicyMethods = policy.getClass().getDeclaredMethods();
        Method[] methods2 = SSLUtils.class.getMethods();
        boolean ok2 = true;
        for (int i = 0; i < sslPolicyMethods.length && ok2; ++i) {
            String sslPolicyMethodName = sslPolicyMethods[i].getName();
            if (!sslPolicyMethodName.startsWith("isSet")) continue;
            String dataName = sslPolicyMethodName.substring("isSet".length(), sslPolicyMethodName.length());
            String thisMethodName = "get" + dataName;
            ok2 = SSLUtils.hasMethod(methods2, thisMethodName) || SSLUtils.isExcluded(unsupported, dataName) || SSLUtils.isExcluded(derivative, dataName);
        }
        return ok2;
    }

    private static boolean hasMethod(Method[] methods2, String methodName) {
        boolean found2 = false;
        for (int i = 0; i < methods2.length && !found2; ++i) {
            found2 = methods2[i].getName().equals(methodName);
        }
        return found2;
    }

    private static boolean isExcluded(String[] excluded, String dataName) {
        boolean found2 = false;
        for (int i = 0; i < excluded.length && !found2; ++i) {
            found2 = excluded[i].equals(dataName);
        }
        return found2;
    }
}

