/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class CXFServlet
extends CXFNonSpringServlet {
    protected void loadBus(ServletConfig sc) {
        ApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(sc.getServletContext());
        String configLocation = sc.getInitParameter("config-location");
        if (configLocation == null) {
            try {
                InputStream is2 = sc.getServletContext().getResourceAsStream("/WEB-INF/cxf-servlet.xml");
                if (is2 != null && is2.available() > 0) {
                    is2.close();
                    configLocation = "/WEB-INF/cxf-servlet.xml";
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        if (configLocation != null) {
            wac = this.createSpringContext(wac, sc, configLocation);
        }
        if (wac != null) {
            this.setBus(wac.getBean("cxf", Bus.class));
        } else {
            this.setBus(BusFactory.newInstance().createBus());
        }
    }

    private ApplicationContext createSpringContext(ApplicationContext ctx, ServletConfig sc, String location2) {
        XmlWebApplicationContext ctx2 = new XmlWebApplicationContext();
        ctx2.setServletConfig(sc);
        Resource r = ctx2.getResource(location2);
        try {
            InputStream in2 = r.getInputStream();
            in2.close();
        }
        catch (IOException e2) {
            r = ctx2.getResource("classpath:" + location2);
            try {
                r.getInputStream().close();
            }
            catch (IOException e22) {
                r = null;
            }
        }
        try {
            if (r != null) {
                location2 = r.getURL().toExternalForm();
            }
        }
        catch (IOException e3) {
            // empty catch block
        }
        if (ctx != null) {
            ctx2.setParent(ctx);
            String[] names = ctx.getBeanNamesForType(Bus.class);
            if (names == null || names.length == 0) {
                ctx2.setConfigLocations(new String[]{"classpath:/META-INF/cxf/cxf.xml", location2});
            } else {
                ctx2.setConfigLocations(new String[]{location2});
            }
        } else {
            ctx2.setConfigLocations(new String[]{"classpath:/META-INF/cxf/cxf.xml", location2});
        }
        ctx2.refresh();
        return ctx2;
    }
}

