/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.soap;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.soap.OneWayDecoupledFaultHandler;
import org.apache.cxf.ws.addressing.soap.VersionTransformer;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPCodec
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(MAPCodec.class);
    private static final String IS_REFERENCE_PARAM_ATTR_NAME = "IsReferenceParameter";
    private static final String ONE_WAY_DECOUPLED_FAULT_SUPPORT = "org.apache.cxf.ws.addressing.oneway.decoupled_fault_support";
    protected final Map<String, Exchange> uncorrelatedExchanges = new ConcurrentHashMap<String, Exchange>();
    private VersionTransformer transformer;
    private HeaderFactory headerFactory;

    public MAPCodec() {
        super("pre-protocol");
        this.addBefore("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor");
        this.transformer = new VersionTransformer(this);
    }

    public Map<String, Exchange> getUncorrelatedExchanges() {
        return this.uncorrelatedExchanges;
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return VersionTransformer.HEADERS;
    }

    @Override
    public void handleMessage(SoapMessage message) {
        this.mediate(message);
    }

    @Override
    public void handleFault(SoapMessage message) {
        if (!message.getExchange().isOneWay()) {
            AddressingPropertiesImpl maps2 = ContextUtils.retrieveMAPs(message, false, true, false);
            if (ContextUtils.isRequestor(message) && maps2 != null) {
                this.uncorrelatedExchanges.remove(maps2.getMessageID().getValue());
            } else if (!ContextUtils.isRequestor(message) && maps2 == null && !message.containsKey(MAPAggregator.class.getName())) {
                for (Interceptor i : message.getInterceptorChain()) {
                    if (!(i instanceof MAPAggregator)) continue;
                    try {
                        MAPAggregator agg = (MAPAggregator)i;
                        agg.handleMessage(message);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    return;
                }
            }
        } else if (MessageUtils.getContextualBoolean(message, ONE_WAY_DECOUPLED_FAULT_SUPPORT, false)) {
            new OneWayDecoupledFaultHandler().handleFault(message);
        }
    }

    private void mediate(SoapMessage message) {
        if (!MessageUtils.getContextualBoolean(message, MAPAggregator.ADDRESSING_DISABLED, false)) {
            if (ContextUtils.isOutbound(message)) {
                this.encode(message, ContextUtils.retrieveMAPs(message, false, true));
            } else if (null == ContextUtils.retrieveMAPs(message, false, false, false)) {
                AddressingProperties maps2 = this.decode(message);
                ContextUtils.storeMAPs(maps2, message, false);
                this.markPartialResponse(message, maps2);
                this.restoreExchange(message, maps2);
            }
        }
    }

    private void encode(SoapMessage message, AddressingPropertiesImpl maps2) {
        if (maps2 != null) {
            this.cacheExchange(message, maps2);
            LOG.log(Level.FINE, "Outbound WS-Addressing headers");
            try {
                List<Header> header = message.getHeaders();
                this.discardMAPs(header, maps2);
                Element hdr = this.getHeaderFactory().getHeader(message.getVersion());
                JAXBContext jaxbContext = VersionTransformer.getExposedJAXBContext(maps2.getNamespaceURI());
                Marshaller marshaller = jaxbContext.createMarshaller();
                QName duplicate = maps2.getDuplicate();
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                this.encodeAsExposed(maps2, message, maps2.getAction(), Names.WSA_ACTION_QNAME, AttributedURIType.class, hdr, marshaller);
                if (Names.WSA_ACTION_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps2, message, maps2.getAction(), Names.WSA_ACTION_QNAME, AttributedURIType.class, hdr, marshaller);
                }
                this.encodeAsExposed(maps2, message, maps2.getMessageID(), Names.WSA_MESSAGEID_QNAME, AttributedURIType.class, hdr, marshaller);
                if (Names.WSA_MESSAGEID_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps2, message, maps2.getMessageID(), Names.WSA_MESSAGEID_QNAME, AttributedURIType.class, hdr, marshaller);
                }
                this.encodeAsExposed(maps2, message, maps2.getTo(), Names.WSA_TO_QNAME, AttributedURIType.class, hdr, marshaller);
                if (Names.WSA_TO_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps2, message, maps2.getTo(), Names.WSA_TO_QNAME, AttributedURIType.class, hdr, marshaller);
                }
                if (this.needsReplyTo(maps2)) {
                    this.encodeAsExposed(maps2, message, maps2.getReplyTo(), Names.WSA_REPLYTO_QNAME, EndpointReferenceType.class, hdr, marshaller);
                    if (Names.WSA_REPLYTO_QNAME.equals(duplicate)) {
                        this.encodeAsExposed(maps2, message, maps2.getReplyTo(), Names.WSA_REPLYTO_QNAME, EndpointReferenceType.class, hdr, marshaller);
                    }
                }
                this.encodeAsExposed(maps2, message, maps2.getRelatesTo(), Names.WSA_RELATESTO_QNAME, RelatesToType.class, hdr, marshaller);
                if (Names.WSA_RELATESTO_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps2, message, maps2.getRelatesTo(), Names.WSA_RELATESTO_QNAME, RelatesToType.class, hdr, marshaller);
                }
                this.encodeAsExposed(maps2, message, maps2.getFrom(), Names.WSA_FROM_QNAME, EndpointReferenceType.class, hdr, marshaller);
                if (Names.WSA_FROM_QNAME.equals(duplicate)) {
                    this.encodeAsExposed(maps2, message, maps2.getFrom(), Names.WSA_FROM_QNAME, EndpointReferenceType.class, hdr, marshaller);
                }
                if (this.needsFaultTo(maps2)) {
                    this.encodeAsExposed(maps2, message, maps2.getFaultTo(), Names.WSA_FAULTTO_QNAME, EndpointReferenceType.class, hdr, marshaller);
                    if (Names.WSA_FAULTTO_QNAME.equals(duplicate)) {
                        this.encodeAsExposed(maps2, message, maps2.getFaultTo(), Names.WSA_FAULTTO_QNAME, EndpointReferenceType.class, hdr, marshaller);
                    }
                }
                this.encodeReferenceParameters(maps2, hdr, marshaller);
                for (Node childNode = hdr.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    Header holder = new Header(new QName(childNode.getNamespaceURI(), childNode.getLocalName()), childNode);
                    header.add(holder);
                }
                maps2.setDuplicate(null);
                this.propogateAction(maps2.getAction(), message);
                this.applyMAPValidation(message);
            }
            catch (JAXBException je) {
                LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
            }
        }
    }

    private boolean needsReplyTo(AddressingProperties maps2) {
        return maps2.getReplyTo() != null && maps2.getReplyTo().getAddress() != null && maps2.getReplyTo().getAddress().getValue() != null && (!"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(maps2.getNamespaceURI()) || !maps2.getReplyTo().getAddress().getValue().equals(ContextUtils.getNoneEndpointReference().getAddress().getValue()));
    }

    private boolean needsFaultTo(AddressingProperties maps2) {
        return maps2.getFaultTo() != null && maps2.getFaultTo().getAddress() != null && maps2.getFaultTo().getAddress().getValue() != null && !maps2.getFaultTo().getAddress().getValue().equals(maps2.getReplyTo().getAddress().getValue());
    }

    private void encodeReferenceParameters(AddressingProperties maps2, Element header, Marshaller marshaller) throws JAXBException {
        ReferenceParametersType params2;
        EndpointReferenceType toEpr = maps2.getToEndpointReference();
        if (null != toEpr && null != (params2 = toEpr.getReferenceParameters())) {
            for (Object o : params2.getAny()) {
                if (o instanceof Element || o instanceof JAXBElement) {
                    JAXBElement jaxbEl = null;
                    if (o instanceof Element) {
                        Element e2 = (Element)o;
                        QName elQn = new QName(e2.getNamespaceURI(), e2.getLocalName());
                        jaxbEl = new JAXBElement(elQn, String.class, (Object)e2.getTextContent());
                    } else {
                        jaxbEl = (JAXBElement)o;
                    }
                    marshaller.marshal((Object)jaxbEl, (Node)header);
                    Element lastAdded = (Element)header.getLastChild();
                    this.addIsReferenceParameterMarkerAttribute(lastAdded, maps2.getNamespaceURI());
                    continue;
                }
                LOG.log(Level.WARNING, "IGNORE_NON_ELEMENT_REF_PARAM_MSG", o);
            }
        }
    }

    private void addIsReferenceParameterMarkerAttribute(Element lastAdded, String namespaceURI) {
        String pfx = lastAdded.lookupPrefix(namespaceURI);
        if (StringUtils.isEmpty(pfx)) {
            if (lastAdded.lookupNamespaceURI("wsa") == null) {
                pfx = "wsa";
                Attr attr = lastAdded.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa");
                attr.setValue(namespaceURI);
                lastAdded.setAttributeNodeNS(attr);
            } else if (lastAdded.lookupNamespaceURI("wsa").equals(namespaceURI)) {
                pfx = "wsa";
            } else {
                int cnt = 1;
                while (lastAdded.lookupNamespaceURI("wsa" + cnt) != null) {
                    ++cnt;
                }
                pfx = "wsa" + cnt;
                Attr attr = lastAdded.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa" + cnt);
                attr.setValue(namespaceURI);
                lastAdded.setAttributeNodeNS(attr);
            }
        }
        Attr isRefParamAttr = lastAdded.getOwnerDocument().createAttributeNS(namespaceURI, pfx + ":" + IS_REFERENCE_PARAM_ATTR_NAME);
        isRefParamAttr.setTextContent("1");
        lastAdded.setAttributeNodeNS(isRefParamAttr);
    }

    private void addMustUnderstandAttribute(Element header, QName name, SoapMessage msg, AddressingPropertiesImpl maps2) {
        if (maps2.getMustUnderstand().contains(name)) {
            Element lastAdded = (Element)header.getLastChild();
            String pfx = lastAdded.lookupPrefix(msg.getVersion().getNamespace());
            if (StringUtils.isEmpty(pfx)) {
                pfx = "soap";
            }
            if (msg.hasAdditionalEnvNs()) {
                String ns = msg.getVersion().getNamespace();
                Map<String, String> nsMap = msg.getEnvelopeNs();
                for (Map.Entry<String, String> entry2 : nsMap.entrySet()) {
                    if (!ns.equals(entry2.getValue())) continue;
                    pfx = entry2.getKey();
                }
            }
            Attr mustUnderstandAttr = lastAdded.getOwnerDocument().createAttributeNS(msg.getVersion().getNamespace(), pfx + ":mustUnderstand");
            mustUnderstandAttr.setTextContent("1");
            lastAdded.setAttributeNodeNS(mustUnderstandAttr);
        }
    }

    private <T> void encodeAsExposed(AddressingPropertiesImpl maps2, SoapMessage message, T value2, QName name, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value2 != null) {
            LOG.log(Level.FINE, "{0} : {1}", new Object[]{name.getLocalPart(), this.getLogText(value2)});
            this.transformer.encodeAsExposed(maps2.getNamespaceURI(), value2, name.getLocalPart(), clz, header, marshaller);
        }
        this.addMustUnderstandAttribute(header, name, message, maps2);
    }

    public AddressingProperties unmarshalMAPs(SoapMessage message) {
        AddressingPropertiesImpl maps2 = null;
        try {
            List<Header> header = message.getHeaders();
            if (header != null) {
                LOG.log(Level.FINE, "Inbound WS-Addressing headers");
                Unmarshaller unmarshaller = null;
                HashSet<Element> referenceParameterHeaders = null;
                for (Header hdr : header) {
                    if (!(hdr.getObject() instanceof Element)) continue;
                    Element headerElement = (Element)hdr.getObject();
                    String headerURI = headerElement.getNamespaceURI();
                    if (this.transformer.isSupported(headerURI)) {
                        String localName;
                        if (unmarshaller == null) {
                            JAXBContext jaxbContext = VersionTransformer.getExposedJAXBContext(headerURI);
                            unmarshaller = jaxbContext.createUnmarshaller();
                        }
                        if (maps2 == null) {
                            maps2 = new AddressingPropertiesImpl();
                            maps2.exposeAs(headerURI);
                        }
                        if ("MessageID".equals(localName = headerElement.getLocalName())) {
                            maps2.setMessageID(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("To".equals(localName)) {
                            AttributedURIType addr = this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller);
                            maps2.setTo(EndpointReferenceUtils.getEndpointReference(addr));
                            continue;
                        }
                        if ("From".equals(localName)) {
                            maps2.setFrom(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("ReplyTo".equals(localName)) {
                            maps2.setReplyTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("FaultTo".equals(localName)) {
                            maps2.setFaultTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("RelatesTo".equals(localName)) {
                            maps2.setRelatesTo(this.decodeAsNative(headerURI, RelatesToType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if (!"Action".equals(localName)) continue;
                        maps2.setAction(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                        continue;
                    }
                    if (null != headerElement.getAttribute(IS_REFERENCE_PARAM_ATTR_NAME)) {
                        if (null == referenceParameterHeaders) {
                            referenceParameterHeaders = new HashSet<Element>();
                        }
                        referenceParameterHeaders.add(headerElement);
                        continue;
                    }
                    if (!headerURI.contains("/addressing")) continue;
                    LOG.log(Level.WARNING, "UNSUPPORTED_VERSION_MSG", headerURI);
                }
                if (null != referenceParameterHeaders && null != maps2) {
                    this.decodeReferenceParameters(referenceParameterHeaders, maps2, unmarshaller);
                }
            }
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", je);
        }
        return maps2;
    }

    private void decodeReferenceParameters(Set<Element> referenceParameterHeaders, AddressingPropertiesImpl maps2, Unmarshaller unmarshaller) throws JAXBException {
        EndpointReferenceType toEpr = maps2.getToEndpointReference();
        if (null != toEpr) {
            for (Element e2 : referenceParameterHeaders) {
                JAXBElement el = unmarshaller.unmarshal((Node)e2, String.class);
                ContextUtils.applyReferenceParam(toEpr, (JAXBElement<String>)el);
            }
        }
    }

    public <T> T decodeAsNative(String encodedAs, Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        T value2 = clz.cast(this.transformer.decodeAsNative(encodedAs, clz, headerElement, unmarshaller));
        LOG.log(Level.FINE, "{0} : {1}", new Object[]{headerElement.getLocalName(), this.getLogText(value2)});
        return value2;
    }

    private <T> String getLogText(T value2) {
        String text2 = "unknown";
        if (value2 == null) {
            text2 = "null";
        } else if (value2 instanceof AttributedURIType) {
            text2 = ((AttributedURIType)value2).getValue();
        } else if (value2 instanceof EndpointReferenceType) {
            text2 = ((EndpointReferenceType)value2).getAddress() != null ? ((EndpointReferenceType)value2).getAddress().getValue() : "null";
        } else if (value2 instanceof RelatesToType) {
            text2 = ((RelatesToType)value2).getValue();
        }
        return text2;
    }

    private AddressingProperties decode(SoapMessage message) {
        return this.unmarshalMAPs(message);
    }

    protected <T> void encodeMAP(T value2, QName qname, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value2 != null) {
            marshaller.marshal((Object)new JAXBElement(qname, clz, value2), (Node)header);
        }
    }

    protected <T> T decodeMAP(Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        JAXBElement element2 = unmarshaller.unmarshal((Node)headerElement, clz);
        return (T)element2.getValue();
    }

    private void discardMAPs(List<Header> header, AddressingProperties maps2) {
        Iterator<Header> iter2 = header.iterator();
        while (iter2.hasNext()) {
            Header hdr = iter2.next();
            if (!"http://www.w3.org/2005/08/addressing".equals(hdr.getName().getNamespaceURI()) && !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(hdr.getName().getNamespaceURI())) continue;
            iter2.remove();
        }
    }

    private void propogateAction(AttributedURIType action2, SoapMessage message) {
        List soapActionHeaders;
        Map mimeHeaders;
        if (action2 != null && !"".equals(action2.getValue()) && (mimeHeaders = CastUtils.cast((Map)message.get("org.apache.cxf.mime.headers"))) != null && (soapActionHeaders = (List)mimeHeaders.get("SOAPAction")) != null && soapActionHeaders.size() != 0 && !"".equals(soapActionHeaders.get(0))) {
            LOG.log(Level.FINE, "encoding wsa:Action in SOAPAction header {0}", action2.getValue());
            soapActionHeaders.clear();
            soapActionHeaders.add("\"" + action2.getValue() + "\"");
        }
    }

    private void applyMAPValidation(SoapMessage message) {
        String faultName = ContextUtils.retrieveMAPFaultName(message);
        if (faultName != null) {
            String reason = ContextUtils.retrieveMAPFaultReason(message);
            throw this.createSOAPFaut(faultName, "http://www.w3.org/2005/08/addressing", reason);
        }
    }

    private SoapFault createSOAPFaut(String localName, String namespace, String reason) {
        return new SoapFault(reason, new QName(namespace, localName));
    }

    private void cacheExchange(SoapMessage message, AddressingProperties maps2) {
        if (ContextUtils.isRequestor(message) && !message.getExchange().isOneWay()) {
            this.uncorrelatedExchanges.put(maps2.getMessageID().getValue(), message.getExchange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreExchange(SoapMessage message, AddressingProperties maps2) {
        Exchange ex2;
        Message m;
        if (maps2 != null && maps2.getRelatesTo() != null && !"http://www.w3.org/2005/08/addressing/unspecified".equals(maps2.getRelatesTo().getValue()) && this.isRelationshipReply(maps2.getRelatesTo())) {
            Exchange correlatedExchange = this.uncorrelatedExchanges.remove(maps2.getRelatesTo().getValue());
            if (correlatedExchange != null) {
                Exchange exchange = correlatedExchange;
                synchronized (exchange) {
                    message.setExchange(correlatedExchange);
                }
            } else if (ContextUtils.isRequestor(message) && !message.getExchange().isOneWay()) {
                if (ContextUtils.retrieveDeferUncorrelatedMessageAbort(message)) {
                    LOG.fine("deferring uncorrelated message abort");
                    ContextUtils.storeDeferredUncorrelatedMessageAbort(message);
                } else if (!MessageUtils.getContextualBoolean(message, "org.apache.cxf.ws.addressing.MAPAggregator.addressingDisabled", false)) {
                    LOG.log(Level.WARNING, "CORRELATION_FAILURE_MSG");
                    message.getInterceptorChain().abort();
                }
            }
        } else if (maps2 == null && this.isRequestor(message) && (maps2 = ContextUtils.retrieveMAPs(m = message.getExchange().getOutMessage(), false, true, false)) != null && (ex2 = this.uncorrelatedExchanges.get(maps2.getMessageID().getValue())) == message.getExchange()) {
            this.uncorrelatedExchanges.remove(maps2.getMessageID().getValue());
            LOG.log(Level.WARNING, "RESPONSE_NOT_USING_WSADDRESSING");
        }
    }

    private boolean isRelationshipReply(RelatesToType relatesTo) {
        return "http://www.w3.org/2005/08/addressing/reply".equals(relatesTo.getRelationshipType());
    }

    private void markPartialResponse(SoapMessage message, AddressingProperties maps2) {
        if (ContextUtils.isRequestor(message) && null != maps2 && (null == maps2.getRelatesTo() || null != maps2.getRelatesTo() && "http://www.w3.org/2005/08/addressing/unspecified".equals(maps2.getRelatesTo().getValue()))) {
            message.put("org.apache.cxf.partial.response", (Object)Boolean.TRUE);
        }
    }

    protected HeaderFactory getHeaderFactory() {
        if (this.headerFactory == null) {
            this.headerFactory = new HeaderFactory(){

                public Element getHeader(SoapVersion soapversion) {
                    Document doc = DOMUtils.createDocument();
                    return doc.createElementNS(soapversion.getHeader().getNamespaceURI(), soapversion.getHeader().getLocalPart());
                }
            };
        }
        return this.headerFactory;
    }

    protected void setHeaderFactory(HeaderFactory factory) {
        this.headerFactory = factory;
    }

    public static interface HeaderFactory {
        public Element getHeader(SoapVersion var1);
    }
}

