/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBContextCache;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.PrettyPrintXMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBExtensionHelper
implements ExtensionSerializer,
ExtensionDeserializer {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBExtensionHelper.class);
    final Class<? extends ExtensibilityElement> typeClass;
    final String namespace;
    String jaxbNamespace;
    private JAXBContext context;
    private Set<Class<?>> classes;

    public JAXBExtensionHelper(Class<? extends ExtensibilityElement> cls, String ns) {
        this.typeClass = cls;
        this.namespace = ns;
    }

    void setJaxbNamespace(String ns) {
        this.jaxbNamespace = ns;
    }

    public static void addExtensions(ExtensionRegistry registry, String parentType, String elementType2) throws JAXBException, ClassNotFoundException {
        Class<?> parentTypeClass = ClassLoaderUtils.loadClass(parentType, JAXBExtensionHelper.class);
        Class<ExtensibilityElement> elementTypeClass = ClassLoaderUtils.loadClass(elementType2, JAXBExtensionHelper.class).asSubclass(ExtensibilityElement.class);
        JAXBExtensionHelper.addExtensions(registry, parentTypeClass, elementTypeClass, null);
    }

    public static void addExtensions(ExtensionRegistry registry, String parentType, String elementType2, String namespace) throws JAXBException, ClassNotFoundException {
        Class<?> parentTypeClass = ClassLoaderUtils.loadClass(parentType, JAXBExtensionHelper.class);
        Class<ExtensibilityElement> elementTypeClass = ClassLoaderUtils.loadClass(elementType2, JAXBExtensionHelper.class).asSubclass(ExtensibilityElement.class);
        JAXBExtensionHelper.addExtensions(registry, parentTypeClass, elementTypeClass, namespace);
    }

    public static void addExtensions(ExtensionRegistry registry, Class<?> parentType, Class<? extends ExtensibilityElement> cls) throws JAXBException {
        JAXBExtensionHelper.addExtensions(registry, parentType, cls, null);
    }

    public static void addExtensions(ExtensionRegistry registry, Class<?> parentType, Class<? extends ExtensibilityElement> cls, String namespace) throws JAXBException {
        XmlRootElement elAnnot;
        JAXBExtensionHelper helper2 = new JAXBExtensionHelper(cls, namespace);
        boolean found2 = false;
        try {
            Method[] methods2;
            Class<?> objectFactory = Class.forName(PackageUtils.getPackageName(cls) + ".ObjectFactory", true, cls.getClassLoader());
            for (Method method : methods2 = objectFactory.getDeclaredMethods()) {
                String ns;
                XmlElementDecl elementDecl;
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(cls) || null == (elementDecl = method.getAnnotation(XmlElementDecl.class))) continue;
                String name = elementDecl.name();
                String string2 = ns = namespace != null ? namespace : elementDecl.namespace();
                if (namespace != null) {
                    helper2.setJaxbNamespace(elementDecl.namespace());
                }
                QName elementType2 = new QName(ns, name);
                registry.registerDeserializer(parentType, elementType2, helper2);
                registry.registerSerializer(parentType, elementType2, helper2);
                registry.mapExtensionTypes(parentType, elementType2, cls);
                found2 = true;
            }
        }
        catch (ClassNotFoundException ex2) {
            // empty catch block
        }
        if (!found2 && (elAnnot = cls.getAnnotation(XmlRootElement.class)) != null) {
            String name = elAnnot.name();
            String ns = elAnnot.namespace();
            if (StringUtils.isEmpty(ns) || "##default".equals(ns)) {
                XmlSchema schema = null;
                if (cls.getPackage() != null) {
                    schema = cls.getPackage().getAnnotation(XmlSchema.class);
                }
                if (schema != null) {
                    ns = schema.namespace();
                }
            }
            if (!StringUtils.isEmpty(ns) && !StringUtils.isEmpty(name)) {
                if (namespace != null) {
                    helper2.setJaxbNamespace(ns);
                    ns = namespace;
                }
                QName elementType3 = new QName(ns, name);
                registry.registerDeserializer(parentType, elementType3, helper2);
                registry.registerSerializer(parentType, elementType3, helper2);
                registry.mapExtensionTypes(parentType, elementType3, cls);
                found2 = true;
            }
        }
        if (!found2) {
            LOG.log(Level.WARNING, "EXTENSION_NOT_REGISTERED", new Object[]{cls.getName(), parentType.getName()});
        }
    }

    private synchronized JAXBContext getContext() throws JAXBException {
        if (this.context == null || this.classes == null) {
            try {
                JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(this.typeClass);
                this.classes = ccs.getClasses();
                this.context = ccs.getContext();
            }
            catch (JAXBException e2) {
                throw new RuntimeException(e2);
            }
        }
        return this.context;
    }

    @Override
    public void marshall(Class parent2, QName qname, ExtensibilityElement obj, PrintWriter pw, final Definition wsdl, ExtensionRegistry registry) throws WSDLException {
        try {
            Method[] methods2;
            Marshaller u = this.getContext().createMarshaller();
            u.setProperty("jaxb.encoding", (Object)"UTF-8");
            u.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            u.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Object mObj = obj;
            Class<?> objectFactory = Class.forName(PackageUtils.getPackageName(this.typeClass) + ".ObjectFactory", true, obj.getClass().getClassLoader());
            for (Method method : methods2 = objectFactory.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(this.typeClass)) continue;
                mObj = method.invoke(objectFactory.newInstance(), obj);
            }
            XMLOutputFactory fact = XMLOutputFactory.newInstance();
            PrettyPrintXMLStreamWriter writer = new PrettyPrintXMLStreamWriter(fact.createXMLStreamWriter(pw), parent2);
            writer.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String arg) {
                    return wsdl.getNamespace(arg);
                }

                public String getPrefix(String arg) {
                    if (arg.equals(JAXBExtensionHelper.this.jaxbNamespace)) {
                        arg = JAXBExtensionHelper.this.namespace;
                    }
                    for (Map.Entry ent : wsdl.getNamespaces().entrySet()) {
                        Map.Entry entry2 = ent;
                        if (!arg.equals(entry2.getValue())) continue;
                        return (String)entry2.getKey();
                    }
                    return null;
                }

                public Iterator getPrefixes(String arg) {
                    if (arg.equals(JAXBExtensionHelper.this.jaxbNamespace)) {
                        arg = JAXBExtensionHelper.this.namespace;
                    }
                    return wsdl.getNamespaces().keySet().iterator();
                }
            });
            u.marshal(mObj, (XMLStreamWriter)writer);
            writer.flush();
        }
        catch (Exception ex2) {
            throw new WSDLException("PARSER_ERROR", "", ex2);
        }
    }

    @Override
    public ExtensibilityElement unmarshall(Class parent2, QName qname, Element element2, Definition wsdl, ExtensionRegistry registry) throws WSDLException {
        try {
            Object el;
            Unmarshaller u = this.getContext().createUnmarshaller();
            Object o = null;
            if (this.namespace == null) {
                o = u.unmarshal((Node)element2);
            } else {
                XMLStreamReader reader2 = StaxUtils.createXMLStreamReader(element2);
                reader2 = new MappingReaderDelegate(reader2);
                o = u.unmarshal(reader2);
            }
            if (o instanceof JAXBElement) {
                el = (JAXBElement)o;
                o = el.getValue();
            }
            ExtensibilityElement extensibilityElement = el = o instanceof ExtensibilityElement ? (ExtensibilityElement)o : null;
            if (null != el) {
                el.setElementType(qname);
            }
            return el;
        }
        catch (Exception ex2) {
            throw new WSDLException("PARSER_ERROR", "Error reading element " + qname, ex2);
        }
    }

    class MappingReaderDelegate
    extends StreamReaderDelegate {
        MappingReaderDelegate(XMLStreamReader reader2) {
            super(reader2);
        }

        public NamespaceContext getNamespaceContext() {
            final NamespaceContext ctx = super.getNamespaceContext();
            return new NamespaceContext(){

                public String getNamespaceURI(String prefix2) {
                    String ns = ctx.getNamespaceURI(prefix2);
                    if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                        ns = JAXBExtensionHelper.this.jaxbNamespace;
                    }
                    return ns;
                }

                public String getPrefix(String namespaceURI) {
                    if (JAXBExtensionHelper.this.jaxbNamespace.equals(namespaceURI)) {
                        return ctx.getPrefix(JAXBExtensionHelper.this.namespace);
                    }
                    return ctx.getPrefix(namespaceURI);
                }

                public Iterator getPrefixes(String namespaceURI) {
                    if (JAXBExtensionHelper.this.jaxbNamespace.equals(namespaceURI)) {
                        return ctx.getPrefixes(JAXBExtensionHelper.this.namespace);
                    }
                    return ctx.getPrefixes(namespaceURI);
                }
            };
        }

        public String getNamespaceURI(int index2) {
            String ns = super.getNamespaceURI(index2);
            if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                ns = JAXBExtensionHelper.this.jaxbNamespace;
            }
            return ns;
        }

        public String getNamespaceURI(String prefix2) {
            String ns = super.getNamespaceURI(prefix2);
            if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                ns = JAXBExtensionHelper.this.jaxbNamespace;
            }
            return ns;
        }

        public QName getName() {
            QName qn = super.getName();
            if (JAXBExtensionHelper.this.namespace.equals(qn.getNamespaceURI())) {
                qn = new QName(JAXBExtensionHelper.this.jaxbNamespace, qn.getLocalPart());
            }
            return qn;
        }

        public String getNamespaceURI() {
            String ns = super.getNamespaceURI();
            if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                ns = JAXBExtensionHelper.this.jaxbNamespace;
            }
            return ns;
        }
    }
}

