/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderSerializer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.service.model.ServiceSchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.cxf.wsdl.WSDLExtensionLoader;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.SchemaSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations(unlessNull={"bus"})
public class WSDLManagerImpl
implements WSDLManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLManagerImpl.class);
    private static final String EXTENSIONS_RESOURCE = "META-INF/cxf/extensions.xml";
    private static final String EXTENSIONS_RESOURCE_COMPAT = "META-INF/extensions.xml";
    final ExtensionRegistry registry;
    final WSDLFactory factory;
    final Map<Object, Definition> definitionsMap;
    final Map<Object, ServiceSchemaInfo> schemaCacheMap;
    private boolean disableSchemaCache;
    private Bus bus;

    public WSDLManagerImpl() throws BusException {
        try {
            this.factory = WSDLFactory.newInstance();
            this.registry = this.factory.newPopulatedExtensionRegistry();
            this.registry.registerSerializer(Types.class, WSDLConstants.QNAME_SCHEMA, new SchemaSerializer());
            QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
            this.registry.registerDeserializer(MIMEPart.class, header, new SOAPHeaderSerializer());
            this.registry.registerSerializer(MIMEPart.class, header, new SOAPHeaderSerializer());
            this.registry.mapExtensionTypes(MIMEPart.class, header, SOAPHeaderImpl.class);
        }
        catch (WSDLException e2) {
            throw new BusException(e2);
        }
        this.definitionsMap = new CacheMap<Object, Definition>();
        this.schemaCacheMap = new CacheMap<Object, ServiceSchemaInfo>();
        this.registerInitialExtensions();
    }

    public WSDLManagerImpl(Bus b) throws BusException {
        this();
        this.setBus(b);
    }

    @Resource
    public final void setBus(Bus b) {
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension(this, WSDLManager.class);
            ConfiguredBeanLocator loc = this.bus.getExtension(ConfiguredBeanLocator.class);
            if (loc != null) {
                loc.getBeansOfType(WSDLExtensionLoader.class);
            }
        }
    }

    @Override
    public WSDLFactory getWSDLFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Definition> getDefinitions() {
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            return Collections.unmodifiableMap(this.definitionsMap);
        }
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(URL url) throws WSDLException {
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
        }
        Definition def = this.loadDefinition(url.toString());
        Map<Object, Definition> map4 = this.definitionsMap;
        synchronized (map4) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(String url) throws WSDLException {
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
        }
        return this.loadDefinition(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(Element el) throws WSDLException {
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            if (this.definitionsMap.containsKey(el)) {
                return this.definitionsMap.get(el);
            }
        }
        WSDLReader reader2 = this.factory.newWSDLReader();
        reader2.setFeature("javax.wsdl.verbose", false);
        reader2.setExtensionRegistry(this.registry);
        Definition def = reader2.readWSDL("", el);
        Map<Object, Definition> map4 = this.definitionsMap;
        synchronized (map4) {
            this.definitionsMap.put(el, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefinition(Object key, Definition wsdl) {
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            this.definitionsMap.put(key, wsdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition loadDefinition(String url) throws WSDLException {
        WSDLReader reader2 = this.factory.newWSDLReader();
        reader2.setFeature("javax.wsdl.verbose", false);
        reader2.setFeature("javax.wsdl.importDocuments", true);
        reader2.setExtensionRegistry(this.registry);
        CatalogWSDLLocator catLocator = new CatalogWSDLLocator(url, this.bus);
        ResourceManagerWSDLLocator wsdlLocator = new ResourceManagerWSDLLocator(url, catLocator, this.bus);
        InputSource src = wsdlLocator.getBaseInputSource();
        Definition def = null;
        if (src.getByteStream() != null || src.getCharacterStream() != null) {
            Document doc;
            try {
                doc = StaxUtils.read(StaxUtils.createXMLStreamReader(src), true);
                if (src.getSystemId() != null) {
                    try {
                        doc.setDocumentURI(new String(src.getSystemId()));
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Exception e3) {
                throw new WSDLException("PARSER_ERROR", e3.getMessage(), e3);
            }
            def = reader2.readWSDL(wsdlLocator, doc.getDocumentElement());
        } else {
            def = reader2.readWSDL(wsdlLocator);
        }
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    private void registerInitialExtensions() throws BusException {
        this.registerInitialXmlExtensions(EXTENSIONS_RESOURCE_COMPAT);
        this.registerInitialXmlExtensions(EXTENSIONS_RESOURCE);
    }

    private void registerInitialXmlExtensions(String resource) throws BusException {
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties(resource, this.getClass().getClassLoader());
        }
        catch (IOException ex2) {
            throw new BusException(ex2);
        }
        Iterator<Object> it = initialExtensions.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(initialExtensions.getProperty((String)it.next()), "=");
            String parentType = st.nextToken();
            String elementType2 = st.nextToken();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering extension: " + elementType2 + " for parent: " + parentType);
                }
                JAXBExtensionHelper.addExtensions(this.registry, parentType, elementType2);
            }
            catch (ClassNotFoundException ex3) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex3);
            }
            catch (JAXBException ex4) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceSchemaInfo getSchemasForDefinition(Definition wsdl) {
        if (this.disableSchemaCache) {
            return null;
        }
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            for (Map.Entry<Object, Definition> e2 : this.definitionsMap.entrySet()) {
                ServiceSchemaInfo info2;
                if (e2.getValue() != wsdl || (info2 = this.schemaCacheMap.get(e2.getKey())) == null) continue;
                return info2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSchemasForDefinition(Definition wsdl, ServiceSchemaInfo schemas) {
        if (!this.disableSchemaCache) {
            Map<Object, Definition> map3 = this.definitionsMap;
            synchronized (map3) {
                for (Map.Entry<Object, Definition> e2 : this.definitionsMap.entrySet()) {
                    if (e2.getValue() != wsdl) continue;
                    this.schemaCacheMap.put(e2.getKey(), schemas);
                }
            }
        }
    }

    public boolean isDisableSchemaCache() {
        return this.disableSchemaCache;
    }

    public void setDisableSchemaCache(boolean disableSchemaCache) {
        this.disableSchemaCache = disableSchemaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefinition(Definition wsdl) {
        Map<Object, Definition> map3 = this.definitionsMap;
        synchronized (map3) {
            ArrayList<Object> keys2 = new ArrayList<Object>();
            for (Map.Entry<Object, Definition> entry2 : this.definitionsMap.entrySet()) {
                if (entry2.getValue() != wsdl) continue;
                keys2.add(entry2.getKey());
            }
            for (Map.Entry<Object, Definition> entry3 : keys2) {
                this.definitionsMap.remove(entry3);
                this.schemaCacheMap.remove(entry3);
            }
        }
    }
}

