/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class TextHandler
implements DataContentHandler {
    ActivationDataFlavor dataFlavor;

    public TextHandler() {
        this.dataFlavor = new ActivationDataFlavor(String.class, "text/plain", "Text String");
    }

    public TextHandler(ActivationDataFlavor dataFlavor) {
        this.dataFlavor = dataFlavor;
    }

    protected ActivationDataFlavor getDF() {
        return this.dataFlavor;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.dataFlavor};
    }

    public Object getTransferData(DataFlavor dataflavor, DataSource datasource) throws IOException {
        if (this.getDF().equals(dataflavor)) {
            return this.getContent(datasource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContent(DataSource datasource) throws IOException {
        InputStream is2 = datasource.getInputStream();
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        byte[] buffer = new byte[1000];
        try {
            int count2;
            while ((count2 = is2.read(buffer, 0, buffer.length)) > 0) {
                os2.write(buffer, 0, count2);
            }
        }
        finally {
            is2.close();
        }
        try {
            return os2.toString(this.getCharSet(datasource.getContentType()));
        }
        catch (ParseException e2) {
            throw new UnsupportedEncodingException(e2.getMessage());
        }
    }

    public void writeTo(Object object, String contentType, OutputStream outputstream) throws IOException {
        OutputStreamWriter os2;
        try {
            String charset = this.getCharSet(contentType);
            os2 = new OutputStreamWriter(outputstream, charset);
        }
        catch (Exception ex2) {
            throw new UnsupportedEncodingException(ex2.toString());
        }
        String content2 = (String)object;
        os2.write(content2, 0, content2.length());
        os2.flush();
    }

    protected String getCharSet(String contentType) throws ParseException {
        ContentType type = new ContentType(contentType);
        String charset = type.getParameter("charset");
        if (charset == null) {
            charset = "us-ascii";
        }
        return MimeUtility.javaCharset(charset);
    }
}

