/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.geronimo.mail.util.Encoder;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        for (int i = 0; i < this.encodingTable.length; ++i) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        for (int i = off; i < off + length2; ++i) {
            int v = data2[i] & 0xFF;
            out.write(this.encodingTable[v >>> 4]);
            out.write(this.encodingTable[v & 0xF]);
        }
        return length2 * 2;
    }

    private boolean ignore(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    public int decode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int end2;
        int outLen = 0;
        for (end2 = off + length2; end2 > 0 && this.ignore((char)data2[end2 - 1]); --end2) {
        }
        int i = off;
        while (i < end2) {
            while (i < end2 && this.ignore((char)data2[i])) {
                ++i;
            }
            byte b1 = this.decodingTable[data2[i++]];
            while (i < end2 && this.ignore((char)data2[i])) {
                ++i;
            }
            byte b2 = this.decodingTable[data2[i++]];
            out.write(b1 << 4 | b2);
            ++outLen;
        }
        return outLen;
    }

    public int decode(String data2, OutputStream out) throws IOException {
        int end2;
        int length2 = 0;
        for (end2 = data2.length(); end2 > 0 && this.ignore(data2.charAt(end2 - 1)); --end2) {
        }
        int i = 0;
        while (i < end2) {
            while (i < end2 && this.ignore(data2.charAt(i))) {
                ++i;
            }
            byte b1 = this.decodingTable[data2.charAt(i++)];
            while (i < end2 && this.ignore(data2.charAt(i))) {
                ++i;
            }
            byte b2 = this.decodingTable[data2.charAt(i++)];
            out.write(b1 << 4 | b2);
            ++length2;
        }
        return length2;
    }
}

