/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.MimeUtility;
import org.apache.geronimo.mail.util.Encoder;
import org.apache.geronimo.mail.util.StringBufferOutputStream;

public class RFC2231Encoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    protected String DEFAULT_SPECIALS;
    protected String specials = this.DEFAULT_SPECIALS = " *'%";
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        for (int i = 0; i < this.encodingTable.length; ++i) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
        }
    }

    public RFC2231Encoder() {
        this(null);
    }

    public RFC2231Encoder(String specials) {
        if (specials != null) {
            this.specials = this.DEFAULT_SPECIALS + specials;
        }
        this.initialiseDecodingTable();
    }

    public int encode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int bytesWritten = 0;
        for (int i = off; i < off + length2; ++i) {
            int ch = data2[i] & 0xFF;
            if (ch <= 32 || ch >= 127 || this.specials.indexOf(ch) != -1) {
                out.write(37);
                out.write(this.encodingTable[ch >> 4]);
                out.write(this.encodingTable[ch & 0xF]);
                bytesWritten += 3;
                continue;
            }
            out.write((byte)ch);
            ++bytesWritten;
        }
        return bytesWritten;
    }

    public int decode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int outLen = 0;
        int end2 = off + length2;
        int i = off;
        while (i < end2) {
            byte v;
            if ((v = data2[i++]) == 37) {
                byte b1 = this.decodingTable[data2[i++]];
                byte b2 = this.decodingTable[data2[i++]];
                out.write(b1 << 4 | b2);
            } else {
                out.write(v);
            }
            ++outLen;
        }
        return outLen;
    }

    public int decode(String data2, OutputStream out) throws IOException {
        int length2 = 0;
        int end2 = data2.length();
        int i = 0;
        while (i < end2) {
            char v;
            if ((v = data2.charAt(i++)) == '%') {
                byte b1 = this.decodingTable[data2.charAt(i++)];
                byte b2 = this.decodingTable[data2.charAt(i++)];
                out.write(b1 << 4 | b2);
            } else {
                out.write((byte)v);
            }
            ++length2;
        }
        return length2;
    }

    public String encode(String charset, String language2, String data2) throws IOException {
        byte[] bytes2 = null;
        try {
            bytes2 = data2.getBytes(MimeUtility.javaCharset(charset));
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
        StringBuffer result2 = new StringBuffer();
        if (charset != null) {
            result2.append(charset);
        }
        result2.append("'");
        if (language2 != null) {
            result2.append(language2);
        }
        result2.append("'");
        StringBufferOutputStream out = new StringBufferOutputStream(result2);
        this.encode(bytes2, 0, bytes2.length, out);
        return result2.toString();
    }

    public String decode(String data2) throws IOException, UnsupportedEncodingException {
        int charsetEnd = data2.indexOf(39);
        if (charsetEnd == -1) {
            throw new IOException("Missing charset in RFC2231 encoded value");
        }
        String charset = data2.substring(0, charsetEnd);
        int languageEnd = data2.indexOf(39, charsetEnd + 1);
        if (languageEnd == -1) {
            throw new IOException("Missing language in RFC2231 encoded value");
        }
        String language2 = data2.substring(charsetEnd + 1, languageEnd);
        ByteArrayOutputStream out = new ByteArrayOutputStream(data2.length());
        this.decode(data2.substring(languageEnd + 1), out);
        byte[] bytes2 = out.toByteArray();
        return new String(bytes2, 0, bytes2.length, MimeUtility.javaCharset(charset));
    }
}

