/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.geronimo.mail.util.Encoder;

public class UUEncoder
implements Encoder {
    private static final int MAX_CHARS_PER_LINE = 45;

    public int encode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int byteCount = 0;
        while (length2 > 45) {
            byteCount += this.encodeLine(data2, off, 45, out);
            length2 -= 45;
            off += 45;
        }
        return byteCount += this.encodeLine(data2, off, 45, out);
    }

    private int encodeLine(byte[] data2, int offset2, int length2, OutputStream out) throws IOException {
        out.write((byte)((length2 & 0x3F) + 32));
        int bytesWritten = 2;
        int i = 0;
        while (i < length2) {
            byte b = 1;
            byte c2 = 1;
            byte a2 = data2[offset2 + i++];
            if (i < length2) {
                b = data2[offset2 + i++];
                if (i < length2) {
                    c2 = data2[offset2 + i++];
                }
            }
            byte d1 = (byte)((a2 >>> 2 & 0x3F) + 32);
            byte d2 = (byte)((a2 << 4 & 0x30 | b >>> 4 & 0xF) + 32);
            byte d3 = (byte)((b << 2 & 0x3C | c2 >>> 6 & 3) + 32);
            byte d4 = (byte)((c2 & 0x3F) + 32);
            out.write(d1);
            out.write(d2);
            out.write(d3);
            out.write(d4);
            bytesWritten += 4;
        }
        out.write(10);
        return bytesWritten;
    }

    public int decode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int bytesWritten = 0;
        while (length2 > 0) {
            int lineOffset = off;
            while (length2 > 0 && data2[off] != 10) {
                ++off;
                --length2;
            }
            bytesWritten += this.decodeLine(data2, lineOffset, off - lineOffset, out);
            ++off;
            --length2;
        }
        return bytesWritten;
    }

    private int decodeLine(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int count2;
        if ((count2 = data2[off++]) < 32) {
            throw new IOException("Invalid UUEncode line length");
        }
        int requiredLength = ((count2 = count2 - 32 & 0x3F) * 8 + 5) / 6 + 1;
        if (length2 < requiredLength) {
            throw new IOException("UUEncoded data and length do not match");
        }
        int bytesWritten = 0;
        while (bytesWritten < count2) {
            byte a2 = (byte)(data2[off++] - 32 & 0x3F);
            byte b = (byte)(data2[off++] - 32 & 0x3F);
            byte c2 = 0;
            byte d = 0;
            byte first2 = (byte)(a2 << 2 & 0xFC | b >>> 4 & 3);
            out.write(first2);
            if (++bytesWritten >= count2) continue;
            c2 = (byte)(data2[off++] - 32 & 0x3F);
            byte second2 = (byte)(b << 4 & 0xF0 | c2 >>> 2 & 0xF);
            out.write(second2);
            if (++bytesWritten >= count2) continue;
            d = (byte)(data2[off++] - 32 & 0x3F);
            byte third = (byte)(c2 << 6 & 0xC0 | d & 0x3F);
            out.write(third);
            ++bytesWritten;
        }
        return bytesWritten;
    }

    public int decode(String data2, OutputStream out) throws IOException {
        try {
            byte[] bytes2 = data2.getBytes("US-ASCII");
            return this.decode(bytes2, 0, bytes2.length, out);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IOException("Invalid UUEncoding");
        }
    }
}

