/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.geronimo.mail.util.Encoder;

public class XTextEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        for (int i = 0; i < this.encodingTable.length; ++i) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
        }
    }

    public XTextEncoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int bytesWritten = 0;
        for (int i = off; i < off + length2; ++i) {
            int v = data2[i] & 0xFF;
            if (v < 33 || v > 126 || v == 43 || v == 43) {
                out.write(43);
                out.write(this.encodingTable[v >>> 4]);
                out.write(this.encodingTable[v & 0xF]);
                bytesWritten += 3;
                continue;
            }
            out.write((byte)v);
            ++bytesWritten;
        }
        return bytesWritten;
    }

    public int decode(byte[] data2, int off, int length2, OutputStream out) throws IOException {
        int outLen = 0;
        int end2 = off + length2;
        int i = off;
        while (i < end2) {
            byte v;
            if ((v = data2[i++]) == 43) {
                byte b1 = this.decodingTable[data2[i++]];
                byte b2 = this.decodingTable[data2[i++]];
                out.write(b1 << 4 | b2);
            } else {
                out.write(v);
            }
            ++outLen;
        }
        return outLen;
    }

    public int decode(String data2, OutputStream out) throws IOException {
        int length2 = 0;
        int end2 = data2.length();
        int i = 0;
        while (i < end2) {
            char v;
            if ((v = data2.charAt(i++)) == '+') {
                byte b1 = this.decodingTable[data2.charAt(i++)];
                byte b2 = this.decodingTable[data2.charAt(i++)];
                out.write(b1 << 4 | b2);
            } else {
                out.write((byte)v);
            }
            ++length2;
        }
        return length2;
    }
}

