/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.LogLog;

public class ConsoleAppender
extends WriterAppender {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    protected String target = "System.out";

    public ConsoleAppender() {
    }

    public ConsoleAppender(Layout layout) {
        this(layout, SYSTEM_OUT);
    }

    public ConsoleAppender(Layout layout, String target2) {
        this.setLayout(layout);
        this.setTarget(target2);
        this.activateOptions();
    }

    public void activateOptions() {
        if (this.target.equals(SYSTEM_ERR)) {
            this.setWriter(this.createWriter(new SystemErrStream()));
        } else {
            this.setWriter(this.createWriter(new SystemOutStream()));
        }
        super.activateOptions();
    }

    protected final void closeWriter() {
        super.closeWriter();
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String value2) {
        String v = value2.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(v)) {
            this.target = SYSTEM_OUT;
        } else if (SYSTEM_ERR.equalsIgnoreCase(v)) {
            this.target = SYSTEM_ERR;
        } else {
            this.targetWarn(value2);
        }
    }

    void targetWarn(String val) {
        LogLog.warn("[" + val + "] should be System.out or System.err.");
        LogLog.warn("Using previously set target, System.out by default.");
    }

    private static class SystemErrStream
    extends OutputStream {
        public void close() {
        }

        public void flush() {
            System.err.flush();
        }

        public void write(int b) throws IOException {
            System.err.write(b);
        }

        public void write(byte[] b) throws IOException {
            ((FilterOutputStream)System.err).write(b);
        }

        public void write(byte[] b, int off, int len2) throws IOException {
            System.err.write(b, off, len2);
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        public void close() {
        }

        public void flush() {
            System.out.flush();
        }

        public void write(int b) throws IOException {
            System.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            ((FilterOutputStream)System.out).write(b);
        }

        public void write(byte[] b, int off, int len2) throws IOException {
            System.out.write(b, off, len2);
        }
    }
}

