/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerRepository;

public class OptionConverter {
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Level;
    static /* synthetic */ Class class$org$apache$log4j$spi$Configurator;

    private OptionConverter() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static String[] concatanateArrays(String[] l, String[] r) {
        int len2 = l.length + r.length;
        String[] a2 = new String[len2];
        System.arraycopy(l, 0, a2, 0, l.length);
        System.arraycopy(r, 0, a2, l.length, r.length);
        return a2;
    }

    public static String convertSpecialChars(String s2) {
        int len2 = s2.length();
        StringBuffer sbuf = new StringBuffer(len2);
        int i = 0;
        while (i < len2) {
            int c2;
            if ((c2 = s2.charAt(i++)) == 92) {
                if ((c2 = s2.charAt(i++)) == 110) {
                    c2 = 10;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 116) {
                    c2 = 9;
                } else if (c2 == 102) {
                    c2 = 12;
                } else if (c2 == 8) {
                    c2 = 8;
                } else if (c2 == 34) {
                    c2 = 34;
                } else if (c2 == 39) {
                    c2 = 39;
                } else if (c2 == 92) {
                    c2 = 92;
                }
            }
            sbuf.append((char)c2);
        }
        return sbuf.toString();
    }

    public static String findAndSubst(String key, Properties props) {
        String value2 = props.getProperty(key);
        if (value2 == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value2, props);
        }
        catch (IllegalArgumentException e2) {
            LogLog.error("Bad option value [" + value2 + "].", e2);
            return value2;
        }
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable throwable2) {
            LogLog.debug("Was not allowed to read system property \"" + key + "\".");
            return def;
        }
    }

    public static Object instantiateByClassName(String className, Class superClass, Object defaultValue) {
        if (className != null) {
            try {
                Class classObj = Loader.loadClass(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    LogLog.error("A \"" + className + "\" object is not assignable to a \"" + superClass.getName() + "\" variable.");
                    LogLog.error("The class \"" + superClass.getName() + "\" was loaded by ");
                    LogLog.error("[" + superClass.getClassLoader() + "] whereas object of type ");
                    LogLog.error("\"" + classObj.getName() + "\" was loaded by [" + classObj.getClassLoader() + "].");
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (Exception e2) {
                LogLog.error("Could not instantiate class [" + className + "].", e2);
            }
        }
        return defaultValue;
    }

    public static Object instantiateByKey(Properties props, String key, Class superClass, Object defaultValue) {
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            LogLog.error("Could not find value for key " + key);
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(className.trim(), superClass, defaultValue);
    }

    public static void selectAndConfigure(URL url, String clazz2, LoggerRepository hierarchy) {
        Configurator configurator = null;
        String filename = url.getFile();
        if (clazz2 == null && filename != null && filename.endsWith(".xml")) {
            clazz2 = "org.apache.log4j.xml.DOMConfigurator";
        }
        if (clazz2 != null) {
            LogLog.debug("Preferred configurator class: " + clazz2);
            configurator = (Configurator)OptionConverter.instantiateByClassName(clazz2, class$org$apache$log4j$spi$Configurator != null ? class$org$apache$log4j$spi$Configurator : (class$org$apache$log4j$spi$Configurator = OptionConverter.class$("org.apache.log4j.spi.Configurator")), null);
            if (configurator == null) {
                LogLog.error("Could not instantiate configurator [" + clazz2 + "].");
                return;
            }
        } else {
            configurator = new PropertyConfigurator();
        }
        configurator.doConfigure(url, hierarchy);
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(DELIM_STOP, j);
            if (k == -1) {
                throw new IllegalArgumentException(String.valueOf('\"') + val + "\" has no closing brace. Opening brace at position " + j + '.');
            }
            String key = val.substring(j += DELIM_START_LEN, k);
            String replacement = OptionConverter.getSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                String recursiveReplacement = OptionConverter.substVars(replacement, props);
                sbuf.append(recursiveReplacement);
            }
            i = k + DELIM_STOP_LEN;
        }
    }

    public static boolean toBoolean(String value2, boolean dEfault) {
        if (value2 == null) {
            return dEfault;
        }
        String trimmedVal = value2.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static long toFileSize(String value2, long dEfault) {
        if (value2 == null) {
            return dEfault;
        }
        String s2 = value2.trim().toUpperCase();
        long multiplier = 1L;
        int index2 = s2.indexOf("KB");
        if (index2 != -1) {
            multiplier = 1024L;
            s2 = s2.substring(0, index2);
        } else {
            index2 = s2.indexOf("MB");
            if (index2 != -1) {
                multiplier = 0x100000L;
                s2 = s2.substring(0, index2);
            } else {
                index2 = s2.indexOf("GB");
                if (index2 != -1) {
                    multiplier = 0x40000000L;
                    s2 = s2.substring(0, index2);
                }
            }
        }
        if (s2 != null) {
            try {
                return Long.valueOf(s2) * multiplier;
            }
            catch (NumberFormatException e2) {
                LogLog.error("[" + s2 + "] is not in proper int form.");
                LogLog.error("[" + value2 + "] not in expected format.", e2);
            }
        }
        return dEfault;
    }

    public static int toInt(String value2, int dEfault) {
        if (value2 != null) {
            String s2 = value2.trim();
            try {
                return Integer.valueOf(s2);
            }
            catch (NumberFormatException e2) {
                LogLog.error("[" + s2 + "] is not in proper int form.");
                e2.printStackTrace();
            }
        }
        return dEfault;
    }

    public static Level toLevel(String value2, Level defaultValue) {
        if (value2 == null) {
            return defaultValue;
        }
        int hashIndex = value2.indexOf(35);
        if (hashIndex == -1) {
            if ("NULL".equalsIgnoreCase(value2)) {
                return null;
            }
            return Level.toLevel(value2, defaultValue);
        }
        Level result2 = defaultValue;
        String clazz2 = value2.substring(hashIndex + 1);
        String levelName = value2.substring(0, hashIndex);
        if ("NULL".equalsIgnoreCase(levelName)) {
            return null;
        }
        LogLog.debug("toLevel:class=[" + clazz2 + "]" + ":pri=[" + levelName + "]");
        try {
            Class customLevel = Loader.loadClass(clazz2);
            Class[] paramTypes2 = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = OptionConverter.class$("java.lang.String")), class$org$apache$log4j$Level != null ? class$org$apache$log4j$Level : (class$org$apache$log4j$Level = OptionConverter.class$("org.apache.log4j.Level"))};
            Method toLevelMethod = customLevel.getMethod("toLevel", paramTypes2);
            Object[] params2 = new Object[]{levelName, defaultValue};
            Object o = toLevelMethod.invoke(null, params2);
            result2 = (Level)o;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.warn("custom level class [" + clazz2 + "] not found.");
        }
        catch (NoSuchMethodException e2) {
            LogLog.warn("custom level class [" + clazz2 + "]" + " does not have a constructor which takes one string parameter", e2);
        }
        catch (InvocationTargetException e3) {
            LogLog.warn("custom level class [" + clazz2 + "]" + " could not be instantiated", e3);
        }
        catch (ClassCastException e4) {
            LogLog.warn("class [" + clazz2 + "] is not a subclass of org.apache.log4j.Level", e4);
        }
        catch (IllegalAccessException e5) {
            LogLog.warn("class [" + clazz2 + "] cannot be instantiated due to access restrictions", e5);
        }
        catch (Exception e6) {
            LogLog.warn("class [" + clazz2 + "], level [" + levelName + "] conversion failed.", e6);
        }
        return result2;
    }
}

