/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.spi.LoggingEvent;

public abstract class PatternConverter {
    public PatternConverter next;
    int min = -1;
    int max = Integer.MAX_VALUE;
    boolean leftAlign = false;
    static String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};

    protected PatternConverter() {
    }

    protected PatternConverter(FormattingInfo fi) {
        this.min = fi.min;
        this.max = fi.max;
        this.leftAlign = fi.leftAlign;
    }

    protected abstract String convert(LoggingEvent var1);

    public void format(StringBuffer sbuf, LoggingEvent e2) {
        String s2 = this.convert(e2);
        if (s2 == null) {
            if (this.min > 0) {
                this.spacePad(sbuf, this.min);
            }
            return;
        }
        int len2 = s2.length();
        if (len2 > this.max) {
            sbuf.append(s2.substring(len2 - this.max));
        } else if (len2 < this.min) {
            if (this.leftAlign) {
                sbuf.append(s2);
                this.spacePad(sbuf, this.min - len2);
            } else {
                this.spacePad(sbuf, this.min - len2);
                sbuf.append(s2);
            }
        } else {
            sbuf.append(s2);
        }
    }

    public void spacePad(StringBuffer sbuf, int length2) {
        while (length2 >= 32) {
            sbuf.append(SPACES[5]);
            length2 -= 32;
        }
        int i = 4;
        while (i >= 0) {
            if ((length2 & 1 << i) != 0) {
                sbuf.append(SPACES[i]);
            }
            --i;
        }
    }
}

