/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jmx;

import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.jmx.AbstractDynamicMBean;
import org.apache.log4j.jmx.LoggerDynamicMBean;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerRepository;

public class HierarchyDynamicMBean
extends AbstractDynamicMBean
implements HierarchyEventListener,
NotificationBroadcaster {
    static final String ADD_APPENDER = "addAppender.";
    static final String THRESHOLD = "threshold";
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private Vector vAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private String dDescription = "This MBean acts as a management facade for org.apache.log4j.Hierarchy.";
    private NotificationBroadcasterSupport nbs = new NotificationBroadcasterSupport();
    private LoggerRepository hierarchy = LogManager.getLoggerRepository();
    private static Logger log = Logger.getLogger(class$org$apache$log4j$jmx$HierarchyDynamicMBean != null ? class$org$apache$log4j$jmx$HierarchyDynamicMBean : (class$org$apache$log4j$jmx$HierarchyDynamicMBean = HierarchyDynamicMBean.class$("org.apache.log4j.jmx.HierarchyDynamicMBean")));
    static /* synthetic */ Class class$org$apache$log4j$jmx$HierarchyDynamicMBean;

    public HierarchyDynamicMBean() {
        this.buildDynamicMBeanInfo();
    }

    public void addAppenderEvent(Category category2, Appender appender) {
        log.debug("addAppenderEvent called: logger=" + category2.getName() + ", appender=" + appender.getName());
        Notification notification = new Notification(ADD_APPENDER + category2.getName(), this, 0L);
        notification.setUserData(appender);
        log.debug("sending notification.");
        this.nbs.sendNotification(notification);
    }

    public ObjectName addLoggerMBean(String string2) {
        Logger logger = LogManager.exists(string2);
        if (logger != null) {
            return this.addLoggerMBean(logger);
        }
        return null;
    }

    ObjectName addLoggerMBean(Logger logger) {
        String string2 = logger.getName();
        ObjectName objectName = null;
        try {
            LoggerDynamicMBean loggerDynamicMBean = new LoggerDynamicMBean(logger);
            objectName = new ObjectName("log4j", "logger", string2);
            this.server.registerMBean(loggerDynamicMBean, objectName);
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType(ADD_APPENDER + logger.getName());
            log.debug("---Adding logger [" + string2 + "] as listener.");
            this.nbs.addNotificationListener(loggerDynamicMBean, notificationFilterSupport, null);
            this.vAttributes.add(new MBeanAttributeInfo("logger=" + string2, "javax.management.ObjectName", "The " + string2 + " logger.", true, true, false));
        }
        catch (Exception exception) {
            log.error("Couls not add loggerMBean for [" + string2 + "].");
        }
        return objectName;
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.nbs.addNotificationListener(notificationListener, notificationFilter, object);
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("HierarchyDynamicMBean(): Constructs a HierarchyDynamicMBean instance", constructorArray[0]);
        this.vAttributes.add(new MBeanAttributeInfo(THRESHOLD, "java.lang.String", "The \"threshold\" state of the hiearchy.", true, true, false));
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", "Create a logger MBean")};
        this.dOperations[0] = new MBeanOperationInfo("addLoggerMBean", "addLoggerMBean(): add a loggerMBean", mBeanParameterInfoArray, "javax.management.ObjectName", 1);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object getAttribute(String string2) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        log.debug("Called getAttribute with [" + string2 + "].");
        if (string2.equals(THRESHOLD)) {
            return this.hierarchy.getThreshold();
        }
        if (string2.startsWith("logger")) {
            int n = string2.indexOf("%3D");
            String string3 = string2;
            if (n > 0) {
                string3 = String.valueOf(string2.substring(0, n)) + '=' + string2.substring(n + 3);
            }
            try {
                return new ObjectName("log4j:" + string3);
            }
            catch (Exception exception) {
                log.error("Could not create ObjectName" + string3);
            }
        }
        throw new AttributeNotFoundException("Cannot find " + string2 + " attribute in " + this.dClassName);
    }

    protected Logger getLogger() {
        return log;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.vAttributes.size()];
        this.vAttributes.toArray(mBeanAttributeInfoArray);
        return new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.nbs.getNotificationInfo();
    }

    public Object invoke(String string2, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (string2.equals("addLoggerMBean")) {
            return this.addLoggerMBean((String)objectArray[0]);
        }
        throw new ReflectionException(new NoSuchMethodException(string2), "Cannot find the operation " + string2 + " in " + this.dClassName);
    }

    public void postRegister(Boolean bl) {
        log.debug("postRegister is called.");
        this.hierarchy.addHierarchyEventListener(this);
        Logger logger = this.hierarchy.getRootLogger();
        this.addLoggerMBean(logger);
    }

    public void removeAppenderEvent(Category category2, Appender appender) {
        log.debug("removeAppenderCalled: logger=" + category2.getName() + ", appender=" + appender.getName());
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.nbs.removeNotificationListener(notificationListener);
    }

    public void setAttribute(Attribute attribute2) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String string2 = attribute2.getName();
        Object object = attribute2.getValue();
        if (string2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        if (string2.equals(THRESHOLD)) {
            Level level2 = OptionConverter.toLevel((String)object, this.hierarchy.getThreshold());
            this.hierarchy.setThreshold(level2);
        }
    }
}

