/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5;

import java.awt.Toolkit;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.lf5.AppenderFinalizer;
import org.apache.log4j.lf5.Log4JLogRecord;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class LF5Appender
extends AppenderSkeleton {
    protected LogBrokerMonitor _logMonitor;
    protected static LogBrokerMonitor _defaultLogMonitor;
    protected static AppenderFinalizer _finalizer;

    public LF5Appender() {
        this(LF5Appender.getDefaultInstance());
    }

    public LF5Appender(LogBrokerMonitor monitor) {
        if (monitor != null) {
            this._logMonitor = monitor;
        }
    }

    public void append(LoggingEvent event) {
        String category2 = event.getLoggerName();
        String logMessage = event.getRenderedMessage();
        String nestedDiagnosticContext = event.getNDC();
        String threadDescription = event.getThreadName();
        String level2 = event.getLevel().toString();
        long time = event.timeStamp;
        LocationInfo locationInfo = event.getLocationInformation();
        Log4JLogRecord record2 = new Log4JLogRecord();
        record2.setCategory(category2);
        record2.setMessage(logMessage);
        record2.setLocation(locationInfo.fullInfo);
        record2.setMillis(time);
        record2.setThreadDescription(threadDescription);
        if (nestedDiagnosticContext != null) {
            record2.setNDC(nestedDiagnosticContext);
        } else {
            record2.setNDC("");
        }
        if (event.getThrowableInformation() != null) {
            record2.setThrownStackTrace(event.getThrowableInformation());
        }
        try {
            record2.setLevel(LogLevel.valueOf(level2));
        }
        catch (LogLevelFormatException logLevelFormatException) {
            record2.setLevel(LogLevel.WARN);
        }
        if (this._logMonitor != null) {
            this._logMonitor.addMessage(record2);
        }
    }

    public void close() {
    }

    public boolean equals(LF5Appender compareTo) {
        return this._logMonitor == compareTo.getLogBrokerMonitor();
    }

    protected static synchronized LogBrokerMonitor getDefaultInstance() {
        block2: {
            if (_defaultLogMonitor != null) break block2;
            try {
                _defaultLogMonitor = new LogBrokerMonitor(LogLevel.getLog4JLevels());
                _finalizer = new AppenderFinalizer(_defaultLogMonitor);
                _defaultLogMonitor.setFrameSize(LF5Appender.getDefaultMonitorWidth(), LF5Appender.getDefaultMonitorHeight());
                _defaultLogMonitor.setFontSize(12);
                _defaultLogMonitor.show();
            }
            catch (SecurityException securityException) {
                _defaultLogMonitor = null;
            }
        }
        return _defaultLogMonitor;
    }

    protected static int getDefaultMonitorHeight() {
        return 3 * LF5Appender.getScreenHeight() / 4;
    }

    protected static int getDefaultMonitorWidth() {
        return 3 * LF5Appender.getScreenWidth() / 4;
    }

    public LogBrokerMonitor getLogBrokerMonitor() {
        return this._logMonitor;
    }

    protected static int getScreenHeight() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().height;
        }
        catch (Throwable throwable2) {
            return 600;
        }
    }

    protected static int getScreenWidth() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().width;
        }
        catch (Throwable throwable2) {
            return 800;
        }
    }

    public static void main(String[] args2) {
        new LF5Appender();
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setCallSystemExitOnClose(boolean callSystemExitOnClose) {
        this._logMonitor.setCallSystemExitOnClose(callSystemExitOnClose);
    }

    public void setMaxNumberOfRecords(int maxNumberOfRecords) {
        _defaultLogMonitor.setMaxNumberOfLogRecords(maxNumberOfRecords);
    }
}

