/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogRecord;

public class AdapterLogRecord
extends LogRecord {
    private static LogLevel severeLevel = null;
    private static StringWriter sw = new StringWriter();
    private static PrintWriter pw = new PrintWriter(sw);

    protected String getLocationInfo(String category2) {
        String stackTrace = this.stackTraceToString(new Throwable());
        String line = this.parseLine(stackTrace, category2);
        return line;
    }

    public static LogLevel getSevereLevel() {
        return severeLevel;
    }

    public boolean isSevereLevel() {
        if (severeLevel == null) {
            return false;
        }
        return severeLevel.equals(this.getLevel());
    }

    protected String parseLine(String trace, String category2) {
        int index2 = trace.indexOf(category2);
        if (index2 == -1) {
            return null;
        }
        trace = trace.substring(index2);
        trace = trace.substring(0, trace.indexOf(")") + 1);
        return trace;
    }

    public void setCategory(String category2) {
        super.setCategory(category2);
        super.setLocation(this.getLocationInfo(category2));
    }

    public static void setSevereLevel(LogLevel level2) {
        severeLevel = level2;
    }

    protected String stackTraceToString(Throwable t2) {
        String s2 = null;
        StringWriter stringWriter = sw;
        synchronized (stringWriter) {
            t2.printStackTrace(pw);
            s2 = sw.toString();
            sw.getBuffer().setLength(0);
        }
        return s2;
    }
}

