/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.log4j.lf5.Log4JLogRecord;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.lf5.viewer.LogFactor5ErrorDialog;
import org.apache.log4j.lf5.viewer.LogFactor5LoadingDialog;

public class LogFileParser
implements Runnable {
    public static final String RECORD_DELIMITER = "[slf5s.start]";
    public static final String ATTRIBUTE_DELIMITER = "[slf5s.";
    public static final String DATE_DELIMITER = "[slf5s.DATE]";
    public static final String THREAD_DELIMITER = "[slf5s.THREAD]";
    public static final String CATEGORY_DELIMITER = "[slf5s.CATEGORY]";
    public static final String LOCATION_DELIMITER = "[slf5s.LOCATION]";
    public static final String MESSAGE_DELIMITER = "[slf5s.MESSAGE]";
    public static final String PRIORITY_DELIMITER = "[slf5s.PRIORITY]";
    public static final String NDC_DELIMITER = "[slf5s.NDC]";
    private static SimpleDateFormat _sdf = new SimpleDateFormat("dd MMM yyyy HH:mm:ss,S");
    private LogBrokerMonitor _monitor;
    LogFactor5LoadingDialog _loadDialog;
    private InputStream _in = null;

    public LogFileParser(File file) throws IOException, FileNotFoundException {
        this(new FileInputStream(file));
    }

    public LogFileParser(InputStream stream2) throws IOException {
        this._in = stream2;
    }

    private LogRecord createLogRecord(String record2) {
        if (record2 == null || record2.trim().length() == 0) {
            return null;
        }
        Log4JLogRecord lr = new Log4JLogRecord();
        lr.setMillis(this.parseDate(record2));
        lr.setLevel(this.parsePriority(record2));
        lr.setCategory(this.parseCategory(record2));
        lr.setLocation(this.parseLocation(record2));
        lr.setThreadDescription(this.parseThread(record2));
        lr.setNDC(this.parseNDC(record2));
        lr.setMessage(this.parseMessage(record2));
        lr.setThrownStackTrace(this.parseThrowable(record2));
        return lr;
    }

    private void destroyDialog() {
        this._loadDialog.hide();
        this._loadDialog.dispose();
    }

    protected void displayError(String message) {
        LogFactor5ErrorDialog error2 = new LogFactor5ErrorDialog(this._monitor.getBaseFrame(), message);
    }

    private String getAttribute(int index2, String record2) {
        int start2 = record2.lastIndexOf(ATTRIBUTE_DELIMITER, index2 - 1);
        if (start2 == -1) {
            return record2.substring(0, index2);
        }
        start2 = record2.indexOf("]", start2);
        return record2.substring(start2 + 1, index2).trim();
    }

    private String loadLogFile(InputStream stream2) throws IOException {
        BufferedInputStream br2 = new BufferedInputStream(stream2);
        int count2 = 0;
        int size2 = br2.available();
        StringBuffer sb = null;
        sb = size2 > 0 ? new StringBuffer(size2) : new StringBuffer(1024);
        while ((count2 = br2.read()) != -1) {
            sb.append((char)count2);
        }
        br2.close();
        br2 = null;
        return sb.toString();
    }

    public void parse(LogBrokerMonitor monitor) throws RuntimeException {
        this._monitor = monitor;
        Thread t2 = new Thread(this);
        t2.start();
    }

    private String parseAttribute(String name, String record2) {
        int index2 = record2.indexOf(name);
        if (index2 == -1) {
            return null;
        }
        return this.getAttribute(index2, record2);
    }

    private String parseCategory(String record2) {
        return this.parseAttribute(CATEGORY_DELIMITER, record2);
    }

    private long parseDate(String record2) {
        try {
            String s2 = this.parseAttribute(DATE_DELIMITER, record2);
            if (s2 == null) {
                return 0L;
            }
            Date d = _sdf.parse(s2);
            return d.getTime();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    private String parseLocation(String record2) {
        return this.parseAttribute(LOCATION_DELIMITER, record2);
    }

    private String parseMessage(String record2) {
        return this.parseAttribute(MESSAGE_DELIMITER, record2);
    }

    private String parseNDC(String record2) {
        return this.parseAttribute(NDC_DELIMITER, record2);
    }

    private LogLevel parsePriority(String record2) {
        String temp = this.parseAttribute(PRIORITY_DELIMITER, record2);
        if (temp != null) {
            try {
                return LogLevel.valueOf(temp);
            }
            catch (LogLevelFormatException logLevelFormatException) {
                return LogLevel.DEBUG;
            }
        }
        return LogLevel.DEBUG;
    }

    private String parseThread(String record2) {
        return this.parseAttribute(THREAD_DELIMITER, record2);
    }

    private String parseThrowable(String record2) {
        return this.getAttribute(record2.length(), record2);
    }

    public void run() {
        int index2 = 0;
        int counter = 0;
        boolean isLogFile = false;
        this._loadDialog = new LogFactor5LoadingDialog(this._monitor.getBaseFrame(), "Loading file...");
        try {
            LogRecord temp;
            String logRecords = this.loadLogFile(this._in);
            while ((counter = logRecords.indexOf(RECORD_DELIMITER, index2)) != -1) {
                temp = this.createLogRecord(logRecords.substring(index2, counter));
                isLogFile = true;
                if (temp != null) {
                    this._monitor.addMessage(temp);
                }
                index2 = counter + RECORD_DELIMITER.length();
            }
            if (index2 < logRecords.length() && isLogFile && (temp = this.createLogRecord(logRecords.substring(index2))) != null) {
                this._monitor.addMessage(temp);
            }
            if (!isLogFile) {
                throw new RuntimeException("Invalid log file format");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogFileParser.this.destroyDialog();
                }
            });
        }
        catch (RuntimeException runtimeException) {
            this.destroyDialog();
            this.displayError("Error - Invalid log file format.\nPlease see documentation on how to load log files.");
        }
        catch (IOException iOException) {
            this.destroyDialog();
            this.displayError("Error - Unable to load log file!");
        }
        this._in = null;
    }
}

