/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.util;

import java.awt.Toolkit;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.util.AdapterLogRecord;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;

public class LogMonitorAdapter {
    public static final int LOG4J_LOG_LEVELS = 0;
    public static final int JDK14_LOG_LEVELS = 1;
    private LogBrokerMonitor _logMonitor;
    private LogLevel _defaultLevel = null;

    private LogMonitorAdapter(List userDefinedLevels) {
        this._defaultLevel = (LogLevel)userDefinedLevels.get(0);
        this._logMonitor = new LogBrokerMonitor(userDefinedLevels);
        this._logMonitor.setFrameSize(LogMonitorAdapter.getDefaultMonitorWidth(), LogMonitorAdapter.getDefaultMonitorHeight());
        this._logMonitor.setFontSize(12);
        this._logMonitor.show();
    }

    public void addMessage(LogRecord record2) {
        this._logMonitor.addMessage(record2);
    }

    public LogLevel getDefaultLevel() {
        return this._defaultLevel;
    }

    protected static int getDefaultMonitorHeight() {
        return 3 * LogMonitorAdapter.getScreenHeight() / 4;
    }

    protected static int getDefaultMonitorWidth() {
        return 3 * LogMonitorAdapter.getScreenWidth() / 4;
    }

    protected static int getScreenHeight() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().height;
        }
        catch (Throwable throwable2) {
            return 600;
        }
    }

    protected static int getScreenWidth() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().width;
        }
        catch (Throwable throwable2) {
            return 800;
        }
    }

    public LogLevel getSevereLevel() {
        return AdapterLogRecord.getSevereLevel();
    }

    public void log(String category2, String message) {
        this.log(category2, null, message);
    }

    public void log(String category2, LogLevel level2, String message) {
        this.log(category2, level2, message, null, null);
    }

    public void log(String category2, LogLevel level2, String message, String NDC2) {
        this.log(category2, level2, message, null, NDC2);
    }

    public void log(String category2, LogLevel level2, String message, Throwable t2) {
        this.log(category2, level2, message, t2, null);
    }

    public void log(String category2, LogLevel level2, String message, Throwable t2, String NDC2) {
        AdapterLogRecord record2 = new AdapterLogRecord();
        record2.setCategory(category2);
        record2.setMessage(message);
        record2.setNDC(NDC2);
        record2.setThrown(t2);
        if (level2 == null) {
            record2.setLevel(this.getDefaultLevel());
        } else {
            record2.setLevel(level2);
        }
        this.addMessage(record2);
    }

    public static LogMonitorAdapter newInstance(int loglevels) {
        LogMonitorAdapter adapter;
        if (loglevels == 1) {
            adapter = LogMonitorAdapter.newInstance(LogLevel.getJdk14Levels());
            adapter.setDefaultLevel(LogLevel.FINEST);
            adapter.setSevereLevel(LogLevel.SEVERE);
        } else {
            adapter = LogMonitorAdapter.newInstance(LogLevel.getLog4JLevels());
            adapter.setDefaultLevel(LogLevel.DEBUG);
            adapter.setSevereLevel(LogLevel.FATAL);
        }
        return adapter;
    }

    public static LogMonitorAdapter newInstance(List userDefinedLevels) {
        return new LogMonitorAdapter(userDefinedLevels);
    }

    public static LogMonitorAdapter newInstance(LogLevel[] userDefined) {
        if (userDefined == null) {
            return null;
        }
        return LogMonitorAdapter.newInstance(Arrays.asList(userDefined));
    }

    public void setDefaultLevel(LogLevel level2) {
        this._defaultLevel = level2;
    }

    public void setMaxNumberOfRecords(int maxNumberOfRecords) {
        this._logMonitor.setMaxNumberOfLogRecords(maxNumberOfRecords);
    }

    public void setSevereLevel(LogLevel level2) {
        AdapterLogRecord.setSevereLevel(level2);
    }
}

