/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.LogRecordFilter;
import org.apache.log4j.lf5.PassingLogRecordFilter;

public class FilteredLogTableModel
extends AbstractTableModel {
    protected LogRecordFilter _filter = new PassingLogRecordFilter();
    protected List _allRecords = new ArrayList();
    protected List _filteredRecords;
    protected int _maxNumberOfLogRecords = 5000;
    protected String[] _colNames = new String[]{"Date", "Thread", "Message #", "Level", "NDC", "Category", "Message", "Location", "Thrown"};

    public synchronized boolean addLogRecord(LogRecord record2) {
        this._allRecords.add(record2);
        if (!this._filter.passes(record2)) {
            return false;
        }
        this.getFilteredRecords().add(record2);
        this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        this.trimRecords();
        return true;
    }

    public synchronized void clear() {
        this._allRecords.clear();
        this._filteredRecords.clear();
        this.fireTableDataChanged();
    }

    protected List createFilteredRecordsList() {
        ArrayList<LogRecord> result2 = new ArrayList<LogRecord>();
        Iterator records = this._allRecords.iterator();
        while (records.hasNext()) {
            LogRecord current = (LogRecord)records.next();
            if (!this._filter.passes(current)) continue;
            result2.add(current);
        }
        return result2;
    }

    public synchronized void fastRefresh() {
        this._filteredRecords.remove(0);
        this.fireTableRowsDeleted(0, 0);
    }

    protected Object getColumn(int col, LogRecord lr) {
        if (lr == null) {
            return "NULL Column";
        }
        String date = new Date(lr.getMillis()).toString();
        switch (col) {
            case 0: {
                return String.valueOf(date) + " (" + lr.getMillis() + ")";
            }
            case 1: {
                return lr.getThreadDescription();
            }
            case 2: {
                return new Long(lr.getSequenceNumber());
            }
            case 3: {
                return lr.getLevel();
            }
            case 4: {
                return lr.getNDC();
            }
            case 5: {
                return lr.getCategory();
            }
            case 6: {
                return lr.getMessage();
            }
            case 7: {
                return lr.getLocation();
            }
            case 8: {
                return lr.getThrownStackTrace();
            }
        }
        String message = "The column number " + col + "must be between 0 and 8";
        throw new IllegalArgumentException(message);
    }

    public int getColumnCount() {
        return this._colNames.length;
    }

    public String getColumnName(int i) {
        return this._colNames[i];
    }

    protected LogRecord getFilteredRecord(int row2) {
        List records = this.getFilteredRecords();
        int size2 = records.size();
        if (row2 < size2) {
            return (LogRecord)records.get(row2);
        }
        return (LogRecord)records.get(size2 - 1);
    }

    protected List getFilteredRecords() {
        if (this._filteredRecords == null) {
            this.refresh();
        }
        return this._filteredRecords;
    }

    public LogRecordFilter getLogRecordFilter() {
        return this._filter;
    }

    public int getRowCount() {
        return this.getFilteredRecords().size();
    }

    public int getTotalRowCount() {
        return this._allRecords.size();
    }

    public Object getValueAt(int row2, int col) {
        LogRecord record2 = this.getFilteredRecord(row2);
        return this.getColumn(col, record2);
    }

    protected boolean needsTrimming() {
        return this._allRecords.size() > this._maxNumberOfLogRecords;
    }

    private int numberOfRecordsToTrim() {
        return this._allRecords.size() - this._maxNumberOfLogRecords;
    }

    public synchronized void refresh() {
        this._filteredRecords = this.createFilteredRecordsList();
        this.fireTableDataChanged();
    }

    public void setLogRecordFilter(LogRecordFilter filter2) {
        this._filter = filter2;
    }

    public void setMaxNumberOfLogRecords(int maxNumRecords) {
        if (maxNumRecords > 0) {
            this._maxNumberOfLogRecords = maxNumRecords;
        }
    }

    protected void trimOldestRecords() {
        List list2 = this._allRecords;
        synchronized (list2) {
            int trim2 = this.numberOfRecordsToTrim();
            if (trim2 > 1) {
                List oldRecords = this._allRecords.subList(0, trim2);
                oldRecords.clear();
                this.refresh();
            } else {
                this._allRecords.remove(0);
                this.fastRefresh();
            }
        }
    }

    protected void trimRecords() {
        if (this.needsTrimming()) {
            this.trimOldestRecords();
        }
    }
}

