/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.awt.Adjustable;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.apache.log4j.lf5.viewer.TrackingAdjustmentListener;

public class LF5SwingUtils {
    protected static boolean contains(int row2, TableModel model) {
        if (model == null) {
            return false;
        }
        if (row2 < 0) {
            return false;
        }
        return row2 < model.getRowCount();
    }

    public static void makeScrollBarTrack(Adjustable scrollBar) {
        if (scrollBar == null) {
            return;
        }
        scrollBar.addAdjustmentListener(new TrackingAdjustmentListener());
    }

    public static void makeVerticalScrollBarTrack(JScrollPane pane) {
        if (pane == null) {
            return;
        }
        LF5SwingUtils.makeScrollBarTrack(pane.getVerticalScrollBar());
    }

    protected static void moveAdjustable(int location2, Adjustable scrollBar) {
        if (scrollBar == null) {
            return;
        }
        scrollBar.setValue(location2);
    }

    protected static void repaintLater(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.repaint();
            }
        });
    }

    public static void selectRow(int row2, JTable table2, JScrollPane pane) {
        if (table2 == null || pane == null) {
            return;
        }
        if (!LF5SwingUtils.contains(row2, table2.getModel())) {
            return;
        }
        LF5SwingUtils.moveAdjustable(row2 * table2.getRowHeight(), pane.getVerticalScrollBar());
        LF5SwingUtils.selectRow(row2, table2.getSelectionModel());
        LF5SwingUtils.repaintLater(table2);
    }

    protected static void selectRow(int row2, ListSelectionModel model) {
        if (model == null) {
            return;
        }
        model.setSelectionInterval(row2, row2);
    }
}

