/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryElement;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;

public class CategoryExplorerModel
extends DefaultTreeModel {
    protected boolean _renderFatal = true;
    protected ActionListener _listener = null;
    protected ActionEvent _event = new ActionEvent(this, 1001, "Nodes Selection changed");

    public CategoryExplorerModel(CategoryNode node4) {
        super(node4);
    }

    public synchronized void addActionListener(ActionListener l) {
        this._listener = AWTEventMulticaster.add(this._listener, l);
    }

    public CategoryNode addCategory(CategoryPath path2) {
        CategoryNode root2;
        CategoryNode parent2 = root2 = (CategoryNode)this.getRoot();
        int i = 0;
        while (i < path2.size()) {
            CategoryElement element2 = path2.categoryElementAt(i);
            Enumeration<TreeNode> children2 = parent2.children();
            boolean categoryAlreadyExists = false;
            while (children2.hasMoreElements()) {
                String pathLC;
                CategoryNode node4 = (CategoryNode)children2.nextElement();
                String title2 = node4.getTitle().toLowerCase();
                if (!title2.equals(pathLC = element2.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent2 = node4;
                break;
            }
            if (!categoryAlreadyExists) {
                CategoryNode newNode = new CategoryNode(element2.getTitle());
                this.insertNodeInto(newNode, parent2, parent2.getChildCount());
                this.refresh(newNode);
                parent2 = newNode;
            }
            ++i;
        }
        return parent2;
    }

    public void addLogRecord(LogRecord lr) {
        CategoryPath path2 = new CategoryPath(lr.getCategory());
        this.addCategory(path2);
        CategoryNode node4 = this.getCategoryNode(path2);
        node4.addRecord();
        if (this._renderFatal && lr.isFatal()) {
            TreeNode[] nodes2 = this.getPathToRoot(node4);
            int len2 = nodes2.length;
            int i = 1;
            while (i < len2 - 1) {
                CategoryNode parent2 = (CategoryNode)nodes2[i];
                parent2.setHasFatalChildren(true);
                this.nodeChanged(parent2);
                ++i;
            }
            node4.setHasFatalRecords(true);
            this.nodeChanged(node4);
        }
    }

    public CategoryNode getCategoryNode(String category2) {
        CategoryPath path2 = new CategoryPath(category2);
        return this.getCategoryNode(path2);
    }

    public CategoryNode getCategoryNode(CategoryPath path2) {
        CategoryNode root2;
        CategoryNode parent2 = root2 = (CategoryNode)this.getRoot();
        int i = 0;
        while (i < path2.size()) {
            CategoryElement element2 = path2.categoryElementAt(i);
            Enumeration<TreeNode> children2 = parent2.children();
            boolean categoryAlreadyExists = false;
            while (children2.hasMoreElements()) {
                String pathLC;
                CategoryNode node4 = (CategoryNode)children2.nextElement();
                String title2 = node4.getTitle().toLowerCase();
                if (!title2.equals(pathLC = element2.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent2 = node4;
                break;
            }
            if (!categoryAlreadyExists) {
                return null;
            }
            ++i;
        }
        return parent2;
    }

    public CategoryNode getRootCategoryNode() {
        return (CategoryNode)this.getRoot();
    }

    public TreePath getTreePathToRoot(CategoryNode node4) {
        if (node4 == null) {
            return null;
        }
        return new TreePath(this.getPathToRoot(node4));
    }

    public boolean isCategoryPathActive(CategoryPath path2) {
        CategoryNode root2;
        CategoryNode parent2 = root2 = (CategoryNode)this.getRoot();
        boolean active = false;
        int i = 0;
        while (i < path2.size()) {
            CategoryElement element2 = path2.categoryElementAt(i);
            Enumeration<TreeNode> children2 = parent2.children();
            boolean categoryAlreadyExists = false;
            active = false;
            while (children2.hasMoreElements()) {
                String pathLC;
                CategoryNode node4 = (CategoryNode)children2.nextElement();
                String title2 = node4.getTitle().toLowerCase();
                if (!title2.equals(pathLC = element2.getTitle().toLowerCase())) continue;
                categoryAlreadyExists = true;
                parent2 = node4;
                if (!parent2.isSelected()) break;
                active = true;
                break;
            }
            if (!active || !categoryAlreadyExists) {
                return false;
            }
            ++i;
        }
        return active;
    }

    protected void notifyActionListeners() {
        if (this._listener != null) {
            this._listener.actionPerformed(this._event);
        }
    }

    protected void refresh(final CategoryNode node4) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                this.nodeChanged(node4);
            }
        });
    }

    public synchronized void removeActionListener(ActionListener l) {
        this._listener = AWTEventMulticaster.remove(this._listener, l);
    }

    public void resetAllNodeCounts() {
        Enumeration<TreeNode> nodes2 = this.getRootCategoryNode().depthFirstEnumeration();
        while (nodes2.hasMoreElements()) {
            CategoryNode current = (CategoryNode)nodes2.nextElement();
            current.resetNumberOfContainedRecords();
            this.nodeChanged(current);
        }
    }

    public void setDescendantSelection(CategoryNode node4, boolean selected) {
        Enumeration<TreeNode> descendants = node4.depthFirstEnumeration();
        while (descendants.hasMoreElements()) {
            CategoryNode current = (CategoryNode)descendants.nextElement();
            if (current.isSelected() == selected) continue;
            current.setSelected(selected);
            this.nodeChanged(current);
        }
        this.notifyActionListeners();
    }

    public void setParentSelection(CategoryNode node4, boolean selected) {
        TreeNode[] nodes2 = this.getPathToRoot(node4);
        int len2 = nodes2.length;
        int i = 1;
        while (i < len2) {
            CategoryNode parent2 = (CategoryNode)nodes2[i];
            if (parent2.isSelected() != selected) {
                parent2.setSelected(selected);
                this.nodeChanged(parent2);
            }
            ++i;
        }
        this.notifyActionListeners();
    }

    public void update(CategoryNode node4, boolean selected) {
        if (node4.isSelected() == selected) {
            return;
        }
        if (selected) {
            this.setParentSelection(node4, true);
        } else {
            this.setDescendantSelection(node4, false);
        }
    }
}

