/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class CategoryNode
extends DefaultMutableTreeNode {
    protected boolean _selected = true;
    protected int _numberOfContainedRecords = 0;
    protected int _numberOfRecordsFromChildren = 0;
    protected boolean _hasFatalChildren = false;
    protected boolean _hasFatalRecords = false;

    public CategoryNode(String title2) {
        this.setUserObject(title2);
    }

    public void addRecord() {
        ++this._numberOfContainedRecords;
        this.addRecordToParent();
    }

    protected void addRecordFromChild() {
        ++this._numberOfRecordsFromChildren;
        this.addRecordToParent();
    }

    protected void addRecordToParent() {
        TreeNode parent2 = this.getParent();
        if (parent2 == null) {
            return;
        }
        ((CategoryNode)parent2).addRecordFromChild();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategoryNode) {
            String tit2;
            CategoryNode node4 = (CategoryNode)obj;
            String tit1 = this.getTitle().toLowerCase();
            if (tit1.equals(tit2 = node4.getTitle().toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public int getNumberOfContainedRecords() {
        return this._numberOfContainedRecords;
    }

    protected int getNumberOfRecordsFromChildren() {
        return this._numberOfRecordsFromChildren;
    }

    public String getTitle() {
        return (String)this.getUserObject();
    }

    protected int getTotalNumberOfRecords() {
        return this.getNumberOfRecordsFromChildren() + this.getNumberOfContainedRecords();
    }

    public boolean hasFatalChildren() {
        return this._hasFatalChildren;
    }

    public boolean hasFatalRecords() {
        return this._hasFatalRecords;
    }

    public int hashCode() {
        return this.getTitle().hashCode();
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void resetNumberOfContainedRecords() {
        this._numberOfContainedRecords = 0;
        this._numberOfRecordsFromChildren = 0;
        this._hasFatalRecords = false;
        this._hasFatalChildren = false;
    }

    public void setAllDescendantsDeSelected() {
        Enumeration<TreeNode> children2 = this.children();
        while (children2.hasMoreElements()) {
            CategoryNode node4 = (CategoryNode)children2.nextElement();
            node4.setSelected(false);
            node4.setAllDescendantsDeSelected();
        }
    }

    public void setAllDescendantsSelected() {
        Enumeration<TreeNode> children2 = this.children();
        while (children2.hasMoreElements()) {
            CategoryNode node4 = (CategoryNode)children2.nextElement();
            node4.setSelected(true);
            node4.setAllDescendantsSelected();
        }
    }

    public void setHasFatalChildren(boolean flag) {
        this._hasFatalChildren = flag;
    }

    public void setHasFatalRecords(boolean flag) {
        this._hasFatalRecords = flag;
    }

    public void setSelected(boolean s2) {
        if (s2 != this._selected) {
            this._selected = s2;
        }
    }

    public String toString() {
        return this.getTitle();
    }
}

