/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryAbstractCellEditor;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeEditorRenderer;

public class CategoryNodeEditor
extends CategoryAbstractCellEditor {
    protected CategoryNodeEditorRenderer _renderer = new CategoryNodeEditorRenderer();
    protected CategoryNode _lastEditedNode;
    protected JCheckBox _checkBox = this._renderer.getCheckBox();
    protected CategoryExplorerModel _categoryModel;
    protected JTree _tree;

    public CategoryNodeEditor(CategoryExplorerModel model) {
        this._categoryModel = model;
        this._checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                CategoryNodeEditor.this._categoryModel.update(CategoryNodeEditor.this._lastEditedNode, CategoryNodeEditor.this._checkBox.isSelected());
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
        this._renderer.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e2) {
                if ((e2.getModifiers() & 4) != 0) {
                    CategoryNodeEditor.this.showPopup(CategoryNodeEditor.this._lastEditedNode, e2.getX(), e2.getY());
                }
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
    }

    protected void collapse(CategoryNode node4) {
        this._tree.collapsePath(this.getTreePath(node4));
    }

    protected void collapseDescendants(CategoryNode node4) {
        Enumeration<TreeNode> descendants = node4.depthFirstEnumeration();
        while (descendants.hasMoreElements()) {
            CategoryNode current = (CategoryNode)descendants.nextElement();
            this.collapse(current);
        }
    }

    protected JMenuItem createCollapseMenuItem(final CategoryNode node4) {
        JMenuItem result2 = new JMenuItem("Collapse All Descendant Categories");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                this.collapseDescendants(node4);
            }
        });
        return result2;
    }

    protected JMenuItem createExpandMenuItem(final CategoryNode node4) {
        JMenuItem result2 = new JMenuItem("Expand All Descendant Categories");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                this.expandDescendants(node4);
            }
        });
        return result2;
    }

    protected JMenuItem createPropertiesMenuItem(final CategoryNode node4) {
        JMenuItem result2 = new JMenuItem("Properties");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                this.showPropertiesDialog(node4);
            }
        });
        return result2;
    }

    protected JMenuItem createRemoveMenuItem() {
        JMenuItem result2 = new JMenuItem("Remove All Empty Categories");
        result2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                while (CategoryNodeEditor.this.removeUnusedNodes() > 0) {
                }
            }
        });
        return result2;
    }

    protected JMenuItem createSelectDescendantsMenuItem(final CategoryNode node4) {
        JMenuItem selectDescendants = new JMenuItem("Select All Descendant Categories");
        selectDescendants.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                _categoryModel.setDescendantSelection(node4, true);
            }
        });
        return selectDescendants;
    }

    protected JMenuItem createUnselectDescendantsMenuItem(final CategoryNode node4) {
        JMenuItem unselectDescendants = new JMenuItem("Deselect All Descendant Categories");
        unselectDescendants.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                _categoryModel.setDescendantSelection(node4, false);
            }
        });
        return unselectDescendants;
    }

    protected void expand(CategoryNode node4) {
        this._tree.expandPath(this.getTreePath(node4));
    }

    protected void expandDescendants(CategoryNode node4) {
        Enumeration<TreeNode> descendants = node4.depthFirstEnumeration();
        while (descendants.hasMoreElements()) {
            CategoryNode current = (CategoryNode)descendants.nextElement();
            this.expand(current);
        }
    }

    public Object getCellEditorValue() {
        return this._lastEditedNode.getUserObject();
    }

    protected Object getDisplayedProperties(CategoryNode node4) {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add("Category: " + node4.getTitle());
        if (node4.hasFatalRecords()) {
            result2.add("Contains at least one fatal LogRecord.");
        }
        if (node4.hasFatalChildren()) {
            result2.add("Contains descendants with a fatal LogRecord.");
        }
        result2.add("LogRecords in this category alone: " + node4.getNumberOfContainedRecords());
        result2.add("LogRecords in descendant categories: " + node4.getNumberOfRecordsFromChildren());
        result2.add("LogRecords in this category including descendants: " + node4.getTotalNumberOfRecords());
        return result2.toArray();
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf2, int row2) {
        this._lastEditedNode = (CategoryNode)value2;
        this._tree = tree;
        return this._renderer.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf2, row2, true);
    }

    protected TreePath getTreePath(CategoryNode node4) {
        return new TreePath(node4.getPath());
    }

    protected int removeUnusedNodes() {
        int count2 = 0;
        CategoryNode root2 = this._categoryModel.getRootCategoryNode();
        Enumeration<TreeNode> enumeration = root2.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode node4 = (CategoryNode)enumeration.nextElement();
            if (!node4.isLeaf() || node4.getNumberOfContainedRecords() != 0 || node4.getParent() == null) continue;
            this._categoryModel.removeNodeFromParent(node4);
            ++count2;
        }
        return count2;
    }

    protected void showPopup(CategoryNode node4, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        popup.setSize(150, 400);
        if (node4.getParent() == null) {
            popup.add(this.createRemoveMenuItem());
            popup.addSeparator();
        }
        popup.add(this.createSelectDescendantsMenuItem(node4));
        popup.add(this.createUnselectDescendantsMenuItem(node4));
        popup.addSeparator();
        popup.add(this.createExpandMenuItem(node4));
        popup.add(this.createCollapseMenuItem(node4));
        popup.addSeparator();
        popup.add(this.createPropertiesMenuItem(node4));
        popup.show(this._renderer, x, y);
    }

    protected void showPropertiesDialog(CategoryNode node4) {
        JOptionPane.showMessageDialog(this._tree, this.getDisplayedProperties(node4), "Category Properties: " + node4.getTitle(), -1);
    }
}

