/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;

public class CategoryNodeRenderer
extends DefaultTreeCellRenderer {
    public static final Color FATAL_CHILDREN = new Color(189, 113, 0);
    protected JCheckBox _checkBox = new JCheckBox();
    protected JPanel _panel = new JPanel();
    protected static ImageIcon _sat = null;

    public CategoryNodeRenderer() {
        this._panel.setBackground(UIManager.getColor("Tree.textBackground"));
        if (_sat == null) {
            String resource = "/org/apache/log4j/lf5/viewer/images/channelexplorer_satellite.gif";
            URL satURL = this.getClass().getResource(resource);
            _sat = new ImageIcon(satURL);
        }
        this.setOpaque(false);
        this._checkBox.setOpaque(false);
        this._panel.setOpaque(false);
        this._panel.setLayout(new FlowLayout(0, 0, 0));
        this._panel.add(this._checkBox);
        this._panel.add(this);
        this.setOpenIcon(_sat);
        this.setClosedIcon(_sat);
        this.setLeafIcon(_sat);
    }

    protected String buildToolTip(CategoryNode node4) {
        StringBuffer result2 = new StringBuffer();
        result2.append(node4.getTitle()).append(" contains a total of ");
        result2.append(node4.getTotalNumberOfRecords());
        result2.append(" LogRecords.");
        result2.append(" Right-click for more info.");
        return result2.toString();
    }

    public Dimension getCheckBoxOffset() {
        return new Dimension(0, 0);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf2, int row2, boolean hasFocus) {
        CategoryNode node4 = (CategoryNode)value2;
        super.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf2, row2, hasFocus);
        if (row2 == 0) {
            this._checkBox.setVisible(false);
        } else {
            this._checkBox.setVisible(true);
            this._checkBox.setSelected(node4.isSelected());
        }
        String toolTip = this.buildToolTip(node4);
        this._panel.setToolTipText(toolTip);
        if (node4.hasFatalChildren()) {
            this.setForeground(FATAL_CHILDREN);
        }
        if (node4.hasFatalRecords()) {
            this.setForeground(Color.red);
        }
        return this._panel;
    }
}

