/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.configure;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

public class MRUFileManager {
    private static final String CONFIG_FILE_NAME = "mru_file_manager";
    private static final int DEFAULT_MAX_SIZE = 3;
    private int _maxSize = 0;
    private LinkedList _mruFileList;

    public MRUFileManager() {
        this.load();
        this.setMaxSize(3);
    }

    public MRUFileManager(int maxSize) {
        this.load();
        this.setMaxSize(maxSize);
    }

    public static void createConfigurationDirectory() {
        block2: {
            String home = System.getProperty("user.home");
            String sep = System.getProperty("file.separator");
            File f2 = new File(String.valueOf(home) + sep + "lf5");
            if (f2.exists()) break block2;
            try {
                f2.mkdir();
            }
            catch (SecurityException e2) {
                e2.printStackTrace();
            }
        }
    }

    public Object getFile(int index2) {
        if (index2 < this.size()) {
            return this._mruFileList.get(index2);
        }
        return null;
    }

    protected String getFilename() {
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        return String.valueOf(home) + sep + "lf5" + sep + CONFIG_FILE_NAME;
    }

    public InputStream getInputStream(int index2) throws IOException, FileNotFoundException {
        if (index2 < this.size()) {
            Object o = this.getFile(index2);
            if (o instanceof File) {
                return this.getInputStream((File)o);
            }
            return this.getInputStream((URL)o);
        }
        return null;
    }

    protected InputStream getInputStream(File file) throws IOException, FileNotFoundException {
        BufferedInputStream reader2 = new BufferedInputStream(new FileInputStream(file));
        return reader2;
    }

    protected InputStream getInputStream(URL url) throws IOException {
        return url.openStream();
    }

    public String[] getMRUFileList() {
        if (this.size() == 0) {
            return null;
        }
        String[] ss = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            Object o = this.getFile(i);
            ss[i] = o instanceof File ? ((File)o).getAbsolutePath() : o.toString();
            ++i;
        }
        return ss;
    }

    protected void load() {
        MRUFileManager.createConfigurationDirectory();
        File file = new File(this.getFilename());
        if (file.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                this._mruFileList = (LinkedList)ois.readObject();
                ois.close();
                Iterator it = this._mruFileList.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (o instanceof File || o instanceof URL) continue;
                    it.remove();
                }
            }
            catch (Exception exception) {
                this._mruFileList = new LinkedList();
            }
        } else {
            this._mruFileList = new LinkedList();
        }
    }

    public void moveToTop(int index2) {
        this._mruFileList.add(0, this._mruFileList.remove(index2));
    }

    public void save() {
        File file = new File(this.getFilename());
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(this._mruFileList);
            oos.flush();
            oos.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void set(File file) {
        this.setMRU(file);
    }

    public void set(URL url) {
        this.setMRU(url);
    }

    protected void setMRU(Object o) {
        int index2 = this._mruFileList.indexOf(o);
        if (index2 == -1) {
            this._mruFileList.add(0, o);
            this.setMaxSize(this._maxSize);
        } else {
            this.moveToTop(index2);
        }
    }

    protected void setMaxSize(int maxSize) {
        if (maxSize < this._mruFileList.size()) {
            int i = 0;
            while (i < this._mruFileList.size() - maxSize) {
                this._mruFileList.removeLast();
                ++i;
            }
        }
        this._maxSize = maxSize;
    }

    public int size() {
        return this._mruFileList.size();
    }
}

