/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class JMSAppender
extends AppenderSkeleton {
    String securityPrincipalName;
    String securityCredentials;
    String initialContextFactoryName;
    String urlPkgPrefixes;
    String providerURL;
    String topicBindingName;
    String tcfBindingName;
    String userName;
    String password;
    boolean locationInfo;
    TopicConnection topicConnection;
    TopicSession topicSession;
    TopicPublisher topicPublisher;

    public void activateOptions() {
        try {
            InitialContext initialContext;
            Properties properties2;
            LogLog.debug("Getting initial context.");
            if (this.initialContextFactoryName != null) {
                properties2 = new Properties();
                ((Hashtable)properties2).put("java.naming.factory.initial", this.initialContextFactoryName);
                if (this.providerURL != null) {
                    ((Hashtable)properties2).put("java.naming.provider.url", this.providerURL);
                } else {
                    LogLog.warn("You have set InitialContextFactoryName option but not the ProviderURL. This is likely to cause problems.");
                }
                if (this.urlPkgPrefixes != null) {
                    ((Hashtable)properties2).put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
                }
                if (this.securityPrincipalName != null) {
                    ((Hashtable)properties2).put("java.naming.security.principal", this.securityPrincipalName);
                    if (this.securityCredentials != null) {
                        ((Hashtable)properties2).put("java.naming.security.credentials", this.securityCredentials);
                    } else {
                        LogLog.warn("You have set SecurityPrincipalName option but not the SecurityCredentials. This is likely to cause problems.");
                    }
                }
                initialContext = new InitialContext(properties2);
            } else {
                initialContext = new InitialContext();
            }
            LogLog.debug("Looking up [" + this.tcfBindingName + "]");
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.lookup(initialContext, this.tcfBindingName);
            LogLog.debug("About to create TopicConnection.");
            this.topicConnection = this.userName != null ? topicConnectionFactory.createTopicConnection(this.userName, this.password) : topicConnectionFactory.createTopicConnection();
            LogLog.debug("Creating TopicSession, non-transactional, in AUTO_ACKNOWLEDGE mode.");
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            LogLog.debug("Looking up topic name [" + this.topicBindingName + "].");
            properties2 = (Topic)this.lookup(initialContext, this.topicBindingName);
            LogLog.debug("Creating TopicPublisher.");
            this.topicPublisher = this.topicSession.createPublisher((Topic)properties2);
            LogLog.debug("Starting TopicConnection.");
            this.topicConnection.start();
            initialContext.close();
        }
        catch (Exception exception) {
            this.errorHandler.error("Error while activating options for appender named [" + this.name + "].", exception, 0);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        try {
            ObjectMessage objectMessage = this.topicSession.createObjectMessage();
            if (this.locationInfo) {
                loggingEvent.getLocationInformation();
            }
            objectMessage.setObject((Serializable)loggingEvent);
            this.topicPublisher.publish((Message)objectMessage);
        }
        catch (Exception exception) {
            this.errorHandler.error("Could not publish message in JMSAppender [" + this.name + "].", exception, 0);
        }
    }

    protected boolean checkEntryConditions() {
        String string2 = null;
        if (this.topicConnection == null) {
            string2 = "No TopicConnection";
        } else if (this.topicSession == null) {
            string2 = "No TopicSession";
        } else if (this.topicPublisher == null) {
            string2 = "No TopicPublisher";
        }
        if (string2 != null) {
            this.errorHandler.error(String.valueOf(string2) + " for JMSAppender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("Closing appender [" + this.name + "].");
        this.closed = true;
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (Exception exception) {
            LogLog.error("Error while closing JMSAppender [" + this.name + "].", exception);
        }
        this.topicPublisher = null;
        this.topicSession = null;
        this.topicConnection = null;
    }

    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public String getSecurityPrincipalName() {
        return this.securityPrincipalName;
    }

    public String getTopicBindingName() {
        return this.topicBindingName;
    }

    protected TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    public String getTopicConnectionFactoryBindingName() {
        return this.tcfBindingName;
    }

    protected TopicPublisher getTopicPublisher() {
        return this.topicPublisher;
    }

    protected TopicSession getTopicSession() {
        return this.topicSession;
    }

    String getURLPkgPrefixes() {
        return this.urlPkgPrefixes;
    }

    public String getUserName() {
        return this.userName;
    }

    protected Object lookup(Context context, String string2) throws NamingException {
        try {
            return context.lookup(string2);
        }
        catch (NameNotFoundException nameNotFoundException) {
            LogLog.error("Could not find name [" + string2 + "].");
            throw nameNotFoundException;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setInitialContextFactoryName(String string2) {
        this.initialContextFactoryName = string2;
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public void setPassword(String string2) {
        this.password = string2;
    }

    public void setProviderURL(String string2) {
        this.providerURL = string2;
    }

    public void setSecurityCredentials(String string2) {
        this.securityCredentials = string2;
    }

    public void setSecurityPrincipalName(String string2) {
        this.securityPrincipalName = string2;
    }

    public void setTopicBindingName(String string2) {
        this.topicBindingName = string2;
    }

    public void setTopicConnectionFactoryBindingName(String string2) {
        this.tcfBindingName = string2;
    }

    public void setURLPkgPrefixes(String string2) {
        this.urlPkgPrefixes = string2;
    }

    public void setUserName(String string2) {
        this.userName = string2;
    }
}

