/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nt;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private int _handle = 0;
    private String source = null;
    private String server = null;
    private static final int FATAL = Level.FATAL.toInt();
    private static final int ERROR = Level.ERROR.toInt();
    private static final int WARN = Level.WARN.toInt();
    private static final int INFO = Level.INFO.toInt();
    private static final int DEBUG = Level.DEBUG.toInt();

    static {
        System.loadLibrary("NTEventLogAppender");
    }

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String source) {
        this(null, source, null);
    }

    public NTEventLogAppender(String server, String source) {
        this(server, source, null);
    }

    public NTEventLogAppender(String server, String source, Layout layout) {
        if (source == null) {
            source = "Log4j";
        }
        this.layout = layout == null ? new TTCCLayout() : layout;
        try {
            this._handle = this.registerEventSource(server, source);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this._handle = 0;
        }
    }

    public NTEventLogAppender(String source, Layout layout) {
        this(null, source, layout);
    }

    public NTEventLogAppender(Layout layout) {
        this(null, null, layout);
    }

    public void activateOptions() {
        block2: {
            if (this.source == null) break block2;
            try {
                this._handle = this.registerEventSource(this.server, this.source);
            }
            catch (Exception e2) {
                LogLog.error("Could not register event source.", e2);
                this._handle = 0;
            }
        }
    }

    public void append(LoggingEvent event) {
        String[] s2;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s2 = event.getThrowableStrRep()) != null) {
            int len2 = s2.length;
            int i = 0;
            while (i < len2) {
                sbuf.append(s2[i]);
                ++i;
            }
        }
        int nt_category = event.getLevel().toInt();
        this.reportEvent(this._handle, sbuf.toString(), nt_category);
    }

    public void close() {
    }

    private native void deregisterEventSource(int var1);

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public String getSource() {
        return this.source;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    public boolean requiresLayout() {
        return true;
    }

    public void setSource(String source) {
        this.source = source.trim();
    }
}

