/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String LOGGER = "logger";
    static final String LOGGER_REF = "logger-ref";
    static final String CATEGORY_FACTORY_TAG = "categoryFactory";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String ROOT_REF = "root-ref";
    static final String LEVEL_TAG = "level";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String THRESHOLD_ATTR = "threshold";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DOMConfigurator.class$("java.lang.String"))};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void configure(String filename) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(filename, LogManager.getLoggerRepository());
    }

    public static void configure(URL url) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(url, LogManager.getLoggerRepository());
    }

    public static void configure(Element element2) {
        DOMConfigurator configurator = new DOMConfigurator();
        configurator.doConfigure(element2, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String configFilename) {
        DOMConfigurator.configureAndWatch(configFilename, 60000L);
    }

    public static void configureAndWatch(String configFilename, long delay) {
        XMLWatchdog xdog = new XMLWatchdog(configFilename);
        xdog.setDelay(delay);
        xdog.start();
    }

    public void doConfigure(final InputStream inputStream, LoggerRepository repository) throws FactoryConfigurationError {
        ParseAction action2 = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId("dummy://log4j.dtd");
                return parser.parse(inputSource);
            }

            public String toString() {
                return "input stream [" + inputStream.toString() + "]";
            }
        };
        this.doConfigure(action2, repository);
    }

    public void doConfigure(final Reader reader2, LoggerRepository repository) throws FactoryConfigurationError {
        ParseAction action2 = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                InputSource inputSource = new InputSource(reader2);
                inputSource.setSystemId("dummy://log4j.dtd");
                return parser.parse(inputSource);
            }

            public String toString() {
                return "reader [" + reader2.toString() + "]";
            }
        };
        this.doConfigure(action2, repository);
    }

    public void doConfigure(final String filename, LoggerRepository repository) {
        ParseAction action2 = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(new File(filename));
            }

            public String toString() {
                return "file [" + filename + "]";
            }
        };
        this.doConfigure(action2, repository);
    }

    public void doConfigure(final URL url, LoggerRepository repository) {
        ParseAction action2 = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(url.toString());
            }

            public String toString() {
                return "url [" + url.toString() + "]";
            }
        };
        this.doConfigure(action2, repository);
    }

    private final void doConfigure(ParseAction action2, LoggerRepository repository) throws FactoryConfigurationError {
        DocumentBuilderFactory dbf = null;
        this.repository = repository;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty(dbfKey, null));
            dbf = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + dbf.getClass().getName());
        }
        catch (FactoryConfigurationError fce) {
            Exception e2 = fce.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", e2);
            throw fce;
        }
        try {
            dbf.setValidating(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            docBuilder.setErrorHandler(new SAXErrorHandler());
            docBuilder.setEntityResolver(new Log4jEntityResolver());
            Document doc = action2.parse(docBuilder);
            this.parse(doc.getDocumentElement());
        }
        catch (Exception e3) {
            LogLog.error("Could not parse " + action2.toString() + ".", e3);
        }
    }

    public void doConfigure(Element element2, LoggerRepository repository) {
        this.repository = repository;
        this.parse(element2);
    }

    protected void doConfigure(final InputSource inputSource, LoggerRepository repository) throws FactoryConfigurationError {
        if (inputSource.getSystemId() == null) {
            inputSource.setSystemId("dummy://log4j.dtd");
        }
        ParseAction action2 = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(inputSource);
            }

            public String toString() {
                return "input source [" + inputSource.toString() + "]";
            }
        };
        this.doConfigure(action2, repository);
    }

    protected Appender findAppenderByName(Document doc, String appenderName) {
        Appender appender = (Appender)this.appenderBag.get(appenderName);
        if (appender != null) {
            return appender;
        }
        Element element2 = null;
        NodeList list2 = doc.getElementsByTagName(APPENDER_TAG);
        int t2 = 0;
        while (t2 < list2.getLength()) {
            Node node4 = list2.item(t2);
            NamedNodeMap map3 = node4.getAttributes();
            Node attrNode = map3.getNamedItem(NAME_ATTR);
            if (appenderName.equals(attrNode.getNodeValue())) {
                element2 = (Element)node4;
                break;
            }
            ++t2;
        }
        if (element2 == null) {
            LogLog.error("No appender named [" + appenderName + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element2);
        this.appenderBag.put(appenderName, appender);
        return appender;
    }

    protected Appender findAppenderByReference(Element appenderRef) {
        String appenderName = this.subst(appenderRef.getAttribute(REF_ATTR));
        Document doc = appenderRef.getOwnerDocument();
        return this.findAppenderByName(doc, appenderName);
    }

    protected void parse(Element element2) {
        String rootElementName = element2.getTagName();
        if (!rootElementName.equals(CONFIGURATION_TAG)) {
            if (rootElementName.equals(OLD_CONFIGURATION_TAG)) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String debugAttrib = this.subst(element2.getAttribute(INTERNAL_DEBUG_ATTR));
        LogLog.debug("debug attribute= \"" + debugAttrib + "\".");
        if (!debugAttrib.equals(EMPTY_STR) && !debugAttrib.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(debugAttrib, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String confDebug = this.subst(element2.getAttribute(CONFIG_DEBUG_ATTR));
        if (!confDebug.equals(EMPTY_STR) && !confDebug.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(confDebug, true));
        }
        String thresholdStr = this.subst(element2.getAttribute(THRESHOLD_ATTR));
        LogLog.debug("Threshold =\"" + thresholdStr + "\".");
        if (!EMPTY_STR.equals(thresholdStr) && !"null".equals(thresholdStr)) {
            this.repository.setThreshold(thresholdStr);
        }
        String tagName = null;
        Element currentElement = null;
        Node currentNode = null;
        NodeList children2 = element2.getChildNodes();
        int length2 = children2.getLength();
        int loop2 = 0;
        while (loop2 < length2) {
            currentNode = children2.item(loop2);
            if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals(CATEGORY_FACTORY_TAG)) {
                this.parseCategoryFactory(currentElement);
            }
            ++loop2;
        }
        int loop3 = 0;
        while (loop3 < length2) {
            currentNode = children2.item(loop3);
            if (currentNode.getNodeType() == 1) {
                currentElement = (Element)currentNode;
                tagName = currentElement.getTagName();
                if (tagName.equals(CATEGORY) || tagName.equals(LOGGER)) {
                    this.parseCategory(currentElement);
                } else if (tagName.equals(ROOT_TAG)) {
                    this.parseRoot(currentElement);
                } else if (tagName.equals(RENDERER_TAG)) {
                    this.parseRenderer(currentElement);
                }
            }
            ++loop3;
        }
    }

    protected Appender parseAppender(Element appenderElement) {
        String className = this.subst(appenderElement.getAttribute(CLASS_ATTR));
        LogLog.debug("Class name: [" + className + ']');
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Appender appender = (Appender)instance;
            PropertySetter propSetter = new PropertySetter(appender);
            appender.setName(this.subst(appenderElement.getAttribute(NAME_ATTR)));
            NodeList children2 = appenderElement.getChildNodes();
            int length2 = children2.getLength();
            int loop2 = 0;
            while (loop2 < length2) {
                Node currentNode = children2.item(loop2);
                if (currentNode.getNodeType() == 1) {
                    Element currentElement = (Element)currentNode;
                    if (currentElement.getTagName().equals(PARAM_TAG)) {
                        this.setParameter(currentElement, propSetter);
                    } else if (currentElement.getTagName().equals(LAYOUT_TAG)) {
                        appender.setLayout(this.parseLayout(currentElement));
                    } else if (currentElement.getTagName().equals(FILTER_TAG)) {
                        this.parseFilters(currentElement, appender);
                    } else if (currentElement.getTagName().equals(ERROR_HANDLER_TAG)) {
                        this.parseErrorHandler(currentElement, appender);
                    } else if (currentElement.getTagName().equals(APPENDER_REF_TAG)) {
                        String refName = this.subst(currentElement.getAttribute(REF_ATTR));
                        if (appender instanceof AppenderAttachable) {
                            AppenderAttachable aa = (AppenderAttachable)((Object)appender);
                            LogLog.debug("Attaching appender named [" + refName + "] to appender named [" + appender.getName() + "].");
                            aa.addAppender(this.findAppenderByReference(currentElement));
                        } else {
                            LogLog.error("Requesting attachment of appender named [" + refName + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                        }
                    }
                }
                ++loop2;
            }
            propSetter.activate();
            return appender;
        }
        catch (Exception oops) {
            LogLog.error("Could not create an Appender. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseCategory(Element loggerElement) {
        Logger cat2;
        String catName = this.subst(loggerElement.getAttribute(NAME_ATTR));
        String className = this.subst(loggerElement.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(className)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Logger.");
            cat2 = this.repository.getLogger(catName);
        } else {
            LogLog.debug("Desired logger sub-class: [" + className + ']');
            try {
                Class clazz2 = Loader.loadClass(className);
                Method getInstanceMethod = clazz2.getMethod("getLogger", ONE_STRING_PARAM);
                cat2 = (Logger)getInstanceMethod.invoke(null, catName);
            }
            catch (Exception oops) {
                LogLog.error("Could not retrieve category [" + catName + "]. Reported error follows.", oops);
                return;
            }
        }
        Logger oops = cat2;
        synchronized (oops) {
            boolean additivity = OptionConverter.toBoolean(this.subst(loggerElement.getAttribute(ADDITIVITY_ATTR)), true);
            LogLog.debug("Setting [" + cat2.getName() + "] additivity to [" + additivity + "].");
            cat2.setAdditivity(additivity);
            this.parseChildrenOfLoggerElement(loggerElement, cat2, false);
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    protected void parseCategoryFactory(Element factoryElement) {
        String className = this.subst(factoryElement.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(className)) {
            LogLog.error("Category Factory tag class attribute not found.");
            LogLog.debug("No Category Factory configured.");
        } else {
            LogLog.debug("Desired category factory: [" + className + ']');
            Object catFactory = OptionConverter.instantiateByClassName(className, class$org$apache$log4j$spi$LoggerFactory != null ? class$org$apache$log4j$spi$LoggerFactory : (class$org$apache$log4j$spi$LoggerFactory = DOMConfigurator.class$("org.apache.log4j.spi.LoggerFactory")), null);
            PropertySetter propSetter = new PropertySetter(catFactory);
            Element currentElement = null;
            Node currentNode = null;
            NodeList children2 = factoryElement.getChildNodes();
            int length2 = children2.getLength();
            int loop2 = 0;
            while (loop2 < length2) {
                currentNode = children2.item(loop2);
                if (currentNode.getNodeType() == 1 && (currentElement = (Element)currentNode).getTagName().equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop2;
            }
        }
    }

    protected void parseChildrenOfLoggerElement(Element catElement, Logger cat2, boolean isRoot) {
        PropertySetter propSetter = new PropertySetter(cat2);
        cat2.removeAllAppenders();
        NodeList children2 = catElement.getChildNodes();
        int length2 = children2.getLength();
        int loop2 = 0;
        while (loop2 < length2) {
            Node currentNode = children2.item(loop2);
            if (currentNode.getNodeType() == 1) {
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals(APPENDER_REF_TAG)) {
                    Element appenderRef = (Element)currentNode;
                    Appender appender = this.findAppenderByReference(appenderRef);
                    String refName = this.subst(appenderRef.getAttribute(REF_ATTR));
                    if (appender != null) {
                        LogLog.debug("Adding appender named [" + refName + "] to category [" + cat2.getName() + "].");
                    } else {
                        LogLog.debug("Appender named [" + refName + "] not found.");
                    }
                    cat2.addAppender(appender);
                } else if (tagName.equals(LEVEL_TAG)) {
                    this.parseLevel(currentElement, cat2, isRoot);
                } else if (tagName.equals(PRIORITY_TAG)) {
                    this.parseLevel(currentElement, cat2, isRoot);
                } else if (tagName.equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
            }
            ++loop2;
        }
        propSetter.activate();
    }

    protected void parseErrorHandler(Element element2, Appender appender) {
        ErrorHandler eh = (ErrorHandler)OptionConverter.instantiateByClassName(this.subst(element2.getAttribute(CLASS_ATTR)), class$org$apache$log4j$spi$ErrorHandler != null ? class$org$apache$log4j$spi$ErrorHandler : (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.apache.log4j.spi.ErrorHandler")), null);
        if (eh != null) {
            eh.setAppender(appender);
            PropertySetter propSetter = new PropertySetter(eh);
            NodeList children2 = element2.getChildNodes();
            int length2 = children2.getLength();
            int loop2 = 0;
            while (loop2 < length2) {
                Node currentNode = children2.item(loop2);
                if (currentNode.getNodeType() == 1) {
                    Element currentElement = (Element)currentNode;
                    String tagName = currentElement.getTagName();
                    if (tagName.equals(PARAM_TAG)) {
                        this.setParameter(currentElement, propSetter);
                    } else if (tagName.equals(APPENDER_REF_TAG)) {
                        eh.setBackupAppender(this.findAppenderByReference(currentElement));
                    } else if (tagName.equals(LOGGER_REF)) {
                        String loggerName = currentElement.getAttribute(REF_ATTR);
                        Logger logger = this.repository.getLogger(loggerName);
                        eh.setLogger(logger);
                    } else if (tagName.equals(ROOT_REF)) {
                        Logger root2 = this.repository.getRootLogger();
                        eh.setLogger(root2);
                    }
                }
                ++loop2;
            }
            propSetter.activate();
            appender.setErrorHandler(eh);
        }
    }

    protected void parseFilters(Element element2, Appender appender) {
        String clazz2 = this.subst(element2.getAttribute(CLASS_ATTR));
        Filter filter2 = (Filter)OptionConverter.instantiateByClassName(clazz2, class$org$apache$log4j$spi$Filter != null ? class$org$apache$log4j$spi$Filter : (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.apache.log4j.spi.Filter")), null);
        if (filter2 != null) {
            PropertySetter propSetter = new PropertySetter(filter2);
            NodeList children2 = element2.getChildNodes();
            int length2 = children2.getLength();
            int loop2 = 0;
            while (loop2 < length2) {
                Element currentElement;
                String tagName;
                Node currentNode = children2.item(loop2);
                if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop2;
            }
            propSetter.activate();
            LogLog.debug("Adding filter of type [" + filter2.getClass() + "] to appender named [" + appender.getName() + "].");
            appender.addFilter(filter2);
        }
    }

    protected Layout parseLayout(Element layout_element) {
        String className = this.subst(layout_element.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing layout of class: \"" + className + "\"");
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Layout layout = (Layout)instance;
            PropertySetter propSetter = new PropertySetter(layout);
            NodeList params2 = layout_element.getChildNodes();
            int length2 = params2.getLength();
            int loop2 = 0;
            while (loop2 < length2) {
                Element currentElement;
                String tagName;
                Node currentNode = params2.item(loop2);
                if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop2;
            }
            propSetter.activate();
            return layout;
        }
        catch (Exception oops) {
            LogLog.error("Could not create the Layout. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseLevel(Element element2, Logger logger, boolean isRoot) {
        String catName = logger.getName();
        if (isRoot) {
            catName = ROOT_TAG;
        }
        String priStr = this.subst(element2.getAttribute(VALUE_ATTR));
        LogLog.debug("Level value for " + catName + " is  [" + priStr + "].");
        if ("inherited".equalsIgnoreCase(priStr) || "null".equalsIgnoreCase(priStr)) {
            if (isRoot) {
                LogLog.error("Root level cannot be inherited. Ignoring directive.");
            } else {
                logger.setLevel(null);
            }
        } else {
            String className = this.subst(element2.getAttribute(CLASS_ATTR));
            if (EMPTY_STR.equals(className)) {
                logger.setLevel(OptionConverter.toLevel(priStr, Level.DEBUG));
            } else {
                LogLog.debug("Desired Level sub-class: [" + className + ']');
                try {
                    Class clazz2 = Loader.loadClass(className);
                    Method toLevelMethod = clazz2.getMethod("toLevel", ONE_STRING_PARAM);
                    Level pri = (Level)toLevelMethod.invoke(null, priStr);
                    logger.setLevel(pri);
                }
                catch (Exception oops) {
                    LogLog.error("Could not create level [" + priStr + "]. Reported error follows.", oops);
                    return;
                }
            }
        }
        LogLog.debug(String.valueOf(catName) + " level set to " + logger.getLevel());
    }

    protected void parseRenderer(Element element2) {
        String renderingClass = this.subst(element2.getAttribute(RENDERING_CLASS_ATTR));
        String renderedClass = this.subst(element2.getAttribute(RENDERED_CLASS_ATTR));
        if (this.repository instanceof RendererSupport) {
            RendererMap.addRenderer((RendererSupport)((Object)this.repository), renderedClass, renderingClass);
        }
    }

    protected void parseRoot(Element rootElement) {
        Logger root2;
        Logger logger = root2 = this.repository.getRootLogger();
        synchronized (logger) {
            this.parseChildrenOfLoggerElement(rootElement, root2, true);
        }
    }

    protected void setParameter(Element elem2, PropertySetter propSetter) {
        String name = this.subst(elem2.getAttribute(NAME_ATTR));
        String value2 = elem2.getAttribute(VALUE_ATTR);
        value2 = this.subst(OptionConverter.convertSpecialChars(value2));
        propSetter.setProperty(name, value2);
    }

    protected String subst(String value2) {
        try {
            return OptionConverter.substVars(value2, this.props);
        }
        catch (IllegalArgumentException e2) {
            LogLog.warn("Could not perform variable substitution.", e2);
            return value2;
        }
    }

    private static interface ParseAction {
        public Document parse(DocumentBuilder var1) throws SAXException, IOException;
    }
}

