/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi;

import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.PolicyBuilder;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.neethi.builders.converters.ConverterRegistry;
import org.apache.neethi.builders.xml.XMLPrimitiveAssertionBuilder;
import org.apache.neethi.util.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionBuilderFactoryImpl
implements AssertionBuilderFactory {
    private Map<QName, AssertionBuilder<?>> registeredBuilders = new ConcurrentHashMap();
    protected AssertionBuilder defaultBuilder;
    protected ConverterRegistry converters = new ConverterRegistry();
    protected PolicyBuilder engine;

    public AssertionBuilderFactoryImpl(PolicyBuilder eng) {
        this.engine = eng;
        for (AssertionBuilder builder : Service.providers(AssertionBuilder.class)) {
            QName[] knownElements = builder.getKnownElements();
            for (int i = 0; i < knownElements.length; ++i) {
                this.registeredBuilders.put(knownElements[i], builder);
            }
        }
        this.defaultBuilder = new XMLPrimitiveAssertionBuilder();
    }

    @Override
    public ConverterRegistry getConverterRegistry() {
        return this.converters;
    }

    @Override
    public PolicyBuilder getPolicyEngine() {
        return this.engine;
    }

    protected void loadDynamic() {
    }

    @Override
    public void registerBuilder(QName key, AssertionBuilder<?> builder) {
        this.loadDynamic();
        this.registeredBuilders.put(key, builder);
    }

    @Override
    public void registerBuilder(AssertionBuilder<?> builder) {
        this.loadDynamic();
        for (QName q : builder.getKnownElements()) {
            this.registeredBuilders.put(q, builder);
        }
    }

    @Override
    public Assertion build(Object element2) {
        this.loadDynamic();
        QName qname = this.converters.findQName(element2);
        AssertionBuilder builder = this.registeredBuilders.get(qname);
        if (builder == null) {
            builder = this.handleNoRegisteredBuilder(qname);
        }
        return this.invokeBuilder(element2, builder);
    }

    protected AssertionBuilder handleNoRegisteredBuilder(QName qname) {
        return this.defaultBuilder;
    }

    private Assertion invokeBuilder(Object element2, AssertionBuilder builder) {
        Class<?> type = this.findAssertionBuilderTarget(builder.getClass());
        return builder.build(this.converters.convert(element2, type), this);
    }

    private Class<?> findAssertionBuilderTarget(Class<?> c2) {
        Class<?>[] interfaces2 = c2.getInterfaces();
        for (int x = 0; x < interfaces2.length; ++x) {
            if (interfaces2[x] != AssertionBuilder.class) continue;
            ParameterizedType pt = (ParameterizedType)c2.getGenericInterfaces()[x];
            return (Class)pt.getActualTypeArguments()[0];
        }
        if (c2.getClass().getSuperclass() != null) {
            return this.findAssertionBuilderTarget(c2.getSuperclass());
        }
        return null;
    }

    @Override
    public AssertionBuilder<?> getBuilder(QName qname) {
        this.loadDynamic();
        return this.registeredBuilders.get(qname);
    }
}

