/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.neethi.All;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.AssertionBuilderFactoryImpl;
import org.apache.neethi.Constants;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

public class PolicyBuilder {
    protected AssertionBuilderFactory factory = new AssertionBuilderFactoryImpl(this);
    protected PolicyRegistry defaultPolicyRegistry;

    public PolicyBuilder() {
        this.factory = new AssertionBuilderFactoryImpl(this);
    }

    public PolicyBuilder(AssertionBuilderFactory factory) {
        this.factory = factory;
    }

    public void registerBuilder(QName qname, AssertionBuilder builder) {
        this.factory.registerBuilder(qname, builder);
    }

    public PolicyRegistry getPolicyRegistry() {
        return this.defaultPolicyRegistry;
    }

    public void setPolicyRegistry(PolicyRegistry reg) {
        this.defaultPolicyRegistry = reg;
    }

    public AssertionBuilderFactory getAssertionBuilderFactory() {
        return this.factory;
    }

    public Policy getPolicy(InputStream inputStream) {
        try {
            XMLStreamReader reader2 = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            return this.getPolicy(reader2);
        }
        catch (RuntimeException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new RuntimeException("Could not load policy.", ex3);
        }
    }

    public Policy getPolicy(Element el) {
        return this.getPolicyOperator(el);
    }

    public Policy getPolicy(XMLStreamReader reader2) {
        return this.getPolicyOperator(reader2);
    }

    public Policy getPolicy(Object element2) {
        return this.getPolicyOperator(element2);
    }

    public PolicyReference getPolicyReference(InputStream inputStream) {
        try {
            XMLStreamReader reader2 = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            return this.getPolicyReference(reader2);
        }
        catch (RuntimeException ex2) {
            throw ex2;
        }
        catch (Exception ex3) {
            throw new RuntimeException("Could not load policy reference.", ex3);
        }
    }

    public PolicyReference getPolicyReference(Object element2) {
        QName qn = this.factory.getConverterRegistry().findQName(element2);
        if (!Constants.isPolicyRef(qn)) {
            throw new RuntimeException("Specified element is not a <wsp:PolicyReference .. />  element");
        }
        PolicyReference reference = new PolicyReference(this);
        Map<QName, String> attributes2 = this.factory.getConverterRegistry().getAttributes(element2);
        reference.setURI(attributes2.get(new QName("URI")));
        return reference;
    }

    private Policy getPolicyOperator(Object element2) {
        String ns = this.factory.getConverterRegistry().findQName(element2).getNamespaceURI();
        return (Policy)this.processOperationElement(element2, new Policy(this.defaultPolicyRegistry, ns));
    }

    private ExactlyOne getExactlyOneOperator(Object element2) {
        return (ExactlyOne)this.processOperationElement(element2, new ExactlyOne());
    }

    private All getAllOperator(Object element2) {
        return (All)this.processOperationElement(element2, new All());
    }

    private PolicyOperator processOperationElement(Object operationElement, PolicyOperator operator) {
        if (1 == operator.getType()) {
            Policy policyOperator = (Policy)operator;
            Map<QName, String> attributes2 = this.factory.getConverterRegistry().getAttributes(operationElement);
            for (Map.Entry<QName, String> ent : attributes2.entrySet()) {
                policyOperator.addAttribute(ent.getKey(), ent.getValue());
            }
        }
        Iterator<Object> iterator2 = this.factory.getConverterRegistry().getChildElements(operationElement);
        while (iterator2.hasNext()) {
            Object childElement = iterator2.next();
            QName qn = this.factory.getConverterRegistry().findQName(childElement);
            if (childElement == null || qn == null || qn.getNamespaceURI() == null) {
                this.notifyUnknownPolicyElement(childElement);
                continue;
            }
            if (Constants.isInPolicyNS(qn)) {
                if ("Policy".equals(qn.getLocalPart())) {
                    operator.addPolicyComponent(this.getPolicyOperator(childElement));
                    continue;
                }
                if ("ExactlyOne".equals(qn.getLocalPart())) {
                    operator.addPolicyComponent(this.getExactlyOneOperator(childElement));
                    continue;
                }
                if ("All".equals(qn.getLocalPart())) {
                    operator.addPolicyComponent(this.getAllOperator(childElement));
                    continue;
                }
                if ("PolicyReference".equals(qn.getLocalPart())) {
                    operator.addPolicyComponent(this.getPolicyReference(childElement));
                    continue;
                }
                operator.addPolicyComponent(this.factory.build(childElement));
                continue;
            }
            operator.addPolicyComponent(this.factory.build(childElement));
        }
        return operator;
    }

    protected void notifyUnknownPolicyElement(Object childElement) {
    }
}

