/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi.builders.converters;

import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.apache.neethi.builders.converters.Converter;
import org.apache.neethi.builders.converters.DOMToDOMConverter;
import org.apache.neethi.builders.converters.DOMToStaxConverter;
import org.apache.neethi.builders.converters.StaxToDOMConverter;
import org.apache.neethi.builders.converters.StaxToStaxConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterRegistry {
    private List<ConverterKey> registeredConverters = new CopyOnWriteArrayList<ConverterKey>();

    public ConverterRegistry() {
        this.registerConverter(new DOMToDOMConverter());
        this.registerConverter(new StaxToStaxConverter());
        this.registerConverter(new StaxToDOMConverter());
        this.registerConverter(new DOMToStaxConverter());
        this.registerConverter("org.apache.neethi.builders.converters.DOMToOMConverter");
        this.registerConverter("org.apache.neethi.builders.converters.OMToDOMConverter");
        this.registerConverter("org.apache.neethi.builders.converters.OMToOMConverter");
        this.registerConverter("org.apache.neethi.builders.converters.StaxToOMConverter");
        this.registerConverter("org.apache.neethi.builders.converters.OMToStaxConverter");
    }

    private void registerConverter(String name) {
        try {
            Converter c2 = (Converter)Class.forName(name, true, Converter.class.getClassLoader()).newInstance();
            this.registerConverter(c2);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private static ConverterKey createConverterKey(Converter<?, ?> converter, Class<?> c2) {
        Class<?>[] interfaces2 = c2.getInterfaces();
        for (int x = 0; x < interfaces2.length; ++x) {
            if (interfaces2[x] != Converter.class) continue;
            ParameterizedType pt = (ParameterizedType)c2.getGenericInterfaces()[x];
            ConverterKey key = new ConverterKey();
            key.src = (Class)pt.getActualTypeArguments()[0];
            key.target = (Class)pt.getActualTypeArguments()[1];
            key.converter = converter;
            return key;
        }
        if (c2.getSuperclass() != null) {
            return ConverterRegistry.createConverterKey(converter, c2.getSuperclass());
        }
        return null;
    }

    public final void registerConverter(Converter<?, ?> converter) {
        ConverterKey key = ConverterRegistry.createConverterKey(converter, converter.getClass());
        this.registeredConverters.add(key);
    }

    public QName findQName(Object element2) {
        ConverterKey key = this.findCompatibleConverter(element2);
        try {
            return (QName)key.converter.getClass().getMethod("getQName", key.src).invoke((Object)key.converter, element2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public Map<QName, String> getAttributes(Object element2) {
        ConverterKey key = this.findCompatibleConverter(element2);
        try {
            return (Map)key.converter.getClass().getMethod("getAttributes", key.src).invoke((Object)key.converter, element2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public Iterator<Object> getChildElements(Object element2) {
        ConverterKey key = this.findCompatibleConverter(element2);
        try {
            return (Iterator)key.converter.getClass().getMethod("getChildren", key.src).invoke((Object)key.converter, element2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public Object convert(Object src, Class<?> target2) {
        for (ConverterKey ent : this.registeredConverters) {
            if (!ent.src.isInstance(src) || !ent.target.isAssignableFrom(target2)) continue;
            return ent.converter.convert(src);
        }
        throw new RuntimeException("Could not find a converter to convert from " + src.getClass() + " to " + target2);
    }

    private ConverterKey findCompatibleConverter(Object element2) {
        for (ConverterKey ent : this.registeredConverters) {
            if (!ent.src.isInstance(element2)) continue;
            return ent;
        }
        throw new RuntimeException("Could not find a converter to handle " + element2.getClass());
    }

    private static class ConverterKey {
        Class<?> src;
        Class<?> target;
        Converter converter;

        private ConverterKey() {
        }
    }
}

