/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi.builders.converters;

import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.neethi.builders.converters.AbstractStaxConverter;
import org.apache.neethi.builders.converters.Converter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxToDOMConverter
extends AbstractStaxConverter
implements Converter<XMLStreamReader, Element> {
    @Override
    public Element convert(XMLStreamReader reader2) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            StaxToDOMConverter.readDocElements(doc, doc, reader2);
            return doc.getDocumentElement();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void readDocElements(Document doc, Node parent2, XMLStreamReader reader2) throws XMLStreamException {
        Stack<Node> stack = new Stack<Node>();
        int event = reader2.getEventType();
        while (reader2.hasNext()) {
            switch (event) {
                case 1: {
                    String prefix2;
                    Element e2 = doc.createElementNS(reader2.getNamespaceURI(), reader2.getLocalName());
                    if (reader2.getPrefix() != null) {
                        e2.setPrefix(reader2.getPrefix());
                    }
                    e2 = (Element)parent2.appendChild(e2);
                    for (int ns = 0; ns < reader2.getNamespaceCount(); ++ns) {
                        String uri = reader2.getNamespaceURI(ns);
                        prefix2 = reader2.getNamespacePrefix(ns);
                        StaxToDOMConverter.declare(e2, uri, prefix2);
                    }
                    for (int att = 0; att < reader2.getAttributeCount(); ++att) {
                        String name = reader2.getAttributeLocalName(att);
                        prefix2 = reader2.getAttributePrefix(att);
                        if (prefix2 != null && prefix2.length() > 0) {
                            name = prefix2 + ":" + name;
                        }
                        Attr attr = doc.createAttributeNS(reader2.getAttributeNamespace(att), name);
                        attr.setValue(reader2.getAttributeValue(att));
                        e2.setAttributeNode(attr);
                    }
                    stack.push(parent2);
                    parent2 = e2;
                    break;
                }
                case 2: {
                    if (stack.isEmpty()) {
                        return;
                    }
                    parent2 = (Node)stack.pop();
                    if (!(parent2 instanceof Document)) break;
                    return;
                }
                case 13: {
                    break;
                }
                case 10: {
                    break;
                }
                case 4: {
                    if (parent2 == null) break;
                    parent2.appendChild(doc.createTextNode(reader2.getText()));
                    break;
                }
                case 5: {
                    if (parent2 == null) break;
                    parent2.appendChild(doc.createComment(reader2.getText()));
                    break;
                }
                case 12: {
                    parent2.appendChild(doc.createCDATASection(reader2.getText()));
                    break;
                }
                case 3: {
                    parent2.appendChild(doc.createProcessingInstruction(reader2.getPITarget(), reader2.getPIData()));
                    break;
                }
                case 9: {
                    parent2.appendChild(doc.createProcessingInstruction(reader2.getPITarget(), reader2.getPIData()));
                    break;
                }
            }
            if (!reader2.hasNext()) continue;
            event = reader2.next();
        }
    }

    private static void declare(Element node4, String uri, String prefix2) {
        String qualname = prefix2 != null && prefix2.length() > 0 ? "xmlns:" + prefix2 : "xmlns";
        Attr attr = node4.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", qualname);
        attr.setValue(uri);
        node4.setAttributeNodeNS(attr);
    }
}

