/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.schema.SchemaBuilder;
import org.apache.ws.commons.schema.TypeReceiver;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaNotation;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.apache.ws.commons.schema.extensions.ExtensionRegistry;
import org.apache.ws.commons.schema.resolver.CollectionURIResolver;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.commons.schema.utils.DOMUtil;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.TargetNamespaceValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSchemaCollection {
    String baseUri;
    Stack<SchemaKey> stack;
    Map<QName, List<TypeReceiver>> unresolvedTypes;
    XmlSchema xsd;
    private ExtensionRegistry extReg;
    private Map<String, XmlSchema> knownNamespaceMap;
    private NamespacePrefixList namespaceContext;
    private URIResolver schemaResolver;
    private Map<SchemaKey, XmlSchema> schemas;

    public XmlSchemaCollection() {
        this.init();
    }

    public boolean check(SchemaKey pKey) {
        return this.stack.indexOf(pKey) == -1;
    }

    public ExtensionRegistry getExtReg() {
        return this.extReg;
    }

    public Map<String, XmlSchema> getKnownNamespaceMap() {
        return this.knownNamespaceMap;
    }

    public NamespacePrefixList getNamespaceContext() {
        return this.namespaceContext;
    }

    public URIResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public XmlSchemaType getTypeByQName(QName schemaTypeName) {
        String uri = schemaTypeName.getNamespaceURI();
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            XmlSchemaType type;
            if (!entry2.getKey().getNamespace().equals(uri) || (type = entry2.getValue().getTypeByName(schemaTypeName)) == null) continue;
            return type;
        }
        return null;
    }

    public XmlSchema[] getXmlSchema(String systemId) {
        if (systemId == null) {
            systemId = "";
        }
        ArrayList<XmlSchema> result2 = new ArrayList<XmlSchema>();
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            if (!entry2.getKey().getSystemId().equals(systemId)) continue;
            result2.add(entry2.getValue());
        }
        return result2.toArray(new XmlSchema[result2.size()]);
    }

    public XmlSchema[] getXmlSchemas() {
        Collection<XmlSchema> c2 = this.schemas.values();
        return c2.toArray(new XmlSchema[c2.size()]);
    }

    public void init() {
        this.stack = new Stack();
        this.unresolvedTypes = new HashMap<QName, List<TypeReceiver>>();
        this.extReg = new ExtensionRegistry();
        this.knownNamespaceMap = new HashMap<String, XmlSchema>();
        this.schemaResolver = new DefaultURIResolver();
        this.schemas = new HashMap<SchemaKey, XmlSchema>();
        this.xsd = new XmlSchema("http://www.w3.org/2001/XMLSchema", this);
        this.addSimpleType(this.xsd, Constants.XSD_ANYSIMPLETYPE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ANYTYPE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_STRING.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BOOLEAN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_FLOAT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DOUBLE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_QNAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DECIMAL.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DURATION.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DATE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_TIME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DATETIME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DAY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_MONTH.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_MONTHDAY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_YEAR.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_YEARMONTH.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NOTATION.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_HEXBIN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BASE64.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ANYURI.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_LONG.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_SHORT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BYTE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_INTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_INT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_POSITIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NEGATIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NONPOSITIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NONNEGATIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDBYTE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDINT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDLONG.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDSHORT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NORMALIZEDSTRING.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NCNAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NMTOKEN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NMTOKENS.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ENTITY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ENTITIES.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ID.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_IDREF.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_IDREFS.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_LANGUAGE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_TOKEN.getLocalPart());
        if (System.getProperty("org.apache.ws.commons.extensions.ExtensionRegistry") != null) {
            try {
                Class<?> clazz2 = Class.forName(System.getProperty("org.apache.ws.commons.extensions.ExtensionRegistry"));
                this.extReg = (ExtensionRegistry)clazz2.newInstance();
            }
            catch (ClassNotFoundException e2) {
                System.err.println("The specified extension registry class cannot be found!");
            }
            catch (InstantiationException e3) {
                System.err.println("The specified extension registry class cannot be instantiated!");
            }
            catch (IllegalAccessException e4) {
                System.err.println("The specified extension registry class cannot be accessed!");
            }
        }
    }

    public void pop() {
        this.stack.pop();
    }

    public void push(SchemaKey pKey) {
        this.stack.push(pKey);
    }

    public XmlSchema read(Document doc, String systemId) {
        return this.read(doc, systemId, null);
    }

    public XmlSchema read(Document doc, String systemId, TargetNamespaceValidator validator) {
        SchemaBuilder builder = new SchemaBuilder(this, validator);
        XmlSchema schema = builder.build(doc, systemId);
        schema.setInputEncoding(DOMUtil.getInputEncoding(doc));
        return schema;
    }

    public XmlSchema read(Document doc) {
        SchemaBuilder builder = new SchemaBuilder(this, null);
        return builder.build(doc, null);
    }

    public XmlSchema read(Element elem2) {
        SchemaBuilder builder = new SchemaBuilder(this, null);
        XmlSchema xmlSchema = builder.handleXmlSchemaElement(elem2, null);
        xmlSchema.setInputEncoding(DOMUtil.getXmlEncoding(elem2.getOwnerDocument()));
        return xmlSchema;
    }

    public XmlSchema read(Element elem2, String systemId) {
        SchemaBuilder builder = new SchemaBuilder(this, null);
        XmlSchema xmlSchema = builder.handleXmlSchemaElement(elem2, systemId);
        xmlSchema.setInputEncoding(DOMUtil.getInputEncoding(elem2.getOwnerDocument()));
        return xmlSchema;
    }

    public XmlSchema read(InputSource inputSource) {
        return this.read(inputSource, null);
    }

    public XmlSchema read(Reader r) {
        return this.read(new InputSource(r));
    }

    public XmlSchema read(Source source) {
        if (source instanceof SAXSource) {
            return this.read(((SAXSource)source).getInputSource());
        }
        if (source instanceof DOMSource) {
            Node node4 = ((DOMSource)source).getNode();
            if (node4 instanceof Document) {
                node4 = ((Document)node4).getDocumentElement();
            }
            return this.read((Document)node4);
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            InputSource isource = new InputSource(ss.getSystemId());
            isource.setByteStream(ss.getInputStream());
            isource.setCharacterStream(ss.getReader());
            isource.setPublicId(ss.getPublicId());
            return this.read(isource);
        }
        InputSource isource = new InputSource(source.getSystemId());
        return this.read(isource);
    }

    public XmlSchema schemaForNamespace(String uri) {
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            if (!entry2.getKey().getNamespace().equals(uri)) continue;
            return entry2.getValue();
        }
        return null;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
        if (this.schemaResolver instanceof CollectionURIResolver) {
            CollectionURIResolver resolverWithBase = (CollectionURIResolver)this.schemaResolver;
            resolverWithBase.setCollectionBaseURI(baseUri);
        }
    }

    public void setExtReg(ExtensionRegistry extReg) {
        this.extReg = extReg;
    }

    public void setKnownNamespaceMap(Map<String, XmlSchema> knownNamespaceMap) {
        this.knownNamespaceMap = knownNamespaceMap;
    }

    public void setNamespaceContext(NamespacePrefixList namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public void setSchemaResolver(URIResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public String toString() {
        return super.toString() + "[" + this.schemas.toString() + "]";
    }

    void addSchema(SchemaKey pKey, XmlSchema pSchema) {
        if (this.schemas.containsKey(pKey)) {
            throw new IllegalStateException("A schema with target namespace " + pKey.getNamespace() + " and system ID " + pKey.getSystemId() + " is already present.");
        }
        this.schemas.put(pKey, pSchema);
    }

    void addUnresolvedType(QName type, TypeReceiver receiver) {
        List<TypeReceiver> receivers = this.unresolvedTypes.get(type);
        if (receivers == null) {
            receivers = new ArrayList<TypeReceiver>();
            this.unresolvedTypes.put(type, receivers);
        }
        receivers.add(receiver);
    }

    boolean containsSchema(SchemaKey pKey) {
        return this.schemas.containsKey(pKey);
    }

    XmlSchema getKnownSchema(String namespace) {
        return this.knownNamespaceMap.get(namespace);
    }

    XmlSchema getSchema(SchemaKey pKey) {
        return this.schemas.get(pKey);
    }

    XmlSchema read(InputSource inputSource, TargetNamespaceValidator namespaceValidator) {
        try {
            DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
            docFac.setNamespaceAware(true);
            DocumentBuilder builder = docFac.newDocumentBuilder();
            Document doc = null;
            doc = this.parseDoPriv(inputSource, builder, doc);
            return this.read(doc, inputSource.getSystemId(), namespaceValidator);
        }
        catch (ParserConfigurationException e2) {
            throw new XmlSchemaException(e2.getMessage());
        }
        catch (IOException e3) {
            throw new XmlSchemaException(e3.getMessage());
        }
        catch (SAXException e4) {
            throw new XmlSchemaException(e4.getMessage());
        }
    }

    void resolveType(QName typeName, XmlSchemaType type) {
        List<TypeReceiver> receivers = this.unresolvedTypes.get(typeName);
        if (receivers == null) {
            return;
        }
        for (TypeReceiver receiver : receivers) {
            receiver.setType(type);
        }
        this.unresolvedTypes.remove(typeName);
    }

    private void addSimpleType(XmlSchema schema, String typeName) {
        XmlSchemaSimpleType type = new XmlSchemaSimpleType(schema, true);
        type.setName(typeName);
    }

    private Document parseDoPriv(final InputSource inputSource, final DocumentBuilder builder, Document doc) throws IOException, SAXException {
        block3: {
            try {
                doc = AccessController.doPrivileged(new PrivilegedExceptionAction<Document>(){

                    @Override
                    public Document run() throws IOException, SAXException {
                        return builder.parse(inputSource);
                    }
                });
            }
            catch (PrivilegedActionException e2) {
                Exception exception = e2.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof SAXException)) break block3;
                throw (SAXException)exception;
            }
        }
        return doc;
    }

    public XmlSchemaAttribute getAttributeByQName(QName schemaAttributeName) {
        String uri = schemaAttributeName.getNamespaceURI();
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            XmlSchemaAttribute attribute2;
            if (!entry2.getKey().getNamespace().equals(uri) || (attribute2 = entry2.getValue().getAttributeByName(schemaAttributeName)) == null) continue;
            return attribute2;
        }
        return null;
    }

    public XmlSchemaElement getElementByQName(QName qname) {
        String uri = qname.getNamespaceURI();
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            XmlSchemaElement element2;
            if (!entry2.getKey().getNamespace().equals(uri) || (element2 = entry2.getValue().getElementByName(qname)) == null) continue;
            return element2;
        }
        return null;
    }

    public XmlSchemaAttributeGroup getAttributeGroupByQName(QName name) {
        String uri = name.getNamespaceURI();
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            XmlSchemaAttributeGroup group;
            if (!entry2.getKey().getNamespace().equals(uri) || (group = entry2.getValue().getAttributeGroupByName(name)) == null) continue;
            return group;
        }
        return null;
    }

    public XmlSchemaGroup getGroupByQName(QName name) {
        String uri = name.getNamespaceURI();
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            XmlSchemaGroup group;
            if (!entry2.getKey().getNamespace().equals(uri) || (group = entry2.getValue().getGroupByName(name)) == null) continue;
            return group;
        }
        return null;
    }

    public XmlSchemaNotation getNotationByQName(QName name) {
        String uri = name.getNamespaceURI();
        for (Map.Entry<SchemaKey, XmlSchema> entry2 : this.schemas.entrySet()) {
            XmlSchemaNotation notation;
            if (!entry2.getKey().getNamespace().equals(uri) || (notation = entry2.getValue().getNotationByName(name)) == null) continue;
            return notation;
        }
        return null;
    }

    public static class SchemaKey {
        private final String namespace;
        private final String systemId;

        SchemaKey(String pNamespace, String pSystemId) {
            this.namespace = pNamespace == null ? "" : pNamespace;
            this.systemId = pSystemId == null ? "" : pSystemId;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.namespace == null ? 0 : this.namespace.hashCode());
            result2 = 31 * result2 + (this.systemId == null ? 0 : this.systemId.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SchemaKey other = (SchemaKey)obj;
            if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                return false;
            }
            return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
        }

        public String toString() {
            return "".equals(this.namespace) ? this.systemId : "{" + this.namespace + "}" + this.systemId;
        }

        String getNamespace() {
            return this.namespace;
        }

        String getSystemId() {
            return this.systemId;
        }
    }
}

