/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.resolver;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.ws.commons.schema.resolver.CollectionURIResolver;
import org.xml.sax.InputSource;

public class DefaultURIResolver
implements CollectionURIResolver {
    private String collectionBaseURI;

    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        if (baseUri != null) {
            try {
                File baseFile = new File(baseUri);
                if (baseFile.exists()) {
                    baseUri = baseFile.toURI().toString();
                } else if (this.collectionBaseURI != null && (baseFile = new File(this.collectionBaseURI)).exists()) {
                    baseUri = baseFile.toURI().toString();
                }
                String ref = new URI(baseUri).resolve(new URI(schemaLocation)).toString();
                return new InputSource(ref);
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException(e1);
            }
        }
        return new InputSource(schemaLocation);
    }

    protected boolean isAbsolute(String uri) {
        return uri.startsWith("http://") || uri.startsWith("https://") || uri.startsWith("urn:");
    }

    protected URL getURL(URL contextURL, String spec2) throws IOException {
        URL url;
        String path2 = spec2.replace('\\', '/');
        try {
            url = new URL(contextURL, path2);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = this.getFileURL(contextURL, path2);
            }
        }
        catch (MalformedURLException me) {
            url = this.getFileURL(contextURL, path2);
        }
        return url;
    }

    protected URL getFileURL(URL contextURL, String path2) throws IOException {
        if (contextURL != null) {
            String contextFileName = contextURL.getFile();
            URL parent2 = null;
            File contextFile = new File(contextFileName);
            File parentFile = contextFile.isDirectory() ? contextFile : contextFile.getParentFile();
            if (parentFile != null) {
                parent2 = parentFile.toURI().toURL();
            }
            if (parent2 != null) {
                return new URL(parent2, path2);
            }
        }
        return new URL("file", "", path2);
    }

    public String getCollectionBaseURI() {
        return this.collectionBaseURI;
    }

    public void setCollectionBaseURI(String collectionBaseURI) {
        this.collectionBaseURI = collectionBaseURI;
    }
}

