/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionFactory {
    private static final String PROTECT_READ_ONLY_COLLECTIONS_PROP = "org.apache.ws.commons.schema.protectReadOnlyCollections";
    private static final ThreadLocal<Boolean> PROTECT_READ_ONLY_COLLECTIONS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.parseBoolean(System.getProperty(CollectionFactory.PROTECT_READ_ONLY_COLLECTIONS_PROP));
        }
    };

    private CollectionFactory() {
    }

    public static <T> List<T> getList(Class<T> type) {
        return Collections.synchronizedList(new ArrayList());
    }

    public static <T> Set<T> getSet(Class<T> type) {
        return Collections.synchronizedSet(new HashSet());
    }

    public static <T> List<T> getProtectedList(List<T> list2) {
        if (PROTECT_READ_ONLY_COLLECTIONS.get().booleanValue()) {
            return Collections.unmodifiableList(list2);
        }
        return list2;
    }

    public static <K, V> Map<K, V> getProtectedMap(Map<K, V> map3) {
        if (PROTECT_READ_ONLY_COLLECTIONS.get().booleanValue()) {
            return Collections.unmodifiableMap(map3);
        }
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withSchemaModifiable(Runnable action2) {
        Boolean saved = PROTECT_READ_ONLY_COLLECTIONS.get();
        try {
            PROTECT_READ_ONLY_COLLECTIONS.set(Boolean.FALSE);
            action2.run();
        }
        finally {
            PROTECT_READ_ONLY_COLLECTIONS.set(saved);
        }
    }
}

