/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.utils;

import java.lang.reflect.Method;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtil {
    private static final String DEFAULT_ENCODING = "UTF-8";

    protected DOMUtil() {
    }

    public static Element getFirstChildElement(Node parent2) {
        for (Node child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent2) {
        for (Node child = parent2.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node4) {
        for (Node sibling = node4.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent2, String elemName) {
        for (Node child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(elemName)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent2, String elemName) {
        for (Node child = parent2.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(elemName)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node4, String elemName) {
        for (Node sibling = node4.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1 || !sibling.getNodeName().equals(elemName)) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getFirstChildElementNS(Node parent2, String uri, String localpart) {
        for (Node child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childURI;
            if (child.getNodeType() != 1 || (childURI = child.getNamespaceURI()) == null || !childURI.equals(uri) || !child.getLocalName().equals(localpart)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElementNS(Node parent2, String uri, String localpart) {
        for (Node child = parent2.getLastChild(); child != null; child = child.getPreviousSibling()) {
            String childURI;
            if (child.getNodeType() != 1 || (childURI = child.getNamespaceURI()) == null || !childURI.equals(uri) || !child.getLocalName().equals(localpart)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElementNS(Node node4, String uri, String localpart) {
        for (Node sibling = node4.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            String siblingURI;
            if (sibling.getNodeType() != 1 || (siblingURI = sibling.getNamespaceURI()) == null || !siblingURI.equals(uri) || !sibling.getLocalName().equals(localpart)) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent2, String[] elemNames) {
        for (Node child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            for (String elemName : elemNames) {
                if (!child.getNodeName().equals(elemName)) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getLastChildElement(Node parent2, String[] elemNames) {
        for (Node child = parent2.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            for (String elemName : elemNames) {
                if (!child.getNodeName().equals(elemName)) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node4, String[] elemNames) {
        for (Node sibling = node4.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            for (String elemName : elemNames) {
                if (!sibling.getNodeName().equals(elemName)) continue;
                return (Element)sibling;
            }
        }
        return null;
    }

    public static Element getFirstChildElementNS(Node parent2, String[][] elemNames) {
        for (Node child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            for (String[] elemName : elemNames) {
                String uri = child.getNamespaceURI();
                if (uri == null || !uri.equals(elemName[0]) || !child.getLocalName().equals(elemName[1])) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getLastChildElementNS(Node parent2, String[][] elemNames) {
        for (Node child = parent2.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            for (String[] elemName : elemNames) {
                String uri = child.getNamespaceURI();
                if (uri == null || !uri.equals(elemName[0]) || !child.getLocalName().equals(elemName[1])) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getNextSiblingElementNS(Node node4, String[][] elemNames) {
        for (Node sibling = node4.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            for (String[] elemName : elemNames) {
                String uri = sibling.getNamespaceURI();
                if (uri == null || !uri.equals(elemName[0]) || !sibling.getLocalName().equals(elemName[1])) continue;
                return (Element)sibling;
            }
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent2, String elemName, String attrName, String attrValue) {
        for (Node child = parent2.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element element2;
            if (child.getNodeType() != 1 || !(element2 = (Element)child).getNodeName().equals(elemName) || !element2.getAttribute(attrName).equals(attrValue)) continue;
            return element2;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent2, String elemName, String attrName, String attrValue) {
        for (Node child = parent2.getLastChild(); child != null; child = child.getPreviousSibling()) {
            Element element2;
            if (child.getNodeType() != 1 || !(element2 = (Element)child).getNodeName().equals(elemName) || !element2.getAttribute(attrName).equals(attrValue)) continue;
            return element2;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node4, String elemName, String attrName, String attrValue) {
        for (Node sibling = node4.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            Element element2;
            if (sibling.getNodeType() != 1 || !(element2 = (Element)sibling).getNodeName().equals(elemName) || !element2.getAttribute(attrName).equals(attrValue)) continue;
            return element2;
        }
        return null;
    }

    public static String getChildText(Node node4) {
        if (node4 == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (Node child = node4.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
                continue;
            }
            if (type != 4) continue;
            str.append(DOMUtil.getChildText(child));
        }
        return str.toString();
    }

    public static String getName(Node node4) {
        return node4.getNodeName();
    }

    public static String getLocalName(Node node4) {
        String name = node4.getLocalName();
        return name != null ? name : node4.getNodeName();
    }

    public static Element getParent(Element elem2) {
        Node parent2 = elem2.getParentNode();
        if (parent2 instanceof Element) {
            return (Element)parent2;
        }
        return null;
    }

    public static Document getDocument(Node node4) {
        return node4.getOwnerDocument();
    }

    public static Element getRoot(Document doc) {
        return doc.getDocumentElement();
    }

    public static Attr getAttr(Element elem2, String name) {
        return elem2.getAttributeNode(name);
    }

    public static Attr getAttrNS(Element elem2, String nsUri, String localName) {
        return elem2.getAttributeNodeNS(nsUri, localName);
    }

    public static Attr[] getAttrs(Element elem2) {
        NamedNodeMap attrMap = elem2.getAttributes();
        Attr[] attrArray = new Attr[attrMap.getLength()];
        for (int i = 0; i < attrMap.getLength(); ++i) {
            attrArray[i] = (Attr)attrMap.item(i);
        }
        return attrArray;
    }

    public static String getValue(Attr attribute2) {
        return attribute2.getValue();
    }

    public static String getAttrValue(Element elem2, String name) {
        return elem2.getAttribute(name);
    }

    public static String getAttrValueNS(Element elem2, String nsUri, String localName) {
        return elem2.getAttributeNS(nsUri, localName);
    }

    public static String getNamespaceURI(Node node4) {
        return node4.getNamespaceURI();
    }

    public static String getInputEncoding(Document doc) {
        try {
            Method m = doc.getClass().getMethod("getInputEncoding", new Class[0]);
            return (String)m.invoke((Object)doc, new Object[0]);
        }
        catch (Throwable e2) {
            return DEFAULT_ENCODING;
        }
    }

    public static String getXmlEncoding(Document doc) {
        try {
            Method m = doc.getClass().getMethod("getXmlEncoding", new Class[0]);
            return (String)m.invoke((Object)doc, new Object[0]);
        }
        catch (Throwable e2) {
            return DEFAULT_ENCODING;
        }
    }
}

