/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.helpers.FileURL;
import org.apache.xml.resolver.helpers.PublicId;
import org.apache.xml.resolver.readers.CatalogReader;
import org.apache.xml.resolver.readers.SAXCatalogReader;
import org.apache.xml.resolver.readers.TR9401CatalogReader;

public class Catalog {
    public static final int BASE = CatalogEntry.addEntryType("BASE", 1);
    public static final int CATALOG = CatalogEntry.addEntryType("CATALOG", 1);
    public static final int DOCUMENT = CatalogEntry.addEntryType("DOCUMENT", 1);
    public static final int OVERRIDE = CatalogEntry.addEntryType("OVERRIDE", 1);
    public static final int SGMLDECL = CatalogEntry.addEntryType("SGMLDECL", 1);
    public static final int DELEGATE_PUBLIC = CatalogEntry.addEntryType("DELEGATE_PUBLIC", 2);
    public static final int DELEGATE_SYSTEM = CatalogEntry.addEntryType("DELEGATE_SYSTEM", 2);
    public static final int DELEGATE_URI = CatalogEntry.addEntryType("DELEGATE_URI", 2);
    public static final int DOCTYPE = CatalogEntry.addEntryType("DOCTYPE", 2);
    public static final int DTDDECL = CatalogEntry.addEntryType("DTDDECL", 2);
    public static final int ENTITY = CatalogEntry.addEntryType("ENTITY", 2);
    public static final int LINKTYPE = CatalogEntry.addEntryType("LINKTYPE", 2);
    public static final int NOTATION = CatalogEntry.addEntryType("NOTATION", 2);
    public static final int PUBLIC = CatalogEntry.addEntryType("PUBLIC", 2);
    public static final int SYSTEM = CatalogEntry.addEntryType("SYSTEM", 2);
    public static final int URI = CatalogEntry.addEntryType("URI", 2);
    public static final int REWRITE_SYSTEM = CatalogEntry.addEntryType("REWRITE_SYSTEM", 2);
    public static final int REWRITE_URI = CatalogEntry.addEntryType("REWRITE_URI", 2);
    public static final int SYSTEM_SUFFIX = CatalogEntry.addEntryType("SYSTEM_SUFFIX", 2);
    public static final int URI_SUFFIX = CatalogEntry.addEntryType("URI_SUFFIX", 2);
    protected URL base;
    protected URL catalogCwd;
    protected Vector catalogEntries = new Vector();
    protected boolean default_override = true;
    protected CatalogManager catalogManager = CatalogManager.getStaticManager();
    protected Vector catalogFiles = new Vector();
    protected Vector localCatalogFiles = new Vector();
    protected Vector catalogs = new Vector();
    protected Vector localDelegate = new Vector();
    protected Hashtable readerMap = new Hashtable();
    protected Vector readerArr = new Vector();

    public Catalog() {
    }

    public Catalog(CatalogManager manager) {
        this.catalogManager = manager;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public void setCatalogManager(CatalogManager manager) {
        this.catalogManager = manager;
    }

    public void setupReaders() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        SAXCatalogReader saxReader = new SAXCatalogReader(spf);
        saxReader.setCatalogParser(null, "XCatalog", "org.apache.xml.resolver.readers.XCatalogReader");
        saxReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.OASISXMLCatalogReader");
        this.addReader("application/xml", saxReader);
        TR9401CatalogReader textReader = new TR9401CatalogReader();
        this.addReader("text/plain", textReader);
    }

    public void addReader(String mimeType, CatalogReader reader2) {
        if (this.readerMap.containsKey(mimeType)) {
            Integer pos = (Integer)this.readerMap.get(mimeType);
            this.readerArr.set(pos, reader2);
        } else {
            this.readerArr.add(reader2);
            Integer pos = new Integer(this.readerArr.size() - 1);
            this.readerMap.put(mimeType, pos);
        }
    }

    protected void copyReaders(Catalog newCatalog) {
        Vector<String> mapArr = new Vector<String>(this.readerMap.size());
        int count2 = 0;
        while (count2 < this.readerMap.size()) {
            mapArr.add(null);
            ++count2;
        }
        Enumeration en = this.readerMap.keys();
        while (en.hasMoreElements()) {
            String mimeType = (String)en.nextElement();
            Integer pos = (Integer)this.readerMap.get(mimeType);
            mapArr.set(pos, mimeType);
        }
        int count3 = 0;
        while (count3 < mapArr.size()) {
            String mimeType = (String)mapArr.get(count3);
            Integer pos = (Integer)this.readerMap.get(mimeType);
            newCatalog.addReader(mimeType, (CatalogReader)this.readerArr.get(pos));
            ++count3;
        }
    }

    protected Catalog newCatalog() {
        String catalogClass = this.getClass().getName();
        try {
            Catalog c2 = (Catalog)Class.forName(catalogClass).newInstance();
            c2.setCatalogManager(this.catalogManager);
            this.copyReaders(c2);
            return c2;
        }
        catch (ClassNotFoundException cnfe) {
            this.catalogManager.debug.message(1, "Class Not Found Exception: " + catalogClass);
        }
        catch (IllegalAccessException iae) {
            this.catalogManager.debug.message(1, "Illegal Access Exception: " + catalogClass);
        }
        catch (InstantiationException ie) {
            this.catalogManager.debug.message(1, "Instantiation Exception: " + catalogClass);
        }
        catch (ClassCastException cce) {
            this.catalogManager.debug.message(1, "Class Cast Exception: " + catalogClass);
        }
        catch (Exception e2) {
            this.catalogManager.debug.message(1, "Other Exception: " + catalogClass);
        }
        Catalog c3 = new Catalog();
        c3.setCatalogManager(this.catalogManager);
        this.copyReaders(c3);
        return c3;
    }

    public String getCurrentBase() {
        return this.base.toString();
    }

    public String getDefaultOverride() {
        if (this.default_override) {
            return "yes";
        }
        return "no";
    }

    public void loadSystemCatalogs() throws MalformedURLException, IOException {
        Vector catalogs = this.catalogManager.getCatalogFiles();
        if (catalogs != null) {
            int count2 = 0;
            while (count2 < catalogs.size()) {
                this.catalogFiles.addElement(catalogs.elementAt(count2));
                ++count2;
            }
        }
        if (this.catalogFiles.size() > 0) {
            String catfile = (String)this.catalogFiles.lastElement();
            this.catalogFiles.removeElement(catfile);
            this.parseCatalog(catfile);
        }
    }

    public synchronized void parseCatalog(String fileName) throws MalformedURLException, IOException {
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse catalog: " + fileName);
        this.catalogFiles.addElement(fileName);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(String mimeType, InputStream is2) throws IOException, CatalogException {
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse " + mimeType + " catalog on input stream");
        CatalogReader reader2 = null;
        if (this.readerMap.containsKey(mimeType)) {
            int arrayPos = (Integer)this.readerMap.get(mimeType);
            reader2 = (CatalogReader)this.readerArr.get(arrayPos);
        }
        if (reader2 == null) {
            String msg = "No CatalogReader for MIME type: " + mimeType;
            this.catalogManager.debug.message(2, msg);
            throw new CatalogException(6, msg);
        }
        reader2.readCatalog(this, is2);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(URL aUrl) throws IOException {
        this.catalogCwd = aUrl;
        this.base = aUrl;
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse catalog: " + aUrl.toString());
        DataInputStream inStream = null;
        boolean parsed = false;
        int count2 = 0;
        while (!parsed && count2 < this.readerArr.size()) {
            CatalogReader reader2 = (CatalogReader)this.readerArr.get(count2);
            try {
                inStream = new DataInputStream(aUrl.openStream());
            }
            catch (FileNotFoundException fnfe) {
                break;
            }
            try {
                reader2.readCatalog(this, inStream);
                parsed = true;
            }
            catch (CatalogException ce) {
                if (ce.getExceptionType() == 7) break;
            }
            try {
                inStream.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            ++count2;
        }
        if (parsed) {
            this.parsePendingCatalogs();
        }
    }

    protected synchronized void parsePendingCatalogs() throws MalformedURLException, IOException {
        if (!this.localCatalogFiles.isEmpty()) {
            Vector newQueue = new Vector();
            Enumeration q = this.localCatalogFiles.elements();
            while (q.hasMoreElements()) {
                newQueue.addElement(q.nextElement());
            }
            int curCat = 0;
            while (curCat < this.catalogFiles.size()) {
                String catfile = (String)this.catalogFiles.elementAt(curCat);
                newQueue.addElement(catfile);
                ++curCat;
            }
            this.catalogFiles = newQueue;
            this.localCatalogFiles.clear();
        }
        if (this.catalogFiles.isEmpty() && !this.localDelegate.isEmpty()) {
            Enumeration e2 = this.localDelegate.elements();
            while (e2.hasMoreElements()) {
                this.catalogEntries.addElement(e2.nextElement());
            }
            this.localDelegate.clear();
        }
        while (!this.catalogFiles.isEmpty()) {
            String catfile = (String)this.catalogFiles.elementAt(0);
            try {
                this.catalogFiles.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException e3) {
                // empty catch block
            }
            if (this.catalogEntries.size() == 0 && this.catalogs.size() == 0) {
                try {
                    this.parseCatalogFile(catfile);
                }
                catch (CatalogException ce) {
                    System.out.println("FIXME: " + ce.toString());
                }
            } else {
                this.catalogs.addElement(catfile);
            }
            if (!this.localCatalogFiles.isEmpty()) {
                Vector newQueue = new Vector();
                Enumeration q = this.localCatalogFiles.elements();
                while (q.hasMoreElements()) {
                    newQueue.addElement(q.nextElement());
                }
                int curCat = 0;
                while (curCat < this.catalogFiles.size()) {
                    catfile = (String)this.catalogFiles.elementAt(curCat);
                    newQueue.addElement(catfile);
                    ++curCat;
                }
                this.catalogFiles = newQueue;
                this.localCatalogFiles.clear();
            }
            if (this.localDelegate.isEmpty()) continue;
            Enumeration e4 = this.localDelegate.elements();
            while (e4.hasMoreElements()) {
                this.catalogEntries.addElement(e4.nextElement());
            }
            this.localDelegate.clear();
        }
        this.catalogFiles.clear();
    }

    protected synchronized void parseCatalogFile(String fileName) throws MalformedURLException, IOException, CatalogException {
        try {
            this.catalogCwd = FileURL.makeURL("basename");
        }
        catch (MalformedURLException e2) {
            String userdir = System.getProperty("user.dir");
            userdir = userdir.replace('\\', '/');
            this.catalogManager.debug.message(1, "Malformed URL on cwd", userdir);
            this.catalogCwd = null;
        }
        try {
            this.base = new URL(this.catalogCwd, this.fixSlashes(fileName));
        }
        catch (MalformedURLException e3) {
            try {
                this.base = new URL("file:" + this.fixSlashes(fileName));
            }
            catch (MalformedURLException e2) {
                this.catalogManager.debug.message(1, "Malformed URL on catalog filename", this.fixSlashes(fileName));
                this.base = null;
            }
        }
        this.catalogManager.debug.message(2, "Loading catalog", fileName);
        this.catalogManager.debug.message(4, "Default BASE", this.base.toString());
        fileName = this.base.toString();
        DataInputStream inStream = null;
        boolean parsed = false;
        boolean notFound2 = false;
        int count2 = 0;
        while (!parsed && count2 < this.readerArr.size()) {
            CatalogReader reader2 = (CatalogReader)this.readerArr.get(count2);
            try {
                notFound2 = false;
                inStream = new DataInputStream(this.base.openStream());
            }
            catch (FileNotFoundException fnfe) {
                notFound2 = true;
                break;
            }
            try {
                reader2.readCatalog(this, inStream);
                parsed = true;
            }
            catch (CatalogException ce) {
                if (ce.getExceptionType() == 7) break;
            }
            try {
                inStream.close();
            }
            catch (IOException e4) {
                // empty catch block
            }
            ++count2;
        }
        if (!parsed) {
            if (notFound2) {
                this.catalogManager.debug.message(3, "Catalog does not exist", fileName);
            } else {
                this.catalogManager.debug.message(1, "Failed to parse catalog", fileName);
            }
        }
    }

    public void addEntry(CatalogEntry entry2) {
        int type = entry2.getEntryType();
        if (type == BASE) {
            String value2 = entry2.getEntryArg(0);
            URL newbase = null;
            if (this.base == null) {
                this.catalogManager.debug.message(5, "BASE CUR", "null");
            } else {
                this.catalogManager.debug.message(5, "BASE CUR", this.base.toString());
            }
            this.catalogManager.debug.message(4, "BASE STR", value2);
            try {
                value2 = this.fixSlashes(value2);
                newbase = new URL(this.base, value2);
            }
            catch (MalformedURLException e2) {
                try {
                    newbase = new URL("file:" + value2);
                }
                catch (MalformedURLException e22) {
                    this.catalogManager.debug.message(1, "Malformed URL on base", value2);
                    newbase = null;
                }
            }
            if (newbase != null) {
                this.base = newbase;
            }
            this.catalogManager.debug.message(5, "BASE NEW", this.base.toString());
        } else if (type == CATALOG) {
            String fsi = this.makeAbsolute(entry2.getEntryArg(0));
            this.catalogManager.debug.message(4, "CATALOG", fsi);
            this.localCatalogFiles.addElement(fsi);
        } else if (type == PUBLIC) {
            String publicid = PublicId.normalize(entry2.getEntryArg(0));
            String systemid = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, publicid);
            entry2.setEntryArg(1, systemid);
            this.catalogManager.debug.message(4, "PUBLIC", publicid, systemid);
            this.catalogEntries.addElement(entry2);
        } else if (type == SYSTEM) {
            String systemid = this.normalizeURI(entry2.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "SYSTEM", systemid, fsi);
            this.catalogEntries.addElement(entry2);
        } else if (type == URI) {
            String uri = this.normalizeURI(entry2.getEntryArg(0));
            String altURI = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(1, altURI);
            this.catalogManager.debug.message(4, "URI", uri, altURI);
            this.catalogEntries.addElement(entry2);
        } else if (type == DOCUMENT) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(0)));
            entry2.setEntryArg(0, fsi);
            this.catalogManager.debug.message(4, "DOCUMENT", fsi);
            this.catalogEntries.addElement(entry2);
        } else if (type == OVERRIDE) {
            this.catalogManager.debug.message(4, "OVERRIDE", entry2.getEntryArg(0));
            this.catalogEntries.addElement(entry2);
        } else if (type == SGMLDECL) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(0)));
            entry2.setEntryArg(0, fsi);
            this.catalogManager.debug.message(4, "SGMLDECL", fsi);
            this.catalogEntries.addElement(entry2);
        } else if (type == DELEGATE_PUBLIC) {
            String ppi = PublicId.normalize(entry2.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, ppi);
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "DELEGATE_PUBLIC", ppi, fsi);
            this.addDelegate(entry2);
        } else if (type == DELEGATE_SYSTEM) {
            String psi = this.normalizeURI(entry2.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, psi);
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "DELEGATE_SYSTEM", psi, fsi);
            this.addDelegate(entry2);
        } else if (type == DELEGATE_URI) {
            String pui = this.normalizeURI(entry2.getEntryArg(0));
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, pui);
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "DELEGATE_URI", pui, fsi);
            this.addDelegate(entry2);
        } else if (type == REWRITE_SYSTEM) {
            String psi = this.normalizeURI(entry2.getEntryArg(0));
            String rpx = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, psi);
            entry2.setEntryArg(1, rpx);
            this.catalogManager.debug.message(4, "REWRITE_SYSTEM", psi, rpx);
            this.catalogEntries.addElement(entry2);
        } else if (type == REWRITE_URI) {
            String pui = this.normalizeURI(entry2.getEntryArg(0));
            String upx = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, pui);
            entry2.setEntryArg(1, upx);
            this.catalogManager.debug.message(4, "REWRITE_URI", pui, upx);
            this.catalogEntries.addElement(entry2);
        } else if (type == SYSTEM_SUFFIX) {
            String pui = this.normalizeURI(entry2.getEntryArg(0));
            String upx = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, pui);
            entry2.setEntryArg(1, upx);
            this.catalogManager.debug.message(4, "SYSTEM_SUFFIX", pui, upx);
            this.catalogEntries.addElement(entry2);
        } else if (type == URI_SUFFIX) {
            String pui = this.normalizeURI(entry2.getEntryArg(0));
            String upx = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(0, pui);
            entry2.setEntryArg(1, upx);
            this.catalogManager.debug.message(4, "URI_SUFFIX", pui, upx);
            this.catalogEntries.addElement(entry2);
        } else if (type == DOCTYPE) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "DOCTYPE", entry2.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry2);
        } else if (type == DTDDECL) {
            String fpi = PublicId.normalize(entry2.getEntryArg(0));
            entry2.setEntryArg(0, fpi);
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "DTDDECL", fpi, fsi);
            this.catalogEntries.addElement(entry2);
        } else if (type == ENTITY) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "ENTITY", entry2.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry2);
        } else if (type == LINKTYPE) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "LINKTYPE", entry2.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry2);
        } else if (type == NOTATION) {
            String fsi = this.makeAbsolute(this.normalizeURI(entry2.getEntryArg(1)));
            entry2.setEntryArg(1, fsi);
            this.catalogManager.debug.message(4, "NOTATION", entry2.getEntryArg(0), fsi);
            this.catalogEntries.addElement(entry2);
        } else {
            this.catalogEntries.addElement(entry2);
        }
    }

    public void unknownEntry(Vector strings) {
        if (strings != null && strings.size() > 0) {
            String keyword2 = (String)strings.elementAt(0);
            this.catalogManager.debug.message(2, "Unrecognized token parsing catalog", keyword2);
        }
    }

    public void parseAllCatalogs() throws MalformedURLException, IOException {
        int catPos = 0;
        while (catPos < this.catalogs.size()) {
            Catalog c2 = null;
            try {
                c2 = (Catalog)this.catalogs.elementAt(catPos);
            }
            catch (ClassCastException e2) {
                String catfile = (String)this.catalogs.elementAt(catPos);
                c2 = this.newCatalog();
                c2.parseCatalog(catfile);
                this.catalogs.setElementAt(c2, catPos);
                c2.parseAllCatalogs();
            }
            ++catPos;
        }
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e3 = (CatalogEntry)en.nextElement();
            if (e3.getEntryType() != DELEGATE_PUBLIC && e3.getEntryType() != DELEGATE_SYSTEM && e3.getEntryType() != DELEGATE_URI) continue;
            Catalog dcat = this.newCatalog();
            dcat.parseCatalog(e3.getEntryArg(1));
        }
    }

    public String resolveDoctype(String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        this.catalogManager.debug.message(3, "resolveDoctype(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(DOCTYPE, entityName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e2 = (CatalogEntry)en.nextElement();
            if (e2.getEntryType() == OVERRIDE) {
                over = e2.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e2.getEntryType() != DOCTYPE || !e2.getEntryArg(0).equals(entityName) || !over && systemId != null) continue;
            return e2.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(DOCTYPE, entityName, publicId, systemId);
    }

    public String resolveDocument() throws MalformedURLException, IOException {
        this.catalogManager.debug.message(3, "resolveDocument");
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e2 = (CatalogEntry)en.nextElement();
            if (e2.getEntryType() != DOCUMENT) continue;
            return e2.getEntryArg(0);
        }
        return this.resolveSubordinateCatalogs(DOCUMENT, null, null, null);
    }

    public String resolveEntity(String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        this.catalogManager.debug.message(3, "resolveEntity(" + entityName + "," + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(ENTITY, entityName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e2 = (CatalogEntry)en.nextElement();
            if (e2.getEntryType() == OVERRIDE) {
                over = e2.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e2.getEntryType() != ENTITY || !e2.getEntryArg(0).equals(entityName) || !over && systemId != null) continue;
            return e2.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(ENTITY, entityName, publicId, systemId);
    }

    public String resolveNotation(String notationName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved = null;
        this.catalogManager.debug.message(3, "resolveNotation(" + notationName + "," + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        if (publicId != null && (resolved = this.resolveLocalPublic(NOTATION, notationName, publicId, systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e2 = (CatalogEntry)en.nextElement();
            if (e2.getEntryType() == OVERRIDE) {
                over = e2.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e2.getEntryType() != NOTATION || !e2.getEntryArg(0).equals(notationName) || !over && systemId != null) continue;
            return e2.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(NOTATION, notationName, publicId, systemId);
    }

    public String resolvePublic(String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved;
        this.catalogManager.debug.message(3, "resolvePublic(" + publicId + "," + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (publicId != null && publicId.startsWith("urn:publicid:")) {
            publicId = PublicId.decodeURN(publicId);
        }
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            if (publicId != null && !publicId.equals(systemId)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                systemId = null;
            } else {
                publicId = systemId;
                systemId = null;
            }
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        resolved = this.resolveLocalPublic(PUBLIC, null, publicId, systemId);
        if (resolved != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(PUBLIC, null, publicId, systemId);
    }

    protected synchronized String resolveLocalPublic(int entityType, String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        String resolved;
        publicId = PublicId.normalize(publicId);
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        boolean over = this.default_override;
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e2 = (CatalogEntry)en.nextElement();
            if (e2.getEntryType() == OVERRIDE) {
                over = e2.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e2.getEntryType() != PUBLIC || !e2.getEntryArg(0).equals(publicId) || !over && systemId != null) continue;
            return e2.getEntryArg(1);
        }
        over = this.default_override;
        en = this.catalogEntries.elements();
        Vector<String> delCats = new Vector<String>();
        while (en.hasMoreElements()) {
            String p;
            CatalogEntry e3 = (CatalogEntry)en.nextElement();
            if (e3.getEntryType() == OVERRIDE) {
                over = e3.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (e3.getEntryType() != DELEGATE_PUBLIC || !over && systemId != null || (p = e3.getEntryArg(0)).length() > publicId.length() || !p.equals(publicId.substring(0, p.length()))) continue;
            delCats.addElement(e3.getEntryArg(1));
        }
        if (delCats.size() > 0) {
            Enumeration enCats = delCats.elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (enCats.hasMoreElements()) {
                    String delegatedCatalog = (String)enCats.nextElement();
                    this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
                }
            }
            Catalog dcat = this.newCatalog();
            enCats = delCats.elements();
            while (enCats.hasMoreElements()) {
                String delegatedCatalog = (String)enCats.nextElement();
                dcat.parseCatalog(delegatedCatalog);
            }
            return dcat.resolvePublic(publicId, null);
        }
        return null;
    }

    public String resolveSystem(String systemId) throws MalformedURLException, IOException {
        String resolved;
        this.catalogManager.debug.message(3, "resolveSystem(" + systemId + ")");
        systemId = this.normalizeURI(systemId);
        if (systemId != null && systemId.startsWith("urn:publicid:")) {
            systemId = PublicId.decodeURN(systemId);
            return this.resolvePublic(systemId, null);
        }
        if (systemId != null && (resolved = this.resolveLocalSystem(systemId)) != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(SYSTEM, null, null, systemId);
    }

    protected String resolveLocalSystem(String systemId) throws MalformedURLException, IOException {
        String osname = System.getProperty("os.name");
        boolean windows = osname.indexOf("Windows") >= 0;
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e2 = (CatalogEntry)en.nextElement();
            if (e2.getEntryType() != SYSTEM || !e2.getEntryArg(0).equals(systemId) && (!windows || !e2.getEntryArg(0).equalsIgnoreCase(systemId))) continue;
            return e2.getEntryArg(1);
        }
        en = this.catalogEntries.elements();
        String startString = null;
        String prefix2 = null;
        while (en.hasMoreElements()) {
            String p;
            CatalogEntry e3 = (CatalogEntry)en.nextElement();
            if (e3.getEntryType() != REWRITE_SYSTEM || (p = e3.getEntryArg(0)).length() > systemId.length() || !p.equals(systemId.substring(0, p.length())) || startString != null && p.length() <= startString.length()) continue;
            startString = p;
            prefix2 = e3.getEntryArg(1);
        }
        if (prefix2 != null) {
            return prefix2 + systemId.substring(startString.length());
        }
        en = this.catalogEntries.elements();
        String suffixString = null;
        String suffixURI = null;
        while (en.hasMoreElements()) {
            String p;
            CatalogEntry e4 = (CatalogEntry)en.nextElement();
            if (e4.getEntryType() != SYSTEM_SUFFIX || (p = e4.getEntryArg(0)).length() > systemId.length() || !systemId.endsWith(p) || suffixString != null && p.length() <= suffixString.length()) continue;
            suffixString = p;
            suffixURI = e4.getEntryArg(1);
        }
        if (suffixURI != null) {
            return suffixURI;
        }
        en = this.catalogEntries.elements();
        Vector<String> delCats = new Vector<String>();
        while (en.hasMoreElements()) {
            String p;
            CatalogEntry e5 = (CatalogEntry)en.nextElement();
            if (e5.getEntryType() != DELEGATE_SYSTEM || (p = e5.getEntryArg(0)).length() > systemId.length() || !p.equals(systemId.substring(0, p.length()))) continue;
            delCats.addElement(e5.getEntryArg(1));
        }
        if (delCats.size() > 0) {
            Enumeration enCats = delCats.elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (enCats.hasMoreElements()) {
                    String delegatedCatalog = (String)enCats.nextElement();
                    this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
                }
            }
            Catalog dcat = this.newCatalog();
            enCats = delCats.elements();
            while (enCats.hasMoreElements()) {
                String delegatedCatalog = (String)enCats.nextElement();
                dcat.parseCatalog(delegatedCatalog);
            }
            return dcat.resolveSystem(systemId);
        }
        return null;
    }

    public String resolveURI(String uri) throws MalformedURLException, IOException {
        String resolved;
        this.catalogManager.debug.message(3, "resolveURI(" + uri + ")");
        uri = this.normalizeURI(uri);
        if (uri != null && uri.startsWith("urn:publicid:")) {
            uri = PublicId.decodeURN(uri);
            return this.resolvePublic(uri, null);
        }
        if (uri != null && (resolved = this.resolveLocalURI(uri)) != null) {
            return resolved;
        }
        return this.resolveSubordinateCatalogs(URI, null, null, uri);
    }

    protected String resolveLocalURI(String uri) throws MalformedURLException, IOException {
        Enumeration en = this.catalogEntries.elements();
        while (en.hasMoreElements()) {
            CatalogEntry e2 = (CatalogEntry)en.nextElement();
            if (e2.getEntryType() != URI || !e2.getEntryArg(0).equals(uri)) continue;
            return e2.getEntryArg(1);
        }
        en = this.catalogEntries.elements();
        String startString = null;
        String prefix2 = null;
        while (en.hasMoreElements()) {
            String p;
            CatalogEntry e3 = (CatalogEntry)en.nextElement();
            if (e3.getEntryType() != REWRITE_URI || (p = e3.getEntryArg(0)).length() > uri.length() || !p.equals(uri.substring(0, p.length())) || startString != null && p.length() <= startString.length()) continue;
            startString = p;
            prefix2 = e3.getEntryArg(1);
        }
        if (prefix2 != null) {
            return prefix2 + uri.substring(startString.length());
        }
        en = this.catalogEntries.elements();
        String suffixString = null;
        String suffixURI = null;
        while (en.hasMoreElements()) {
            String p;
            CatalogEntry e4 = (CatalogEntry)en.nextElement();
            if (e4.getEntryType() != URI_SUFFIX || (p = e4.getEntryArg(0)).length() > uri.length() || !uri.endsWith(p) || suffixString != null && p.length() <= suffixString.length()) continue;
            suffixString = p;
            suffixURI = e4.getEntryArg(1);
        }
        if (suffixURI != null) {
            return suffixURI;
        }
        en = this.catalogEntries.elements();
        Vector<String> delCats = new Vector<String>();
        while (en.hasMoreElements()) {
            String p;
            CatalogEntry e5 = (CatalogEntry)en.nextElement();
            if (e5.getEntryType() != DELEGATE_URI || (p = e5.getEntryArg(0)).length() > uri.length() || !p.equals(uri.substring(0, p.length()))) continue;
            delCats.addElement(e5.getEntryArg(1));
        }
        if (delCats.size() > 0) {
            Enumeration enCats = delCats.elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (enCats.hasMoreElements()) {
                    String delegatedCatalog = (String)enCats.nextElement();
                    this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
                }
            }
            Catalog dcat = this.newCatalog();
            enCats = delCats.elements();
            while (enCats.hasMoreElements()) {
                String delegatedCatalog = (String)enCats.nextElement();
                dcat.parseCatalog(delegatedCatalog);
            }
            return dcat.resolveURI(uri);
        }
        return null;
    }

    protected synchronized String resolveSubordinateCatalogs(int entityType, String entityName, String publicId, String systemId) throws MalformedURLException, IOException {
        int catPos = 0;
        while (catPos < this.catalogs.size()) {
            Catalog c2 = null;
            try {
                c2 = (Catalog)this.catalogs.elementAt(catPos);
            }
            catch (ClassCastException e2) {
                String catfile = (String)this.catalogs.elementAt(catPos);
                c2 = this.newCatalog();
                try {
                    c2.parseCatalog(catfile);
                }
                catch (MalformedURLException mue) {
                    this.catalogManager.debug.message(1, "Malformed Catalog URL", catfile);
                }
                catch (FileNotFoundException fnfe) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, file not found", catfile);
                }
                catch (IOException ioe) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", catfile);
                }
                this.catalogs.setElementAt(c2, catPos);
            }
            String resolved = null;
            if (entityType == DOCTYPE) {
                resolved = c2.resolveDoctype(entityName, publicId, systemId);
            } else if (entityType == DOCUMENT) {
                resolved = c2.resolveDocument();
            } else if (entityType == ENTITY) {
                resolved = c2.resolveEntity(entityName, publicId, systemId);
            } else if (entityType == NOTATION) {
                resolved = c2.resolveNotation(entityName, publicId, systemId);
            } else if (entityType == PUBLIC) {
                resolved = c2.resolvePublic(publicId, systemId);
            } else if (entityType == SYSTEM) {
                resolved = c2.resolveSystem(systemId);
            } else if (entityType == URI) {
                resolved = c2.resolveURI(systemId);
            }
            if (resolved != null) {
                return resolved;
            }
            ++catPos;
        }
        return null;
    }

    protected String fixSlashes(String sysid) {
        return sysid.replace('\\', '/');
    }

    protected String makeAbsolute(String sysid) {
        URL local = null;
        sysid = this.fixSlashes(sysid);
        try {
            local = new URL(this.base, sysid);
        }
        catch (MalformedURLException e2) {
            this.catalogManager.debug.message(1, "Malformed URL on system identifier", sysid);
        }
        if (local != null) {
            return local.toString();
        }
        return sysid;
    }

    protected String normalizeURI(String uriref) {
        byte[] bytes2;
        String newRef = "";
        if (uriref == null) {
            return null;
        }
        try {
            bytes2 = uriref.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            this.catalogManager.debug.message(1, "UTF-8 is an unsupported encoding!?");
            return uriref;
        }
        int count2 = 0;
        while (count2 < bytes2.length) {
            int ch = bytes2[count2] & 0xFF;
            newRef = ch <= 32 || ch > 127 || ch == 34 || ch == 60 || ch == 62 || ch == 92 || ch == 94 || ch == 96 || ch == 123 || ch == 124 || ch == 125 || ch == 127 ? newRef + this.encodedByte(ch) : newRef + (char)bytes2[count2];
            ++count2;
        }
        return newRef;
    }

    protected String encodedByte(int b) {
        String hex = Integer.toHexString(b).toUpperCase();
        if (hex.length() < 2) {
            return "%0" + hex;
        }
        return "%" + hex;
    }

    protected void addDelegate(CatalogEntry entry2) {
        int pos = 0;
        String partial = entry2.getEntryArg(0);
        Enumeration local = this.localDelegate.elements();
        while (local.hasMoreElements()) {
            CatalogEntry dpe = (CatalogEntry)local.nextElement();
            String dp = dpe.getEntryArg(0);
            if (dp.equals(partial)) {
                return;
            }
            if (dp.length() > partial.length()) {
                ++pos;
            }
            if (dp.length() < partial.length()) break;
        }
        if (this.localDelegate.size() == 0) {
            this.localDelegate.addElement(entry2);
        } else {
            this.localDelegate.insertElementAt(entry2, pos);
        }
    }
}

