/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.helpers.FileURL;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class ResolvingParser
implements Parser,
DTDHandler,
DocumentHandler,
EntityResolver {
    public static boolean namespaceAware = true;
    public static boolean validating = false;
    public static boolean suppressExplanation = false;
    private SAXParser saxParser = null;
    private Parser parser = null;
    private DocumentHandler documentHandler = null;
    private DTDHandler dtdHandler = null;
    private CatalogManager catalogManager = CatalogManager.getStaticManager();
    private CatalogResolver catalogResolver = null;
    private CatalogResolver piCatalogResolver = null;
    private boolean allowXMLCatalogPI = false;
    private boolean oasisXMLCatalogPI = false;
    private URL baseURL = null;

    public ResolvingParser() {
        this.initParser();
    }

    public ResolvingParser(CatalogManager manager) {
        this.catalogManager = manager;
        this.initParser();
    }

    private void initParser() {
        this.catalogResolver = new CatalogResolver(this.catalogManager);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(namespaceAware);
        spf.setValidating(validating);
        try {
            this.saxParser = spf.newSAXParser();
            this.parser = this.saxParser.getParser();
            this.documentHandler = null;
            this.dtdHandler = null;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public Catalog getCatalog() {
        return this.catalogResolver.getCatalog();
    }

    public void parse(InputSource input2) throws IOException, SAXException {
        this.setupParse(input2.getSystemId());
        try {
            this.parser.parse(input2);
        }
        catch (InternalError ie) {
            this.explain(input2.getSystemId());
            throw ie;
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.setupParse(systemId);
        try {
            this.parser.parse(systemId);
        }
        catch (InternalError ie) {
            this.explain(systemId);
            throw ie;
        }
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver2) {
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.parser.setErrorHandler(handler);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.setLocale(locale);
    }

    public void characters(char[] ch, int start2, int length2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(ch, start2, length2);
        }
    }

    public void endDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument();
        }
    }

    public void endElement(String name) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(name);
        }
    }

    public void ignorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(ch, start2, length2);
        }
    }

    public void processingInstruction(String target2, String pidata) throws SAXException {
        if (target2.equals("oasis-xml-catalog")) {
            URL catalog = null;
            String data2 = pidata;
            int pos = data2.indexOf("catalog=");
            if (pos >= 0 && (data2 = data2.substring(pos + 8)).length() > 1) {
                String quote2 = data2.substring(0, 1);
                pos = (data2 = data2.substring(1)).indexOf(quote2);
                if (pos >= 0) {
                    data2 = data2.substring(0, pos);
                    try {
                        catalog = this.baseURL != null ? new URL(this.baseURL, data2) : new URL(data2);
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                }
            }
            if (this.allowXMLCatalogPI) {
                if (this.catalogManager.getAllowOasisXMLCatalogPI()) {
                    this.catalogManager.debug.message(4, "oasis-xml-catalog PI", pidata);
                    if (catalog != null) {
                        try {
                            this.catalogManager.debug.message(4, "oasis-xml-catalog", catalog.toString());
                            this.oasisXMLCatalogPI = true;
                            if (this.piCatalogResolver == null) {
                                this.piCatalogResolver = new CatalogResolver(true);
                            }
                            this.piCatalogResolver.getCatalog().parseCatalog(catalog.toString());
                        }
                        catch (Exception e2) {
                            this.catalogManager.debug.message(3, "Exception parsing oasis-xml-catalog: " + catalog.toString());
                        }
                    } else {
                        this.catalogManager.debug.message(3, "PI oasis-xml-catalog unparseable: " + pidata);
                    }
                } else {
                    this.catalogManager.debug.message(4, "PI oasis-xml-catalog ignored: " + pidata);
                }
            } else {
                this.catalogManager.debug.message(3, "PI oasis-xml-catalog occurred in an invalid place: " + pidata);
            }
        } else if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(target2, pidata);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.startDocument();
        }
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.documentHandler != null) {
            this.documentHandler.startElement(name, atts);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.dtdHandler != null) {
            this.dtdHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        this.allowXMLCatalogPI = false;
        String resolved = this.catalogResolver.getResolvedEntity(publicId, systemId);
        if (resolved == null && this.piCatalogResolver != null) {
            resolved = this.piCatalogResolver.getResolvedEntity(publicId, systemId);
        }
        if (resolved != null) {
            try {
                InputSource iSource = new InputSource(resolved);
                iSource.setPublicId(publicId);
                URL url = new URL(resolved);
                InputStream iStream = url.openStream();
                iSource.setByteStream(iStream);
                return iSource;
            }
            catch (Exception e2) {
                this.catalogManager.debug.message(1, "Failed to create InputSource (" + e2.toString() + ")", resolved);
                return null;
            }
        }
        return null;
    }

    private void setupParse(String systemId) {
        this.allowXMLCatalogPI = true;
        this.parser.setEntityResolver(this);
        this.parser.setDocumentHandler(this);
        this.parser.setDTDHandler(this);
        URL cwd = null;
        try {
            cwd = FileURL.makeURL("basename");
        }
        catch (MalformedURLException mue) {
            cwd = null;
        }
        try {
            this.baseURL = new URL(systemId);
        }
        catch (MalformedURLException mue) {
            if (cwd != null) {
                try {
                    this.baseURL = new URL(cwd, systemId);
                }
                catch (MalformedURLException mue2) {
                    this.baseURL = null;
                }
            }
            this.baseURL = null;
        }
    }

    private void explain(String systemId) {
        if (!suppressExplanation) {
            System.out.println("Parser probably encountered bad URI in " + systemId);
            System.out.println("For example, replace '/some/uri' with 'file:/some/uri'.");
        }
    }
}

