/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class JCEMapper {
    static Log log = LogFactory.getLog(JCEMapper.class.getName());
    private static Map uriToJCEName;
    private static Map algorithmsMap;
    private static String providerName;

    public static void init(Element element2) throws Exception {
        JCEMapper.loadAlgorithms((Element)element2.getElementsByTagName("Algorithms").item(0));
    }

    static void loadAlgorithms(Element element2) {
        Element[] elementArray = XMLUtils.selectNodes(element2.getFirstChild(), "http://www.xmlsecurity.org/NS/#configuration", "Algorithm");
        uriToJCEName = new HashMap(elementArray.length * 2);
        algorithmsMap = new HashMap(elementArray.length * 2);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element3 = elementArray[i];
            String string2 = element3.getAttribute("URI");
            String string3 = element3.getAttribute("JCEName");
            uriToJCEName.put(string2, string3);
            algorithmsMap.put(string2, new Algorithm(element3));
        }
    }

    static Algorithm getAlgorithmMapping(String string2) {
        return (Algorithm)algorithmsMap.get(string2);
    }

    public static String translateURItoJCEID(String string2) {
        if (log.isDebugEnabled()) {
            log.debug("Request for URI " + string2);
        }
        String string3 = (String)uriToJCEName.get(string2);
        return string3;
    }

    public static String getAlgorithmClassFromURI(String string2) {
        if (log.isDebugEnabled()) {
            log.debug("Request for URI " + string2);
        }
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string2)).algorithmClass;
    }

    public static int getKeyLengthFromURI(String string2) {
        return Integer.parseInt(((Algorithm)JCEMapper.algorithmsMap.get((Object)string2)).keyLength);
    }

    public static String getJCEKeyAlgorithmFromURI(String string2) {
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string2)).requiredKey;
    }

    public static String getProviderId() {
        return providerName;
    }

    public static void setProviderId(String string2) {
        providerName = string2;
    }

    static {
        providerName = null;
    }

    public static class Algorithm {
        String algorithmClass;
        String keyLength;
        String requiredKey;

        public Algorithm(Element element2) {
            this.algorithmClass = element2.getAttribute("AlgorithmClass");
            this.keyLength = element2.getAttribute("KeyLength");
            this.requiredKey = element2.getAttribute("RequiredKey");
        }
    }
}

