/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.Algorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.algorithms.implementations.IntegrityHmac;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Log log = LogFactory.getLog(SignatureAlgorithm.class.getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    static ThreadLocal instancesSigning = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal instancesVerify = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal keysSigning = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal keysVerify = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    protected SignatureAlgorithmSpi _signatureAlgorithm = null;
    private String algorithmURI;

    public SignatureAlgorithm(Document document2, String string2) throws XMLSecurityException {
        super(document2, string2);
        this.algorithmURI = string2;
    }

    private void initializeAlgorithm(boolean bl) throws XMLSignatureException {
        if (this._signatureAlgorithm != null) {
            return;
        }
        this._signatureAlgorithm = bl ? SignatureAlgorithm.getInstanceForSigning(this.algorithmURI) : SignatureAlgorithm.getInstanceForVerify(this.algorithmURI);
        this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
    }

    private static SignatureAlgorithmSpi getInstanceForSigning(String string2) throws XMLSignatureException {
        SignatureAlgorithmSpi signatureAlgorithmSpi = (SignatureAlgorithmSpi)((Map)instancesSigning.get()).get(string2);
        if (signatureAlgorithmSpi != null) {
            signatureAlgorithmSpi.reset();
            return signatureAlgorithmSpi;
        }
        signatureAlgorithmSpi = SignatureAlgorithm.buildSigner(string2, signatureAlgorithmSpi);
        ((Map)instancesSigning.get()).put(string2, signatureAlgorithmSpi);
        return signatureAlgorithmSpi;
    }

    private static SignatureAlgorithmSpi getInstanceForVerify(String string2) throws XMLSignatureException {
        SignatureAlgorithmSpi signatureAlgorithmSpi = (SignatureAlgorithmSpi)((Map)instancesVerify.get()).get(string2);
        if (signatureAlgorithmSpi != null) {
            signatureAlgorithmSpi.reset();
            return signatureAlgorithmSpi;
        }
        signatureAlgorithmSpi = SignatureAlgorithm.buildSigner(string2, signatureAlgorithmSpi);
        ((Map)instancesVerify.get()).put(string2, signatureAlgorithmSpi);
        return signatureAlgorithmSpi;
    }

    private static SignatureAlgorithmSpi buildSigner(String string2, SignatureAlgorithmSpi signatureAlgorithmSpi) throws XMLSignatureException {
        try {
            Class clazz2 = SignatureAlgorithm.getImplementingClass(string2);
            if (log.isDebugEnabled()) {
                log.debug("Create URI \"" + string2 + "\" class \"" + clazz2 + "\"");
            }
            signatureAlgorithmSpi = (SignatureAlgorithmSpi)clazz2.newInstance();
            return signatureAlgorithmSpi;
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string2, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public SignatureAlgorithm(Document document2, String string2, int n) throws XMLSecurityException {
        this(document2, string2);
        this.algorithmURI = string2;
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineSetHMACOutputLength(n);
        ((IntegrityHmac)this._signatureAlgorithm).engineAddContextToElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element2, String string2) throws XMLSecurityException {
        super(element2, string2);
        this.algorithmURI = this.getURI();
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        try {
            return SignatureAlgorithm.getInstanceForVerify(this.algorithmURI).engineGetJCEAlgorithmString();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return null;
        }
    }

    public String getJCEProviderName() {
        try {
            return SignatureAlgorithm.getInstanceForVerify(this.algorithmURI).engineGetJCEProviderName();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return null;
        }
    }

    public void update(byte[] byArray) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray);
    }

    public void update(byte by2) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(by2);
    }

    public void update(byte[] byArray, int n, int n2) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray, n, n2);
    }

    public void initSign(Key key) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        Map map3 = (Map)keysSigning.get();
        if (map3.get(this.algorithmURI) == key) {
            return;
        }
        map3.put(this.algorithmURI, key);
        this._signatureAlgorithm.engineInitSign(key);
    }

    public void initSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineInitSign(key, secureRandom);
    }

    public void initSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineInitSign(key, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(algorithmParameterSpec);
    }

    public void initVerify(Key key) throws XMLSignatureException {
        this.initializeAlgorithm(false);
        Map map3 = (Map)keysVerify.get();
        if (map3.get(this.algorithmURI) == key) {
            return;
        }
        map3.put(this.algorithmURI, key);
        this._signatureAlgorithm.engineInitVerify(key);
    }

    public boolean verify(byte[] byArray) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(byArray);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (log == null) {
            log = LogFactory.getLog(SignatureAlgorithm.class.getName());
        }
        log.debug("Init() called");
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string2, String string3) throws AlgorithmAlreadyRegisteredException, XMLSignatureException {
        String string4;
        Class clazz2;
        if (log.isDebugEnabled()) {
            log.debug("Try to register " + string2 + " " + string3);
        }
        if ((clazz2 = SignatureAlgorithm.getImplementingClass(string2)) != null && (string4 = clazz2.getName()) != null && string4.length() != 0) {
            Object[] objectArray = new Object[]{string2, string4};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            _algorithmHash.put(string2, Class.forName(string3));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string2, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    private static Class getImplementingClass(String string2) {
        if (_algorithmHash == null) {
            return null;
        }
        return (Class)_algorithmHash.get(string2);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }
}

