/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.implementations;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;

public class SignatureDSA
extends SignatureAlgorithmSpi {
    static Log log = LogFactory.getLog(SignatureDSA.class.getName());
    public static final String _URI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private Signature _signatureAlgorithm = null;

    protected String engineGetURI() {
        return _URI;
    }

    public SignatureDSA() throws XMLSignatureException {
        String string2 = JCEMapper.translateURItoJCEID(_URI);
        if (log.isDebugEnabled()) {
            log.debug("Created SignatureDSA using " + string2);
        }
        String string3 = JCEMapper.getProviderId();
        try {
            this._signatureAlgorithm = string3 == null ? Signature.getInstance(string2) : Signature.getInstance(string2, string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string2, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string2, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Called DSA.verify() on " + Base64.encode(byArray));
            }
            byte[] byArray2 = SignatureDSA.convertXMLDSIGtoASN1(byArray);
            return this._signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string2 = key.getClass().getName();
            String string3 = PublicKey.class.getName();
            Object[] objectArray = new Object[]{string2, string3};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Signature signature2 = this._signatureAlgorithm;
            try {
                this._signatureAlgorithm = Signature.getInstance(this._signatureAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception when reinstantiating Signature:" + exception);
                }
                this._signatureAlgorithm = signature2;
            }
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this._signatureAlgorithm.sign();
            return SignatureDSA.convertASN1toXMLDSIG(byArray);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string2 = key.getClass().getName();
            String string3 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string2, string3};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string2 = key.getClass().getName();
            String string3 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string2, string3};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte by2) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(by2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this._signatureAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._signatureAlgorithm.getProvider().getName();
    }

    private static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = n3 = byArray[3]; n4 > 0 && byArray[4 + n3 - n4] == 0; --n4) {
        }
        for (n2 = n = byArray[5 + n3]; n2 > 0 && byArray[6 + n3 + n - n2] == 0; --n2) {
        }
        if (byArray[0] != 48 || byArray[1] != byArray.length - 2 || byArray[2] != 2 || n4 > 20 || byArray[4 + n3] != 2 || n2 > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] byArray2 = new byte[40];
        System.arraycopy(byArray, 4 + n3 - n4, byArray2, 20 - n4, n4);
        System.arraycopy(byArray, 6 + n3 + n - n2, byArray2, 40 - n2, n2);
        return byArray2;
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        int n;
        int n2;
        if (byArray.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        for (n2 = 20; n2 > 0 && byArray[20 - n2] == 0; --n2) {
        }
        int n3 = n2;
        if (byArray[20 - n2] < 0) {
            ++n3;
        }
        for (n = 20; n > 0 && byArray[40 - n] == 0; --n) {
        }
        int n4 = n;
        if (byArray[40 - n] < 0) {
            ++n4;
        }
        byte[] byArray2 = new byte[6 + n3 + n4];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n3 + n4);
        byArray2[2] = 2;
        byArray2[3] = (byte)n3;
        System.arraycopy(byArray, 20 - n2, byArray2, 4 + n3 - n2, n2);
        byArray2[4 + n3] = 2;
        byArray2[5 + n3] = (byte)n4;
        System.arraycopy(byArray, 40 - n, byArray2, 6 + n3 + n4 - n, n);
        return byArray2;
    }

    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnDSA");
    }
}

