/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.implementations.CanonicalizerBase;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Canonicalizer20010315
extends CanonicalizerBase {
    boolean firstCall = true;
    final SortedSet result = new TreeSet(COMPARE);
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    XmlAttrStack xmlattrStack = new XmlAttrStack();

    public Canonicalizer20010315(boolean bl) {
        super(bl);
    }

    Iterator handleAttributesSubtree(Element element2, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        if (!element2.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        NamedNodeMap namedNodeMap = element2.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node4;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string2 = attr.getNamespaceURI();
            if (XMLNS_URI != string2) {
                sortedSet.add(attr);
                continue;
            }
            String string3 = attr.getLocalName();
            String string4 = attr.getValue();
            if ("xml".equals(string3) && XML_LANG_URI.equals(string4) || (node4 = nameSpaceSymbTable.addMappingAndRender(string3, string4, attr)) == null) continue;
            sortedSet.add(node4);
            if (!C14nHelper.namespaceIsRelative(attr)) continue;
            Object[] objectArray = new Object[]{element2.getTagName(), string3, attr.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
        if (this.firstCall) {
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            this.firstCall = false;
        }
        return sortedSet.iterator();
    }

    Iterator handleAttributes(Element element2, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Node node4;
        this.xmlattrStack.push(nameSpaceSymbTable.getLevel());
        boolean bl = this.isVisibleDO(element2, nameSpaceSymbTable.getLevel()) == 1;
        NamedNodeMap namedNodeMap = null;
        int n = 0;
        if (element2.hasAttributes()) {
            namedNodeMap = element2.getAttributes();
            n = namedNodeMap.getLength();
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        for (int i = 0; i < n; ++i) {
            node4 = (Attr)namedNodeMap.item(i);
            String string2 = node4.getNamespaceURI();
            if (XMLNS_URI != string2) {
                if (XML_LANG_URI == string2) {
                    this.xmlattrStack.addXmlnsAttr((Attr)node4);
                    continue;
                }
                if (!bl) continue;
                sortedSet.add(node4);
                continue;
            }
            String string3 = node4.getLocalName();
            String string4 = node4.getValue();
            if ("xml".equals(string3) && XML_LANG_URI.equals(string4)) continue;
            if (this.isVisible(node4)) {
                Node node5;
                if (!bl && nameSpaceSymbTable.removeMappingIfRender(string3) || (node5 = nameSpaceSymbTable.addMappingAndRender(string3, string4, (Attr)node4)) == null) continue;
                sortedSet.add(node5);
                if (!C14nHelper.namespaceIsRelative((Attr)node4)) continue;
                Object[] objectArray = new Object[]{element2.getTagName(), string3, node4.getNodeValue()};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
            if (bl && string3 != "xmlns") {
                nameSpaceSymbTable.removeMapping(string3);
                continue;
            }
            nameSpaceSymbTable.addMapping(string3, string4, (Attr)node4);
        }
        if (bl) {
            Attr attr = element2.getAttributeNodeNS(XMLNS_URI, "xmlns");
            node4 = null;
            if (attr == null) {
                node4 = nameSpaceSymbTable.getMapping("xmlns");
            } else if (!this.isVisible(attr)) {
                node4 = nameSpaceSymbTable.addMappingAndRender("xmlns", "", nullNode);
            }
            if (node4 != null) {
                sortedSet.add(node4);
            }
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
        }
        return sortedSet.iterator();
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set2, String string2) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    public byte[] engineCanonicalizeSubTree(Node node4, String string2) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    void circumventBugIfNeeded(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        if (!xMLSignatureInput.isNeedsToBeExpanded()) {
            return;
        }
        Document document2 = null;
        document2 = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
        XMLUtils.circumventBug2650(document2);
    }

    void handleParent(Element element2, NameSpaceSymbTable nameSpaceSymbTable) {
        if (!element2.hasAttributes()) {
            return;
        }
        this.xmlattrStack.push(-1);
        NamedNodeMap namedNodeMap = element2.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (XMLNS_URI != attr.getNamespaceURI()) {
                if (XML_LANG_URI != attr.getNamespaceURI()) continue;
                this.xmlattrStack.addXmlnsAttr(attr);
                continue;
            }
            String string2 = attr.getLocalName();
            String string3 = attr.getNodeValue();
            if ("xml".equals(string2) && XML_LANG_URI.equals(string3)) continue;
            nameSpaceSymbTable.addMapping(string2, string3, attr);
        }
    }

    static class XmlAttrStack {
        int currentLevel = 0;
        int lastlevel = 0;
        XmlsStackElement cur;
        List levels = new ArrayList();

        XmlAttrStack() {
        }

        void push(int n) {
            this.currentLevel = n;
            if (this.currentLevel == -1) {
                return;
            }
            this.cur = null;
            while (this.lastlevel >= this.currentLevel) {
                this.levels.remove(this.levels.size() - 1);
                if (this.levels.size() == 0) {
                    this.lastlevel = 0;
                    return;
                }
                this.lastlevel = ((XmlsStackElement)this.levels.get((int)(this.levels.size() - 1))).level;
            }
        }

        void addXmlnsAttr(Attr attr) {
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.levels.add(this.cur);
                this.lastlevel = this.currentLevel;
            }
            this.cur.nodes.add(attr);
        }

        void getXmlnsAttr(Collection collection) {
            int n = this.levels.size() - 1;
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.lastlevel = this.currentLevel;
                this.levels.add(this.cur);
            }
            boolean bl = false;
            XmlsStackElement xmlsStackElement = null;
            if (n == -1) {
                bl = true;
            } else {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                if (xmlsStackElement.rendered && xmlsStackElement.level + 1 == this.currentLevel) {
                    bl = true;
                }
            }
            if (bl) {
                collection.addAll(this.cur.nodes);
                this.cur.rendered = true;
                return;
            }
            HashMap<String, Attr> hashMap = new HashMap<String, Attr>();
            while (n >= 0) {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                Iterator iterator2 = xmlsStackElement.nodes.iterator();
                while (iterator2.hasNext()) {
                    Attr attr = (Attr)iterator2.next();
                    if (hashMap.containsKey(attr.getName())) continue;
                    hashMap.put(attr.getName(), attr);
                }
                --n;
            }
            this.cur.rendered = true;
            collection.addAll(hashMap.values());
        }

        static class XmlsStackElement {
            int level;
            boolean rendered = false;
            List nodes = new ArrayList();

            XmlsStackElement() {
            }
        }
    }
}

